# 16.10.TCP 封装器（TCP Wrapper）

TCP 包装器是一种基于主机的网络访问控制系统。通过在实际网络服务之前拦截传入的网络请求，TCP 包装器根据配置文件中预定义的规则评估源 IP 地址是否被允许访问或拒绝访问。

然而，尽管 TCP Wrappers 提供了基本的访问控制，但它们不应被视为更强大安全措施的替代品。为了全面保护，建议使用诸如防火墙、适当的用户身份验证实践和入侵检测系统等先进技术。

### 初始配置

TCP Wrappers 在 inetd(8) 中默认启用。因此，第一步将是启用 inetd(8)，执行以下命令：

```
# sysrc inetd_enable="YES"
# service inetd start
```

然后，正确配置/etc/hosts.allow。

|  | 与 TCP Wrappers 的其他实现不同，在 FreeBSD 中不推荐使用 hosts.deny。所有配置选项都应放在/etc/hosts.allow 中。|
| -- | --------------------------------------------------------------------------------------------------------------- |

在最简单的配置中，守护程序连接策略设置为允许或阻止，取决于/etc/hosts.allow 中的选项。FreeBSD 中的默认配置是允许通过 inetd 启动的所有守护程序的所有连接。

基本配置通常采取 daemon : address : action 的形式，其中 daemon 是 inetd 启动的守护进程，address 是有效的主机名、IP 地址或用方括号（[ ]）括起来的 IPv6 地址，action 要么为 allow，要么为 deny。TCP Wrappers 使用先匹配规则的语义，这意味着配置文件从开头开始扫描以寻找匹配规则。当找到匹配时，应用规则并停止搜索过程。

例如，要允许通过邮件/qpopper 守护程序进行 POP3 连接，应向/etc/hosts.allow 追加以下行：

```
# This line is required for POP3 connections:
qpopper : ALL : allow
```

每当编辑该文件时，请重启 inetd：

```
# service inetd restart
```

### 16.10.2. 高级配置

TCP 包装提供高级选项，能让更多对连接处理的控制。在某些情况下，可能适当向某些主机或守护程序连接返回注释。在其他情况下，应记录日志条目或向管理员发送电子邮件。其他情况可能需要仅用于本地连接的服务。通过使用称为通配符，扩展字符和外部命令执行的配置选项，所有这些都是可能的。要了解更多关于通配符及其相关功能的信息，请参阅 hosts_access(5)。
