# 16.11.访问控制列表（ACL）

访问控制列表（ACL）通过在用户和组在每个文件或每个目录的基础上进行细粒度的访问控制来扩展传统的 UNIX® 文件权限。每个 ACL 条目都定义了一个用户或组和相关权限，例如读取、写入和执行。FreeBSD 提供像 getfacl（1）和 setfacl（1）这样的命令来管理 ACL。

ACL（访问控制列表）在需要比标准权限更具体的访问控制情景中非常有用，通常用于多用户环境或共享主机中。然而，复杂性是不可避免的，需要仔细规划以确保提供所需的安全属性。

|  | FreeBSD 支持在 UFS 和 OpenZFS 中实现 NFSv4 ACL。请注意，setfacl(1)命令的一些参数仅适用于 POSIX ACL，另一些适用于 NFSv4 ACL。|
| -- | --------------------------------------------------------------------------------------------------------------------------------- |

### 16.11.1. 在 UFS 中启用 ACL 支持

ACL 是由挂载时间管理标志 acls 启用的，该标志可以添加到 /etc/fstab 中。

因此，需要访问 /etc/fstab，在选项部分添加 acls 标志如下：

```
# Device        Mountpoint        FStype    Options     Dump      Pass#
/dev/ada0s1a    /                 ufs       rw,acls     1         1
```

### 16.11.2. 获取 ACL 信息

通过使用 getfacl(1)检查文件或目录的 ACL 是可能的。

例如，要查看~/test 文件的 ACL 设置，请执行以下命令：

```
% getfacl test
```

如果使用 NFSv4 ACL，输出应类似于以下内容：

```
# file: test
# owner: freebsduser
# group: freebsduser
            owner@:rw-p--aARWcCos:-------:allow
            group@:r-----a-R-c--s:-------:allow
         everyone@:r-----a-R-c--s:-------:allow
```

使用 POSIX.1e ACLs 时，输出应该与以下内容类似：

```
# file: test
# owner: freebsduser
# group: freebsduser
user::rw-
group::r--
other::r--
```

### 16.11.3. 使用 ACL

可以使用 setfacl(1) 从文件或目录中添加、修改或删除 ACL。

如上所述，setfacl(1)的一些参数与 NFSv4 ACL 不兼容，反之亦然。本节涉及如何执行针对 POSIX ACL 和 NFSv4 ACL 的命令，并展示了两者的示例。

例如，要设置 POSIX.1e 默认 ACL 的强制元素：

```
% setfacl -d -m u::rwx,g::rx,o::rx,mask::rwx directory
```

另一个示例是为文件所有者的 POSIX.1e ACL 条目设置读、写和执行权限，以及为文件上的邮件组设置读和写权限：

```
% setfacl -m u::rwx,g:mail:rw file
```

要做与前一个示例中相同的操作，但在 NFSv4 ACL 中执行：

```
% setfacl -m owner@:rwxp::allow,g:mail:rwp::allow file
```

从 POSIX.1e ACL 中的文件中删除除三个必需条目之外的所有 ACL 条目：

```
% setfacl -bn file
```

从 NFSv4 ACL 中删除所有 ACL 条目：

```
% setfacl -b file
```

参考 getfacl(1)和 setfacl(1)了解有关这些命令可用选项的更多信息。
