# 16.13.进程审计

进程审计是一种安全方法，管理员可以跟踪系统资源的使用和分配情况，提供系统监视，并最少跟踪用户的命令。

进程审计既有积极的一面也有消极的一面。积极一面是入侵可能被缩小到入口点。消极的一面是进程审计产生的日志数量，以及它们可能需要的磁盘空间。本节将引导管理员了解进程审计的基础知识。

|  | 如果需要更精细的审计，参考安全事件审计。|
| -- | ------------------------------------------ |

### 16.13.1. 启用和利用进程审计

在使用进程审计之前，必须使用以下命令启用它：

```
# sysrc accounting_enable=yes
# service accounting start
```

审计信息存储在位于/var/account 的文件中，如果需要，在会计服务第一次启动时将自动创建该文件。这些文件包含敏感信息，包括所有用户发出的所有命令。写访问权限仅限于 root，读访问权限仅限于 root 和 wheel 组的成员。为了防止 wheel 成员也读取文件，更改/var/account 目录的模式以仅允许 root 访问。

若启用，会计将开始跟踪诸如 CPU 统计信息和执行的命令等信息。所有会计日志都以非可读格式保存，可以使用 sa(8)查看。如果不带任何选项发出，sa(8)将打印与每个用户调用次数，总经过时间（以分钟为单位），总 CPU 和用户时间（以分钟为单位）以及平均 I/O 操作数有关的信息。有关可控制输出的可用选项列表，请参阅 sa(8)。

显示用户发出的命令，请使用 lastcomm。

例如，此命令会打印出 trhodes 在 ttyp1 终端上的所有使用情况：

```
# lastcomm ls trhodes ttyp1
```

许多其他有用的选项存在并在 lastcomm(1), acct(5), 和 sa(8) 中有解释。
