# 16.14.资源限制

在 FreeBSD 中，资源限制是指控制和管理分配给进程和用户各种系统资源的机制。这些限制旨在防止单个进程或用户消耗过多资源，从而导致性能下降或系统不稳定。资源限制有助于确保系统上所有活动进程和用户之间的资源公平分配。

FreeBSD 提供了多种方法供管理员限制个人可以使用的系统资源量。

传统方法通过编辑 /etc/login.conf 定义登录类别。虽然此方法仍得到支持，但任何更改都需要一个多步骤过程，包括编辑此文件，重建资源数据库，对 /etc/master.passwd 进行必要更改，以及重建密码数据库。根据要配置的用户数量，这可能会变得耗时。

rctl(8) 可用于提供更精细的方法来控制资源限制。该命令支持不仅用户限制，还可以用于对进程和jail设置资源约束。

本节演示了控制资源的两种方法，从传统方法开始。

### 16.14.1. 资源类型

FreeBSD 提供各种类型的资源限制，包括：

表 1。资源类型

|类型|说明|
| ---------------------| -------------|
|CPU 时间|限制进程可消耗的 CPU 时间量|
|内存|控制进程可使用的物理内存量| 
|打开文件|限制进程可以同时打开的文件数| 
|进程|控制用户或进程可以创建的进程数| 
|文件大小|限制进程可以创建的文件的最大大小| 
|内核转储|控制进程是否能让生成核心转储文件| 
|网络资源|限制进程可以使用的网络资源量（例如套接字）|

对于类型的完整列表，请参阅 login.conf(5)和 rctl(8)。

### 16.14.2. 配置登录类别

在传统方法中，登录类别和适用于登录类别的资源限制在 /etc/login.conf 中定义。每个用户账户可以分配到一个登录类别，其中 default 是默认的登录类别。每个登录类别都有一组与之关联的登录能力。登录能力是一个 <em>name</em>=<em>value</em> 对，其中名称是一个众所周知的标识符，值是一个根据名称相应处理的任意字符串。

配置资源限制的第一步是执行以下命令打开 /etc/login.conf：

```
# ee /etc/login.conf
```

然后找到要修改的用户类别部分。在这个例子中，假设用户类别的名称是 limited，如果不存在则创建它。

```
limited:\ 
        :maxproc=50:\ 
        :tc=default: 
```

|  | 用户类的名称。                             |
| -- | ----------------------------------------------------------- |
|  | 将最大进程数（maxproc）设置为 50，适用于 limited 类用户。|
|  | 表示该用户类从“default”类继承默认设置。  |

修改 /etc/login.conf 文件后，运行 cap_mkdb(1) 来生成 FreeBSD 使用的数据库，以应用这些设置：

```
# cap_mkdb /etc/login.conf
```

通过执行以下命令，可以使用 chpass(1) 来将类更改为所需用户：

```
# chpass username
```

这将打开一个文本编辑器，在那里按如下方式添加新的 limited 类：

```
#Changing user information for username.
Login: username
Password: $6$2H.419USdGaiJeqK$6kgcTnDadasdasd3YnlNZsOni5AMymibkAfRCPirc7ZFjjv
DVsKyXx26daabdfqSdasdsmL/ZMUpdHiO0
Uid [#]: 1001
Gid [# or name]: 1001
Change [month day year]:
Expire [month day year]:
Class: limited
Home directory: /home/username
Shell: /bin/sh
Full Name: User &
Office Location:
Office Phone:
Home Phone:
Other information:
```

现在，分配给 limited 班级的用户将具有 50 的最大进程限制。请记住，这只是使用/etc/login.conf 文件设置资源限制的一个示例。

请记住，在对/etc/login.conf 文件进行更改后，用户需要注销并重新登录以使更改生效。此外，在编辑系统配置文件时，特别是在使用特权访问时，务必要小心谨慎。

### 16.14.3. 启用和配置资源限制

rctl(8)系统提供了一种更精细的设置和管理单个进程和用户资源限制的方式。它能让你动态地为特定进程或用户分配资源限制，而不考虑其用户类。

使用 rctl(8)的第一步将是将以下行添加到/boot/loader.conf 并重启系统：

```
kern.racct.enable=1
```

然后通过执行以下命令启用和启动 rctl(8)服务：

```
# sysrc rctl_enable="YES"
# service rctl start
```

然后可以使用 rctl(8)设置系统规则。

规则语法（rctl.conf(5)）是通过主体、主体 ID、资源和操作来控制的，就像这个示例规则中所示：

```
subject:subject-id:resource:action=amount/per
```

例如，为了限制用户最多只能添加 10 个进程，请执行以下命令：

```
# rctl -a user:username:maxproc:deny=10/user
```

检查应用的资源限制可以执行 rctl(8)命令：

```
# rctl
```

输出应类似于以下内容：

```
user:username:maxproc:deny=10
```

如果规则已添加到/etc/rctl.conf，则规则将在重启后保留。格式是一个规则，没有前面的命令。例如，可以将上一个规则添加为：

```
user:username:maxproc:deny=10
```
