# 16.15.监控第三方安全问题

近年来，安全世界在处理漏洞评估方面进行了许多改进。随着第三方实用程序被安装并配置到当今几乎所有操作系统中，系统入侵的威胁也在增加。

漏洞评估是安全的一个关键因素。虽然 FreeBSD 为基本系统发布公告，但对于每一个第三方实用程序都这样做超出了 FreeBSD 项目的能力范围。有一种方法可以减轻第三方漏洞并警告管理员已知的安全问题。一个名为 pkg 的 FreeBSD 附加实用程序专门包括用于此目的的选项。

pkg 定期通过一个数据库检索安全问题。该数据库由 FreeBSD 安全团队和 1001 名开发者更新和维护。

安装提供用于维护 pkg 审计数据库的定期(8)配置文件，并提供一种编程方法来保持其更新。

安装完成后，作为ports 的一部分审核第三方实用程序时，管理员可以随时选择更新数据库并查看已安装软件包的已知漏洞：

```
% pkg audit -F
```

输出应类似于以下内容：

```
vulnxml file up-to-date
chromium-116.0.5845.96_1 is vulnerable:
  chromium -- multiple vulnerabilities
  CVE: CVE-2023-4431
  CVE: CVE-2023-4427
  CVE: CVE-2023-4428
  CVE: CVE-2023-4429
  CVE: CVE-2023-4430
  WWW: https://vuxml.FreeBSD.org/freebsd/5fa332b9-4269-11ee-8290-a8a1599412c6.html

samba413-4.13.17_5 is vulnerable:
  samba -- multiple vulnerabilities
  CVE: CVE-2023-3347
  CVE: CVE-2023-34966
  CVE: CVE-2023-34968
  CVE: CVE-2022-2127
  CVE: CVE-2023-34967
  WWW: https://vuxml.FreeBSD.org/freebsd/441e1e1a-27a5-11ee-a156-080027f5fec9.html

2 problem(s) in 2 installed package(s) found.
```

通过将 Web 浏览器指向显示的 URL，管理员可以获取有关该漏洞的更多信息。

这将包括受影响的版本，由 FreeBSD port版本，以及其他可能包含安全通告的网站。
