# 16.16.FreeBSD 安全公告

像许多优质操作系统的生产商一样，FreeBSD 项目有一个负责确定每个 FreeBSD 版本的生命周期终点（EoL）日期并为尚未达到其 EoL 的受支持版本提供安全更新的安全团队。有关 FreeBSD 安全团队和受支持版本的更多信息，请访问 FreeBSD 安全页面。

安全团队的一项任务是响应 FreeBSD 操作系统中报告的安全漏洞。如果漏洞被确认，安全团队验证修复漏洞所需的步骤，并更新源代码以修复漏洞。然后将详细信息发布为"安全公告"。安全公告发布在 FreeBSD 网站上，并发送到 FreeBSD 安全通知邮件列表、FreeBSD 安全邮件列表和 FreeBSD 公告邮件列表。

### 16.16.1. 安全公告格式

这是一个 FreeBSD 安全公告的示例：

```
-----BEGIN PGP SIGNED MESSAGE-----
Hash: SHA512

=============================================================================
FreeBSD-SA-23:07.bhyve                                      Security Advisory
                                                          The FreeBSD Project

Topic:          bhyve privileged guest escape via fwctl

Category:       core
Module:         bhyve
Announced:      2023-08-01
Credits:        Omri Ben Bassat and Vladimir Eli Tokarev from Microsoft
Affects:        FreeBSD 13.1 and 13.2
Corrected:      2023-08-01 19:48:53 UTC (stable/13, 13.2-STABLE)
                2023-08-01 19:50:47 UTC (releng/13.2, 13.2-RELEASE-p2)
                2023-08-01 19:48:26 UTC (releng/13.1, 13.1-RELEASE-p9)
CVE Name:       CVE-2023-3494

For general information regarding FreeBSD Security Advisories,
including descriptions of the fields above, security branches, and the
following sections, please visit <URL:https://security.FreeBSD.org/>.

I.   Background

bhyve(8)'s fwctl interface provides a mechanism through which guest
firmware can query the hypervisor for information about the virtual
machine.  The fwctl interface is available to guests when bhyve is run
with the "-l bootrom" option, used for example when booting guests in
UEFI mode.

bhyve is currently only supported on the amd64 platform.

II.  Problem Description

The fwctl driver implements a state machine which is executed when the
guest accesses certain x86 I/O ports.  The interface lets the guest copy
a string into a buffer resident in the bhyve process' memory.  A bug in
the state machine implementation can result in a buffer overflowing when
copying this string.

III. Impact

A malicious, privileged software running in a guest VM can exploit the
buffer overflow to achieve code execution on the host in the bhyve
userspace process, which typically runs as root.  Note that bhyve runs
in a Capsicum sandbox, so malicious code is constrained by the
capabilities available to the bhyve process.

IV.  Workaround

No workaround is available.  bhyve guests that are executed without the
"-l bootrom" option are unaffected.

V.   Solution

Upgrade your vulnerable system to a supported FreeBSD stable or
release / security branch (releng) dated after the correction date.

Perform one of the following:

1) To update your vulnerable system via a binary patch:

Systems running a RELEASE version of FreeBSD on the amd64, i386, or
(on FreeBSD 13 and later) arm64 platforms can be updated via the
freebsd-update(8) utility:

# freebsd-update fetch
# freebsd-update install

Restart all affected virtual machines.

2) To update your vulnerable system via a source code patch:

The following patches have been verified to apply to the applicable
FreeBSD release branches.

a) Download the relevant patch from the location below, and verify the
detached PGP signature using your PGP utility.

[FreeBSD 13.2]
# fetch https://security.FreeBSD.org/patches/SA-23:07/bhyve.13.2.patch
# fetch https://security.FreeBSD.org/patches/SA-23:07/bhyve.13.2.patch.asc
# gpg --verify bhyve.13.2.patch.asc

[FreeBSD 13.1]
# fetch https://security.FreeBSD.org/patches/SA-23:07/bhyve.13.1.patch
# fetch https://security.FreeBSD.org/patches/SA-23:07/bhyve.13.1.patch.asc
# gpg --verify bhyve.13.1.patch.asc

b) Apply the patch.  Execute the following commands as root:

# cd /usr/src
# patch < /path/to/patch

c) Recompile the operating system using buildworld and installworld as
described in <URL:https://www.FreeBSD.org/handbook/makeworld.html>.

Restart all affected virtual machines.

VI.  Correction details

This issue is corrected by the corresponding Git commit hash or Subversion
revision number in the following stable and release branches:

Branch/path                             Hash                     Revision
- -------------------------------------------------------------------------
stable/13/                              9fe302d78109    stable/13-n255918
releng/13.2/                            2bae613e0da3  releng/13.2-n254625
releng/13.1/                            87702e38a4b4  releng/13.1-n250190
- -------------------------------------------------------------------------

Run the following command to see which files were modified by a
particular commit:

# git show --stat <commit hash>

Or visit the following URL, replacing NNNNNN with the hash:

<URL:https://cgit.freebsd.org/src/commit/?id=NNNNNN>

To determine the commit count in a working tree (for comparison against
nNNNNNN in the table above), run:

# git rev-list --count --first-parent HEAD

VII. References

<URL:https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-3494>

The latest revision of this advisory is available at
<URL:https://security.FreeBSD.org/advisories/FreeBSD-SA-23:07.bhyve.asc>
-----BEGIN PGP SIGNATURE-----

iQIzBAEBCgAdFiEEthUnfoEIffdcgYM7bljekB8AGu8FAmTJdsIACgkQbljekB8A
Gu8Q1Q/7BFw5Aa0cFxBzbdz+O5NAImj58MvKS6xw61bXcYr12jchyT6ENC7yiR+K
qCqbe5TssRbtZ1gg/94gSGEXccz5OcJGxW+qozhcdPUh2L2nzBPkMCrclrYJfTtM
cnmQKjg/wFZLUVr71GEM95ZFaktlZdXyXx9Z8eBzow5rXexpl1TTHQQ2kZZ41K4K
KFhup91dzGCIj02cqbl+1h5BrXJe3s/oNJt5JKIh/GBh5THQu9n6AywQYl18HtjV
fMb1qRTAS9WbiEP5QV2eEuOG86ucuhytqnEN5MnXJ2rLSjfb9izs9HzLo3ggy7yb
hN3tlbfIPjMEwYexieuoyP3rzKkLeYfLXqJU4zKCRnIbBIkMRy4mcFkfcYmI+MhF
NPh2R9kccemppKXeDhKJurH0vsetr8ti+AwOZ3pgO21+9w+mjE+EfaedIi+JWhip
hwqeFv03bAQHJdacNYGV47NsJ91CY4ZgWC3ZOzBZ2Y5SDtKFjyc0bf83WTfU9A/0
drC0z3xaJribah9e6k5d7lmZ7L6aHCbQ70+aayuAEZQLr/N1doB0smNi0IHdrtY0
JdIqmVX+d1ihVhJ05prC460AS/Kolqiaysun1igxR+ZnctE9Xdo1BlLEbYu2KjT4
LpWvSuhRMSQaYkJU72SodQc0FM5mqqNN42Vx+X4EutOfvQuRGlI=
=MlAY
-----END PGP SIGNATURE-----
```

每个安全公告都采用以下格式：

* 每个安全公告都由安全官的 PGP 密钥签名。安全官的公钥可以在 OpenPGP 密钥上验证。
* 每个安全公告的名称始终以 FreeBSD-SA- （用于 FreeBSD 安全公告）开头，后跟两位数字格式的年份（ 23: ），然后是该年份的公告编号（ 07. ），然后是受影响的应用程序或子系统的名称（ bhyve ）。
* Topic 字段总结了漏洞。
* Category 指的是系统中受影响的部分，可能是 core，contrib 或 ports 之一。core 类别表示漏洞影响了 FreeBSD 操作系统的核心组件。contrib 类别表示漏洞影响了包含在 FreeBSD 中的软件，例如 BIND。ports 类别表示漏洞影响通过ports 提供的软件。
* Module 字段指的是组件位置。在这个例子中，受影响的是 bhyve 模块；因此，这个漏洞影响了与操作系统一起安装的应用程序。
* Announced 字段反映了安全公告发布的日期。这意味着安全团队已经验证了问题的存在，并且已经提交了一个补丁到 FreeBSD 源代码仓库中。
* Credits 字段表示向注意到漏洞并报告它的个人或组织致谢。
* Affects 字段解释了哪些版本的 FreeBSD 受到这个漏洞的影响。
* Corrected 字段表示修正的日期、时间、时间偏移和发布的内容。括号中的部分显示每个已合并修复的分支，以及该分支对应发布的版本号。发布标识符本身包括版本号，如果适用，还包括补丁级别。补丁级别是字母 p 后面跟着一个数字，表示补丁的序号，使用户能够跟踪已应用到系统的补丁。'
* CVE Name 字段列出了在公共 cve.mitre.org 安全漏洞数据库中存在的咨询编号（如果存在）。'
* Background 字段提供了受影响模块的说明。
* 该 Problem Description 字段解释了漏洞。这可能包括有关有缺陷代码以及如何恶意使用该实用程序的信息。
* 该 Impact 字段说明了问题对系统可能产生的影响类型。
* 该 Workaround 字段指示是否有可供系统管理员立即修补系统的变通方法。
* Solution 字段提供了修补受影响系统的说明。这是一种经过逐步测试和验证的方法，可确保系统被修补并安全运行。
* Correction Details 字段显示出了每个受影响的 Subversion 或 Git 分支，并带有包含修正代码的修订号。
* References 字段提供有关漏洞的附加信息来源。
