# 16.3.账户安全

在 FreeBSD 中维护安全账户对于数据保密、系统完整性和特权分离至关重要，因为它可以防止未经授权的访问、恶意软件和数据泄露，同时确保合规性并保护组织的声誉。

### 16.3.1. 防止登录

在保护系统方面，一个很好的起点是对账户进行审核。禁用任何不需要登录访问的账户。

|  | 确保 root 设置一个强密码，并确保该密码不被分享。|
| -- | -------------------------------------------------- |

拒绝登录账户有两种方法。

第一个是锁定账户，此示例显示如何锁定 imani 账户：

```
# pw lock imani
```

第二种方法是通过将shell更改为/usr/sbin/nologin 来防止登录访问。nologin(8) shell 阻止系统在用户尝试登录时为其分配shell。

只有超级用户才能更改其他用户的shell：

```
# chsh -s /usr/sbin/nologin imani
```

### 16.3.2. 密码哈希

密码是技术的必要之恶。在必须使用它们时，它们应该是复杂的，并且应该使用强大的哈希机制来加密存储在密码数据库中的版本。FreeBSD 支持几种算法，包括 SHA256、SHA512 和 Blowfish 哈希算法，在其 crypt() 库中，请参阅有关详细信息的 crypt(3)。

SHA512 的默认值不应更改为一个安全性较低的哈希算法，但可以更改为更安全的 Blowfish 算法。

|  | Blowfish 不是 AES 的一部分，也不被认为符合任何联邦信息处理标准（FIPS）。在某些环境中可能不允许使用它。|
| -- | -------------------------------------------------------------------------------------------------------- |

要确定用于加密用户密码的哈希算法，超级用户可以查看 FreeBSD 密码数据库中用户的哈希。每个哈希都以一个表示用于加密密码的哈希机制类型的符号开头。

如果使用 DES 算法，则没有起始符号。对于 MD5，符号是 $。对于 SHA256 和 SHA512，符号是 $6$。对于 Blowfish，符号是 $2a$。在这个例子中，imani 的密码使用默认的 SHA512 算法进行哈希，因为哈希值以 $6$ 开头。请注意，存储在密码数据库中的是加密的哈希值，而不是密码本身。

```
# grep imani /etc/master.passwd
```

输出应该类似于以下内容：

```
imani:$6$pzIjSvCAn.PBYQBA$PXpSeWPx3g5kscj3IMiM7tUEUSPmGexxta.8Lt9TGSi2lNQqYGKszsBPuGME0:1001:1001::0:0:imani:/usr/home/imani:/bin/sh
```

哈希机制设置在用户的登录类中。

以下命令可用于检查当前正在使用的哈希机制：

```
# grep user /etc/master.passwd
```

输出应类似于以下内容：

```
:passwd_format=sha512:\
```

例如，要将算法更改为 Blowfish，请将该行修改为如下内容：

```
:passwd_format=blf:\
```

然后，必须执行 cap_mkdb(1)以升级 login.conf 数据库：

```
# cap_mkdb /etc/login.conf
```

请注意，此更改不会影响任何现有密码哈希。这意味着所有密码应该通过要求用户运行 passwd 来重新散列以更改他们的密码。

### 16.3.3. 密码策略执行

对于本地账户强制执行严格的密码策略是系统安全的基本方面。在 FreeBSD 中，可以使用内置的可插入认证模块（PAM）来实现密码长度、密码强度和密码复杂性。

本节演示如何配置最小和最大密码长度以及使用 pam_passwdqc(8)模块强制执行混合字符。当用户更改他们的密码时，将执行此模块。

要配置此模块，请成为超级用户，并取消注释包含 pam_passwdqc.so 的行在 /etc/pam.d/passwd 中。

然后，编辑该行以符合密码策略：

```
password        requisite       pam_passwdqc.so         min=disabled,disabled,disabled,12,10 similar=deny retry=3 enforce=users
```

参数的解释请参阅 pam_passwdqc(8)。

保存此文件后，用户更改密码时会看到类似以下内容的消息：

```
% passwd
```

输出应类似于以下内容：

```
Changing local password for user
Old Password:

You can now choose the new password.
A valid password should be a mix of upper and lower case letters,
digits and other characters.  You can use a 12 character long
password with characters from at least 3 of these 4 classes, or
a 10 character long password containing characters from all the
classes.  Characters that form a common pattern are discarded by
the check.
Alternatively, if no one else can see your terminal now, you can
pick this as your password: "trait-useful&knob".
Enter new password:
```

如果输入不符合策略的密码，系统将拒绝并发出警告，用户有机会再试，最多可重试配置的次数。

如果你的组织策略要求密码过期，FreeBSD 支持在/etc/login.conf 中用户登录类中的 passwordtime。

default 登录类包含一个示例：

```
#       :passwordtime=90d:\
```

因此，要为此登录类设置 90 天的到期时间，请删除注释符号（＃），保存编辑，并执行以下命令：

```
# cap_mkdb /etc/login.conf
```

要为单个用户设置到期日期或到期天数并指定用户名，传递到 pw ：

```
# pw usermod -p 30-apr-2025 -n user
```

此处可见，过期日期设置为日、月和年形式。有关更多信息，请参阅 pw(8)。

### 16.3.4. 与 sudo 共享管理

系统管理员经常需要授予用户增强权限的能力，以便他们执行特权任务。团队成员被授予访问 FreeBSD 系统以执行其特定任务的权限，将为每个管理员带来独特的挑战。这些团队成员只需要超越正常终端用户级别的一部分访问权限；然而，他们几乎总是告诉管理层他们无法在没有超级用户权限的情况下执行任务。幸运的是，没有理由向终端用户提供这样的访问权限，因为存在工具来管理这一确切要求。

|  | 即使管理员在不需要时也应限制其特权。|
| -- | -------------------------------------- |

到目前为止，安全章节已经涉及允许授权用户访问和试图防止未经授权访问。只要授权用户可以访问系统资源，另一个问题就出现了。在许多情况下，一些用户可能需要访问应用程序启动脚本，或者一组管理员需要维护系统。传统上，标准用户和组、文件权限，甚至 su(1)命令都会管理这种访问。随着应用程序需要更多的访问权限，越来越多的用户需要使用系统资源，需要更好的解决方案。目前最常用的应用程序是 Sudo。

Sudo 允许管理员配置对系统命令的更严格访问，并提供一些高级日志记录功能。作为一个工具，它可以从Ports收集中的 security/sudo 获取，或者通过 pkg(8)实用程序使用。

执行以下命令来安装它：

```
# pkg install sudo
```

安装完成后，安装的 visudo 将使用文本编辑器打开配置文件。强烈建议使用 visudo，因为它带有内置的语法检查器，可以在保存文件之前验证是否存在错误。

配置文件由几个小节组成，允许进行广泛的配置。在下面的示例中，Web 应用程序维护者 user1 需要启动、停止和重启名为 webservice 的 Web 应用程序。为了授予该用户执行这些任务的权限，请将此行添加到/usr/local/etc/sudoers 的末尾：

```
user1   ALL=(ALL)       /usr/sbin/service webservice *
```

用户现在可以使用这个命令启动 webservice：

```
% sudo /usr/sbin/service webservice start
```

虽然这种配置允许单个用户访问 webservice 服务；然而，在大多数组织中，有一个完整的 Web 团队负责管理该服务。单行也可以为整个团队提供访问权限。这些步骤将创建一个 Web 团队，将用户添加到该团队，并允许团队所有成员管理该服务：

```
# pw groupadd -g 6001 -n webteam
```

使用相同的 pw(8) 命令，将用户添加到 webteam 组：

```
# pw groupmod -m user1 -n webteam
```

最后，/usr/local/etc/sudoers 中的这行允许 webteam 组的任何成员管理 webservice：

```
%webteam   ALL=(ALL)       /usr/sbin/service webservice *
```

与 su(1)不同，sudo(8)只需要最终用户密码。这避免了共享密码，这是一种不良实践。

被允许使用 sudo(8)运行应用程序的用户只需输入自己的密码。这比 su(1)更安全，并且比 su(1)更好地控制了 root 权限，后者需要输入 root 密码。

```
%webteam   ALL=(ALL)       NOPASSWD: /usr/sbin/service webservice *
```

### 16.3.5. 通过 Doas 进行共享管理

doas(1) 是一个从 OpenBSD 移植的命令行实用程序。它在类 Unix 系统中作为广泛使用的 sudo(8) 命令的替代品。

使用 doas，用户可以以提升的权限执行命令，通常作为 root 用户，同时保持简化和注重安全的方法。与 sudo(8) 不同，doas 强调简单性和极简主义，专注于流畅的权限委派，而无需过多的配置选项。

执行以下命令安装它：

```
# pkg install doas
```

安装后，必须配置 /usr/local/etc/doas.conf 以授予用户对特定命令或角色的访问权限。

最简单的条目可能是以下内容，它在执行 doas 命令时授予用户 local_user 以 root 权限，而无需要求输入密码。

```
permit nopass local_user as root
```

安装和配置 doas 实用程序后，现在可以使用增强权限执行命令，例如：

```
$ doas vi /etc/rc.conf
```

有关更多配置示例，请阅读 doas.conf（5）。
