# 16.4.入侵检测系统（IDS）

验证系统文件和二进制文件的重要性在于它提供系统管理和安全团队关于系统变更的信息。监视系统变化的软件应用程序被称为入侵检测系统（IDS）。

FreeBSD 提供了一个名为 mtree(8)的基本入侵检测系统的本地支持。虽然每晚的安全电子邮件会通知管理员有关更改，但信息被存储在本地，并且存在恶意用户可能修改此信息以隐藏其对系统的更改的风险。因此，建议创建一个单独的二进制签名集并将其存储在一个只读的、属于 root 的目录上，或者更好的是存储在可移动的 USB 磁盘或远程服务器上。

还建议在每次更新后运行 freebsd-update IDS。

### 生成规范文件

内置的 mtree(8)实用程序可用于生成目录内容的规范。种子或数值常量用于生成规范，并且需要用于检查规范是否发生了变化。这样可以确定文件或二进制文件是否已被修改。由于攻击者不知道种子值，因此伪造或检查文件的校验值将变得困难或几乎不可能。

|  | 建议为包含二进制文件和配置文件的目录以及包含敏感数据的任何目录创建规范。通常，会为/bin、/sbin、/usr/bin、/usr/sbin、/usr/local/bin、/etc 和/usr/local/etc 创建规范。|
| -- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

以下示例生成一组 sha512 哈希值，每个系统二进制文件在/bin 中都有一个，然后将这些值保存在用户家目录的隐藏文件中，即/home/user/.bin_chksum_mtree:

```
# mtree -s 123456789 -c -K cksum,sha512 -p /bin > /home/user/.bin_chksum_mtree
```

输出应该类似于以下内容：

```
mtree: /bin checksum: 3427012225
```

|  | 123456789 值表示种子，应随机选择。这个值应该被记住，但不要共享。<br /><br />保持种子值和校验和输出对恶意用户隐藏是很重要的。|
| -- | ----------------------------------------------------------------------------------------------------------------------- |

### 16.4.2. 规范文件结构

mtree 格式是一种说明文件系统对象的文本格式。这种文件通常用于创建或验证目录层次结构。

一个 mtree 文件由一系列行组成，每行提供关于单个文件系统对象的信息。前导空格始终被忽略。

创建上面创建的规范文件将用于解释格式和内容：

```
#          user: root 
#       machine: machinename 
#          tree: /bin 
#          date: Thu Aug  24 21:58:37 2023 

# .
/set type=file uid=0 gid=0 mode=0555 nlink=1 flags=uarch 
.               type=dir mode=0755 nlink=2 time=1681388848.239523000 
    \133        nlink=2 size=12520 time=1685991378.688509000 \
                cksum=520880818 \
                sha512=5c1374ce0e2ba1b3bc5a41b23f4bbdc1ec89ae82fa01237f376a5eeef41822e68f1d8f75ec46b7bceb65396c122a9d837d692740fdebdcc376a05275adbd3471
    cat         size=14600 time=1685991378.694601000 cksum=3672531848 \ 
                sha512=b30b96d155fdc4795432b523989a6581d71cdf69ba5f0ccb45d9b9e354b55a665899b16aee21982fffe20c4680d11da4e3ed9611232a775c69f926e5385d53a2
    chflags     size=8920 time=1685991378.700385000 cksum=1629328991 \
                sha512=289a088cbbcbeb436dd9c1f74521a89b66643976abda696b99b9cc1fbfe8b76107c5b54d4a6a9b65332386ada73fc1bbb10e43c4e3065fa2161e7be269eaf86a
    chio        size=20720 time=1685991378.706095000 cksum=1948751604 \
                sha512=46f58277ff16c3495ea51e74129c73617f31351e250315c2b878a88708c2b8a7bb060e2dc8ff92f606450dbc7dd2816da4853e465ec61ee411723e8bf52709ee
    chmod       size=9616 time=1685991378.712546000 cksum=4244658911 \
                sha512=1769313ce08cba84ecdc2b9c07ef86d2b70a4206420dd71343867be7ab59659956f6f5a458c64e2531a1c736277a8e419c633a31a8d3c7ccc43e99dd4d71d630
```

|  | 创建规范的用户。                                                        |
| -- | ---------------------------------------------------------------------------------------- |
|  | 机器的主机名。                                                          |
|  | 目录路径。                                                              |
|  | 规范创建时间。                                                          |
|  | /set 特殊命令，定义从分析的文件中获得的某些设置。                       |
|  | 指的是解析目录，并指示诸如其类型、模式、硬链接数量和自修改以来的 UNIX 格式时间等内容。|
|  | 指的是文件，并显示其大小、时间和一系列哈希列表，用于验证完整性。        |

### 验证规范文件

验证二进制签名是否未更改，将当前目录内容与先前生成的规范进行比较，并将结果保存到文件中。

此命令需要用于生成原始规范的种子：

```
# mtree -s 123456789 -p /bin < /home/user/.bin_chksum_mtree >> /home/user/.bin_chksum_output
```

这应该为/bin 目录产生与创建规范时产生的相同的校验和。如果此目录中的二进制文件未发生更改，则/home/user/.bin_chksum_output 输出文件将为空。

模拟变更，请使用 touch(1)更改/bin/cat 上的日期，然后再次运行验证命令：

```
# touch /bin/cat
```

再次运行验证命令：

```
# mtree -s 123456789 -p /bin < /home/user/.bin_chksum_mtree >> /home/user/.bin_chksum_output
```

然后检查输出文件的内容：

```
# cat /root/.bin_chksum_output
```

输出应该类似于以下内容：

```
cat:    modification time (Fri Aug 25 13:30:17 2023, Fri Aug 25 13:34:20 2023)
```

|  | 这只是一个示例，展示执行命令时将显示的内容，显示元数据中将发生的更改。|
| -- | ------------------------------------------------------------------------ |
