# 16.5.安全等级

securelevel 是内核中实现的安全机制。当 securelevel 为正时，内核限制某些任务；即使是超级用户（root）也不被允许执行这些任务。

安全级别机制限制了以下能力：

* 取消某些文件标志，比如 schg （系统不可变标志）。
* 通过 /dev/mem 和 /dev/kmem 写入内核内存。
* 载入内核模块。
* 修改防火墙规则。

### 16.5.1. 安全级别定义

内核以五个不同的安全级别运行。任何超级用户进程都可以提升级别，但任何进程都不能降低它。

安全定义为：

永久不安全模式-始终以不安全模式运行系统。这是默认初始值。

0 不安全模式 - 不可变和只添加标志可能会被关闭。所有设备可能被读取或写入，视其权限而定。

1 安全模式 - 系统不可变和系统只附加标志可能无法关闭；已装载文件系统的磁盘、/dev/mem 和 /dev/kmem 可能无法打开进行写入；/dev/io（如果你的平台支持）可能根本无法打开；内核模块（参阅 kld(4)）可能无法加载或卸载。不能使用 debug.kdb.enter sysctl 进入内核调试器。不能使用 debug.kdb.panic、debug.kdb.panic_str 和其他 sysctl 强制发生紧急情况或陷阱。

2 高度安全模式 - 与安全模式相同，另外磁盘无论是否已安装都不可打开进行写入（除了使用 mount(2)）。此级别禁止通过卸载它们来篡改文件系统，但也抑制了在系统处于多用户状态时运行 newfs(8)。

3 网络安全模式 - 与高度安全模式相同，加上 IP 数据包过滤规则（参见 ipfw(8)、ipfirewall(4) 和 pfctl(8)）无法更改，且 dummynet(4) 或 pf(4) 配置无法调整。

|  | 简而言之，在 FreeBSD 安全级别中，Insecure Mode 和 Permanently Insecure Mode 之间的关键区别在于它们提供的安全程度。Permanently Insecure Mode 完全解除所有安全限制，而 Insecure Mode 放宽了一些限制，但仍保持一定程度的控制和安全性。|
| -- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

### 16.5.2. 修改安全级别

为了改变系统的安全级别，需要通过执行以下命令激活 kern_securelevel_enable ：

```
# sysrc kern_securelevel_enable="YES"
```

然后将 kern_securelevel 的值设置为所需的安全级别：

```
# sysrc kern_securelevel=2
```

要检查正在运行系统上安全级别的状态，请执行以下命令：

```
# sysctl -n kern.securelevel
```

输出包含了 securelevel 的当前值。如果它大于 0，那么至少有一些 securelevel 的保护是启用的。
