# 16.6.文件标志位

文件标志允许用户将附加的元数据或属性附加到文件和目录，超出基本权限和所有权。这些标志提供了一种控制文件的各种行为和属性的方式，而无需创建特殊目录或使用扩展属性。

文件标志可以用来实现不同的目标，比如防止文件删除、使文件只能追加、同步文件更新等。在 FreeBSD 中一些常用的文件标志包括“immutable”标志，它可以防止文件被修改或删除，以及“append-only”标志，它只允许在文件末尾添加数据但不能修改或删除。

这些标志可以使用 FreeBSD 中的 chflags(1)命令来管理，为管理员和用户提供对其文件和目录行为和特性更大的控制。值得注意的是，文件标志通常由 root 用户或拥有适当权限的用户管理，因为它们会影响文件的访问和操作方式。一些标志仅供文件所有者使用，详见 chflags(1)。

### 16.6.1. 使用文件标志

在本示例中，用户的主目录中的一个名为~/important.txt 的文件希望得到保护，防止被删除。

执行以下命令设置 schg 文件标志：

```
# chflags schg ~/important.txt
```

当任何用户，包括 root 用户，尝试删除文件时，系统将显示消息：

```
rm: important.txt: Operation not permitted
```

要删除该文件，需要通过执行以下命令来删除该文件的文件标志：

```
# chflags noschg ~/important.txt
```

可在 chflags(1)中找到支持的文件标志及其功能的列表。
