# 16.7.OpenSSH

OpenSSH 是一组网络连接工具，用于提供安全访问远程机器。此外，TCP/IP 连接可以通过 SSH 连接安全地进行隧道或转发。OpenSSH 加密所有流量以消除窃听、连接劫持和其他网络级攻击。

OpenSSH 由 OpenBSD 项目维护，并默认安装在 FreeBSD 中。

当数据以未加密形式通过网络发送时，在客户端和服务器之间的任何位置都可能有网络嗅探器窃取用户/密码信息或会话期间传输的数据。OpenSSH 提供各种认证和加密方法，以防止这种情况发生。

有关 OpenSSH 的更多信息，请参阅网页。

本节介绍了用于安全访问其他系统和从 FreeBSD 系统安全传输文件的内置客户端实用工具的概述。然后说明了如何在 FreeBSD 系统上配置 SSH 服务器。

|  | 正如所述，本章将涉及 OpenSSH 的基本系统版本。OpenSSH 的一个版本也可在 security/openssh-portable 中找到，它提供了额外的配置选项并定期更新。|
| -- | -------------------------------------------------------------------------------------------------------------------------------------------- |

### 16.7.1. 使用 SSH 客户端实用程序

要登录 SSH 服务器，使用 ssh(1) 并指定存在于该服务器上的用户名以及服务器的 IP 地址或主机名。如果这是第一次连接到指定的服务器，用户将被提示首先验证服务器的指纹：

```
# ssh user@example.com
```

输出应该类似于以下内容：

```
The authenticity of host 'example.com (10.0.0.1)' can't be established.
ECDSA key fingerprint is 25:cc:73:b5:b3:96:75:3d:56:19:49:d2:5c:1f:91:3b.
Are you sure you want to continue connecting (yes/no)? yes
Permanently added 'example.com' (ECDSA) to the list of known hosts.
Password for user@example.com: user_password
```

SSH 利用密钥指纹系统在客户端连接时验证服务器的真实性。当用户在第一次连接时通过键入 yes 来接受密钥的指纹时，密钥的副本会保存到用户的家目录下的 ~/.ssh/known_hosts 中。将来的登录尝试会针对保存的密钥进行验证，如果服务器的密钥与保存的密钥不匹配，则 ssh(1) 会显示警告。如果发生这种情况，用户应首先验证为什么密钥已更改，然后再继续连接。

|  | 本章節範圍之外如何執行此檢查。|
| -- | -------------------------------- |

使用 scp(1)來安全地從遠端機器複製文件。

這個例子將遠端系統上的 COPYRIGHT 複製到本地系統當前目錄中同名文件：

```
# scp user@example.com:/COPYRIGHT COPYRIGHT
```

输出应类似于以下内容：

```
Password for user@example.com: *******
COPYRIGHT            100% |*****************************|  4735
```

由于已验证此主机的指纹，因此在提示用户输入密码之前，服务器的密钥会自动进行检查。

传递给 scp(1)的参数类似于 cp(1)。要复制的文件或文件是第一个参数，要复制到的目标是第二个参数。由于文件是通过网络获取的，一个或多个文件参数采用 user@host:<path_to_remote_file> 的形式。请注意，以递归方式复制目录时，scp(1)使用 -r，而 cp(1)则使用 -R。

使用 sftp(1)打开交互式会话以进行文件复制。

在 sftp(1)会话中，参考可用命令列表。

### 16.7.2. 基于密钥的身份验证

不使用密码，可以配置客户端使用密钥连接到远程计算机。出于安全原因，这是首选方法。

ssh-keygen(1)可用于生成身份验证密钥。要生成公钥和私钥对，请指定密钥类型并按照提示操作。建议使用一个难以猜测但易记的密码保护密钥。

```
% ssh-keygen -t rsa -b 4096
```

输出应类似于以下内容：

```
Generating public/private rsa key pair.
Enter file in which to save the key (/home/user/.ssh/id_rsa):
Created directory '/home/user/.ssh/.ssh'.
Enter passphrase (empty for no passphrase):
Enter same passphrase again:
Your identification has been saved in /home/user/.ssh/id_rsa.
Your public key has been saved in /home/user/.ssh/id_rsa.pub.
The key fingerprint is:
SHA256:54Xm9Uvtv6H4NOo6yjP/YCfODryvUU7yWHzMqeXwhq8 user@host.example.com
The key's randomart image is:
+---[RSA 2048]----+
|                 |
|                 |
|                 |
|        . o..    |
|       .S*+*o    |
|      . O=Oo . . |
|       = Oo= oo..|
|      .oB.* +.oo.|
|       =OE**.o..=|
+----[SHA256]-----+
```

密钥存储在~/.ssh/id_rsa，公钥存储在~/.ssh/id_rsa.pub。公钥必须复制到远程计算机上的~/.ssh/authorized_keys 才能实现基于密钥的认证。

|  | 使用 OpenSSH 密钥的密码短语是一种关键的安全实践，提供了额外的保护层，防止未经授权访问，增强了整体网络安全性。<br /><br />在遗失或盗窃的情况下，这增加了另一个安全层级。|
| -- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------- |

### SSH 通道

OpenSSH 具有创建一个隧道以在加密会话中封装另一个协议的能力。

以下命令告诉 ssh(1)创建一个隧道：

```
% ssh -D 8080 user@example.com
```

此示例使用以下选项：

-D 指定本地“动态”应用级port转发。

user@foo.example.com 要在指定的远程 SSH 服务器上使用的登录名。

通过在指定的 localport 上创建侦听套接字，SSH 隧道的工作原理是在 localhost 上。

此方法可用于封装任意数量的不安全 TCP 协议，如 SMTP，POP3 和 FTP。

### 16.7.4. 启用 SSH 服务器

除了提供内置的 SSH 客户端实用程序外，FreeBSD 系统还可以配置为 SSH 服务器，接受来自其他 SSH 客户端的连接。

|  | 正如所述，本章将涉及 OpenSSH 的基本系统版本。请不要混淆 security/openssh-portable，这是随 FreeBSD 一起提供的 OpenSSH 版本。|
| -- | ----------------------------------------------------------------------------------------------------------------------------- |

为了使 SSH 服务器在重启时启用，请执行以下命令：

```
# sysrc sshd_enable="YES"
```

执行以下命令以启用服务：

```
# service sshd start
```

在 FreeBSD 系统上首次启动 sshd 时，系统的主机密钥将自动创建，并且指纹将显示在控制台上。提供用户指纹，以便他们首次连接到服务器时进行验证。

参考 sshd（8）可用选项列表，了解在启动 sshd 时以及关于身份验证、登录过程和各种配置文件的完整讨论。

到这一点，sshd 应该对系统上所有具有用户名和密码的用户可用。

### 16.7.5. 配置公钥身份验证方法

将 OpenSSH 配置为使用公钥身份验证可通过利用非对称加密进行身份验证来增强安全性。此方法消除了与密码相关的风险，例如弱密码或传输过程中的拦截，同时挫败各种基于密码的攻击。然而，非常重要的是确保私钥受到良好保护，以防止未经授权的访问。

第一步是配置 sshd(8)以使用所需的身份验证方法。

编辑/etc/ssh/sshd_config 并取消注释以下配置：

```
PubkeyAuthentication yes
```

配置完成后，用户将不得不将他们的公钥发送给系统管理员，这些密钥将被添加到.ssh/authorized_keys 中。生成密钥的过程在基于密钥的身份验证中有说明。

然后执行以下命令重启服务器：

```
# service sshd reload
```

强烈建议遵循 SSH 服务器安全选项中指示的安全改进。

### 16.7.6. SSH 服务器安全选项

尽管 sshd 是 FreeBSD 中最广泛使用的远程管理工具，但针对暴露在公共网络上的任何系统的暴力和袭击很常见。

还有几个额外的参数可用于防止这些攻击的成功，将在本节中进行说明。所有配置将在 /etc/ssh/sshd_config 中完成。

|  | 不要将 /etc/ssh/sshd_config 与 /etc/ssh/ssh_config 混淆（注意第一个文件名中的额外 d ）。第一个文件配置服务器，第二个文件配置客户端。参阅 sshconfig(5) 以获取可用客户端设置的列表。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |

默认情况下，可以使用 Pubkey 和密码进行身份验证。要仅允许 Pubkey 身份验证（强烈推荐），请更改变量：

```
PasswordAuthentication no
```

使用 OpenSSH 服务器配置文件中的 AllowUsers 关键字限制可以登录 SSH 服务器以及从哪里登录的用户是个不错的主意。例如，要求仅允许 user 从 192.168.1.32 登录，请将以下行添加到/etc/ssh/sshd_config 中：

```
AllowUsers user@192.168.1.32
```

要允许 user 从任何地方登录，请列出该用户但不指定 IP 地址：

```
AllowUsers user
```

多个用户应该在同一行上列出，就像这样：

```
AllowUsers root@192.168.1.32 user
```

在做出所有更改之后，在重启服务之前，建议通过执行以下命令来验证所做的配置是否正确：

```
# sshd -t
```

如果配置文件正确，将不会显示任何输出。如果配置文件不正确，它会显示类似于这样的内容：

```
/etc/ssh/sshd_config: line 3: Bad configuration option: sdadasdasdasads
/etc/ssh/sshd_config: terminating, 1 bad configuration options
```

在进行更改并检查配置文件正确后，告诉 sshd 通过运行重新加载其配置文件：

```
# service sshd reload
```
