# 16.8.OpenSSL

OpenSSL 是一个实现安全套接字层（SSL）和传输层安全（TLS）网络协议以及许多密码学例程的密码学工具包。

OpenSSL 程序是一个命令行工具，用于从 OpenSSL 的密码库中使用各种加密功能。可以用于

* 创建和管理私钥、公钥和参数
* 公钥加密操作
* 创建 X.509 证书、证书请求(CSR)和证书吊销列表(CRL)
* 计算消息摘要
* 使用密码进行加密和解密
* SSL/TLS 客户端和服务器测试
* 处理 S/MIME 签名或加密邮件
* 时间戳请求、生成和验证
* 加密例程基准测试

欲了解更多有关 OpenSSL 的信息，请阅读免费的 OpenSSL Cookbook。

### 16.8.1. 生成证书

OpenSSL 支持生成用于由 CA 验证和自己使用的证书。

运行 openssl(1)命令，使用以下参数生成 CA 的有效证书。该命令将在当前目录中创建两个文件。证书请求 req.pem 可以发送给 CA，CA 将验证输入的凭据，签署请求并返回已签署的证书。第二个文件 cert.key 是证书的私钥，应存储在安全位置。如果此文件落入他人手中，可能被用来冒充用户或服务器。

执行以下命令生成证书：

```
# openssl req -new -nodes -out req.pem -keyout cert.key -sha3-512 -newkey rsa:4096
```

输出应类似于以下内容：

```
Generating a RSA private key
..................................................................................................................................+++++
......................................+++++
writing new private key to 'cert.key'
-----
You are about to be asked to enter information that will be incorporated
into your certificate request.
What you are about to enter is what is called a Distinguished Name or a DN.
There are quite a few fields but you can leave some blank
For some fields there will be a default value,
If you enter '.', the field will be left blank.
-----
Country Name (2 letter code) [AU]:ES
State or Province Name (full name) [Some-State]:Valencian Community
Locality Name (eg, city) []:Valencia
Organization Name (eg, company) [Internet Widgits Pty Ltd]:My Company
Organizational Unit Name (eg, section) []:Systems Administrator
Common Name (e.g. server FQDN or YOUR name) []:localhost.example.org
Email Address []:user@FreeBSD.org

Please enter the following 'extra' attributes
to be sent with your certificate request
A challenge password []:123456789
An optional company name []:Another name
```

或者，如果不需要 CA 签名，则可以创建自签名证书。这将在当前目录中创建两个新文件：一个私钥文件 cert.key 和证书本身 cert.crt。应该将这些文件放在一个目录中，最好位于 /etc/ssl/ 下，该目录只能被 root 读取。这些文件的权限应该为 0700，可以使用 chmod 进行设置。

执行以下命令以生成证书：

```
# openssl req -new -x509 -days 365 -sha3-512 -keyout /etc/ssl/private/cert.key -out /etc/ssl/certs/cert.crt
```

输出应该类似于以下内容：

```
Generating a RSA private key
........................................+++++
...........+++++
writing new private key to '/etc/ssl/private/cert.key'
Enter PEM pass phrase:
Verifying - Enter PEM pass phrase:
-----
You are about to be asked to enter information that will be incorporated
into your certificate request.
What you are about to enter is what is called a Distinguished Name or a DN.
There are quite a few fields but you can leave some blank
For some fields there will be a default value,
If you enter '.', the field will be left blank.
-----
Country Name (2 letter code) [AU]:ES
State or Province Name (full name) [Some-State]:Valencian Community
Locality Name (eg, city) []:Valencia
Organization Name (eg, company) [Internet Widgits Pty Ltd]:My Company
Organizational Unit Name (eg, section) []:Systems Administrator
Common Name (e.g. server FQDN or YOUR name) []:localhost.example.org
Email Address []:user@FreeBSD.org
```

### 16.8.2. 配置 FIPS 提供者

随着 OpenSSL 3 的引入到基本系统（在 FreeBSD 14 及更高版本中），系统引入了其新的提供者模块概念。除了库中内置的默认提供者模块外，传统模块实现了现在可选的已弃用的密码算法，而 fips 模块则将 OpenSSL 实现限制为符合 FIPS 标准集的密码算法。OpenSSL 的这部分特别关注，包括一系列相关的安全问题列表，并定期接受 FIPS 140 验证流程。FIPS 验证版本列表也可用。这使用户可以确保他们在使用 OpenSSL 时符合 FIPS 标准。

重要的是，fips_module(7) 受到额外的安全措施保护，防止在未经完整性检查的情况下使用。这个检查可以由本地系统管理员设置，允许 OpenSSL 3 的每个用户加载这个模块。如果配置不正确，FIPS 模块有望以以下方式失败：

```
# echo test | openssl aes-128-cbc -a -provider fips -pbkdf2
```

输出应类似于以下内容：

```
aes-128-cbc: unable to load provider fips
Hint: use -provider-path option or OPENSSL_MODULES environment variable.
00206124D94D0000:error:1C8000D5:Provider routines:SELF_TEST_post:missing config data:crypto/openssl/providers/fips/self_test.c:275:
00206124D94D0000:error:1C8000E0:Provider routines:ossl_set_error_state:fips module entering error state:crypto/openssl/providers/fips/self_test.c:373:
00206124D94D0000:error:1C8000D8:Provider routines:OSSL_provider_init_int:self test post failure:crypto/openssl/providers/fips/fipsprov.c:707:
00206124D94D0000:error:078C0105:common libcrypto routines:provider_init:init fail:crypto/openssl/crypto/provider_core.c:932:name=fips
```

该检查可以通过在 /etc/ssl/fipsmodule.cnf 中创建一个文件来配置，然后在 OpenSSL 的主配置文件 /etc/ssl/openssl.cnf 中引用它。OpenSSL 提供了 openssl-fipsinstall(1) 实用程序来帮助这一过程，使用方法如下：

```
# openssl fipsinstall -module /usr/lib/ossl-modules/fips.so -out /etc/ssl/fipsmodule.cnf
```

输出应类似于以下内容：

```
INSTALL PASSED
```

然后应修改 /etc/ssl/openssl.cnf 文件，以便：

* 包括上述生成的 /etc/ssl/fipsmodule.cnf 文件。
* 暴露 FIPS 模块以供可能使用，
* 并显式激活默认模块。

```
[...]
# For FIPS
# Optionally include a file that is generated by the OpenSSL fipsinstall
# application. This file contains configuration data required by the OpenSSL
# fips provider. It contains a named section e.g. [fips_sect] which is
# referenced from the [provider_sect] below.
# Refer to the OpenSSL security policy for more information.
.include /etc/ssl/fipsmodule.cnf

[...]

# List of providers to load
[provider_sect]
default = default_sect
# The fips section name should match the section name inside the
# included fipsmodule.cnf.
fips = fips_sect

# If no providers are activated explicitly, the default one is activated implicitly.
# See man 7 OSSL_PROVIDER-default for more details.
#
# If you add a section explicitly activating any other provider(s), you most
# probably need to explicitly activate the default provider, otherwise it
# becomes unavailable in openssl.  As a consequence applications depending on
# OpenSSL may not work correctly which could lead to significant system
# problems including inability to remotely access the system.
[default_sect]
activate = 1
```

做完这些步骤后，应该可以确认 FIPS 模块是否有效可用并且正常工作：

```
# echo test | openssl aes-128-cbc -a -provider fips -pbkdf2
```

输出应该类似于以下内容：

```
enter AES-128-CBC encryption password:
Verifying - enter AES-128-CBC encryption password:
U2FsdGVkX18idooW6e3LqWeeiKP76kufcOUClh57j8U=
```

每当修改 FIPS 模块时，例如在执行系统更新后或在应用影响基本系统中 OpenSSL 的安全修复程序后，都必须重复执行此过程。
