# 17.2.jail 的类型

一些管理员将jail分成不同类型，尽管底层技术是相同的。每个管理员将不得不评估在每种情况下创建什么类型的jail，这取决于他们要解决的问题。

下面可以找到不同类型、其特点和使用注意事项的列表。

### 17.2.1. 厚jail

厚jail是 FreeBSDJail的传统形式。在厚jail中，基本系统的完整副本被复制到jail的环境中。这意味着jail有自己独立的 FreeBSD 基本系统实例，包括库、可执行文件和配置文件。可以将jail看作几乎完全独立的 FreeBSD 安装，但在主机系统的限制内运行。这种隔离确保jail中的进程与主机和其他jail中的进程保持分隔。

厚jail的优势:

* 隔离程度高: jail内的进程与主机系统和其他jail隔离开来。
* 独立性: 厚jail可以具有不同版本的库、配置和软件，与主机系统或其他jail不同。
* 安全性：由于jail包含自己的基本系统，影响jail环境的漏洞或问题不会直接影响主机或其他jail。

Thick jail的缺点：

* 资源开销：因为每个jail都维护自己独立的基本系统，厚jail消耗比瘦jail更多资源。
* 维护: 每个 jail 都需要针对其基本系统组件进行维护和更新。

### 17.2.2. 薄 jail

薄 jail 使用来自模板的 OpenZFS 快照或 NullFS 挂载共享基本系统。每个薄 jail 仅复制基本系统的最小子集，与厚 jail 相比，资源消耗较少。但这也意味着薄 jail 与厚 jail 相比，隔离性和独立性较差。共享组件的更改可能同时影响多个薄 jail。

简而言之，FreeBSD Thin Jail 是 FreeBSD 中的一种类型，它在隔离环境中复制了大部分但不是全部的基本系统。

Thin jail 的优势：

* 资源效率：与厚实的 jail 相比，Thin jail 更节约资源。由于它们共享大部分基本系统，它们占用较少的磁盘空间和内存。这使得在相同硬件上运行更多的 jail 成为可能，而不会消耗过多资源。
* 更快的部署：创建和启动薄 jail 通常比厚 jail 更快。当你需要快速部署多个实例时，这可能特别有优势。
* 统一维护：由于薄 jail 与主机系统共享大部分基础系统，只需要在主机上对共同的基础系统组件（如库和二进制文件）进行一次更新和维护。与为每个厚 jail 维护单独的基础系统相比，这简化了维护流程。
* 共享资源：薄 jail 可以更容易地与主机系统共享常见资源，如库和二进制文件。这可能导致更高效的磁盘缓存和提高 jail 内应用程序的性能。

Thin jail的缺点：

* 降低隔离性：薄jail的主要缺点是与厚jail相比，它们提供的隔离性较差。由于它们共享模板基础系统的相当部分，影响共享组件的漏洞或问题可能会同时影响多个jail。
* 安全性关注：薄jail中的减少隔离性可能会带来安全风险，因为一个jail中的妥协可能会更有可能影响其他jail或主机系统。
* 依赖冲突：如果多个薄jail需要不同版本的相同库或软件，管理依赖关系可能变得复杂。在某些情况下，这可能需要额外的工作来确保兼容性。
* 兼容性挑战：薄jail中的应用程序可能会遇到兼容性问题，如果它们假定与模板提供的共享组件不同的某个特定基本系统环境。

### 17.2.3. 服务jail

一个服务jail直接与主机分享完整的文件系统树（jail根路径为/），因此可以访问和修改主机上的任何文件，并与主机共享相同的用户账户。默认情况下，它无法访问网络或在jail中受限制的其他资源，但可以配置为重用主机的网络并移除部分jail限制。服务jail的用例是自动限制服务/守护程序在jail中进行最小配置，并且无需了解此类服务/守护程序所需的文件。自 FreeBSD 15 以来就存在服务jail。

服务jail的优势：

* 无需管理：已准备好的服务jail仅需要在/etc/rc.conf 中的一行配置，而未准备就绪的服务需要两行配置。
* 资源效率: 服务 jail 相较于瘦 jail 更加资源高效，因为它们不需要任何额外的磁盘空间或网络资源。
* 快速部署: 创建和启动服务 jail 通常比瘦 jail 更快，如果只需要将不同的服务/守护进程禁闭，并且不需要同一服务/守护进程的并行实例。
* 共享资源: 服务 jail 与主机系统共享所有资源，如库和二进制文件。这可能导致更高效的磁盘缓存和提升 jail 内应用程序的性能。
* 进程隔离：服务 jail 隔离特定服务时，即使在同一用户账户中运行，它也无法看到不是服务 jail 的子进程。

缺点 jail 服务的：

* 隔离降低：与厚或薄 jail 相比，服务 jail 的主要缺点是它们不提供文件系统隔离。
* 安全问题：服务jail中减少的隔离可能存在安全风险，因为一个jail中的妥协可能会对主机系统上的所有内容产生更大的影响。

下面讨论的jail大部分配置对服务jail不是必需的。为了了解jail的工作原理，建议了解这些配置可能性。关于配置服务jail所需的详细信息在配置服务jail中。

### 17.2.4. VNET jail

一个 FreeBSD VNET jail是一个虚拟化环境，能让对在其中运行的进程的网络资源进行隔离和控制。它通过为jail内部的进程创建单独的网络堆栈，提供了高级别的网络分割和安全性，确保jail内的网络流量与主机系统和其他jail隔离。

本质上，FreeBSD VNET jail添加了网络配置机制。这意味着 VNET jail可以被创建为厚的或薄的Jail。

### 17.2.5. Linux jail

一个 FreeBSD Linux Jail 是 FreeBSD 操作系统中的一个功能，它可以在 FreeBSD jail 中启用 Linux 二进制文件和应用程序的使用。通过引入一个兼容层来实现此功能，该兼容层能让将某些 Linux 系统调用和库进行转换并在 FreeBSD 内核上执行。Linux Jail 的目的是在不需要单独的 Linux 虚拟机或环境的情况下，促进在 FreeBSD 系统上执行 Linux 软件。
