# 17.3.主机配置

在主机系统上创建任何jail之前，必须执行某些配置并从主机系统获取一些信息。

需要配置jail(8)实用工具，创建必要的目录以配置和安装jail，从主机的网络中获取信息，检查主机是使用 OpenZFS 还是 UFS 作为其文件系统。

|  | 运行在jail中的 FreeBSD 版本不能比主机中运行的版本更新。|
| -- | --------------------------------------------------------- |

### 17.3.1. Jail 实用工具

jail(8) 实用程序管理 jail。

要在系统启动时启动 jail，请运行以下命令：

```
# sysrc jail_enable="YES"
# sysrc jail_parallel_start="YES"
```

|  | 使用 jail_parallel_start，所有配置的 jail 将在后台启动。|
| -- | ------------------------------------------------------------ |

### 17.3.2. 网络

FreeBSD jail 的网络可以以几种不同的方式配置：

主机网络模式（IP 共享）在主机网络模式中，jail 与主机系统共享相同的网络堆栈。当在主机网络模式下创建jail时，它使用相同的网络接口和 IP 地址。这意味着jail 没有单独的 IP 地址，其网络流量与主机的 IP 相关联。

虚拟网络（VNET）虚拟网络是 FreeBSD jail的一个功能，提供比主机网络等基本网络模式更先进和灵活的网络解决方案。VNET 允许为每个jail创建隔离的网络堆栈，为它们提供独立的 IP 地址、路由表和网络接口。这提供了更高级别的网络隔离，并允许jail像在单独的虚拟机上运行一样运行。

网状系统 netgraph(4)是一个多才多艺的内核框架，用于创建自定义网络配置。它可以用于定义网络流量如何在jail和主机系统之间以及不同jail之间流动。

### 17.3.3. 设置Jail目录树

放置文件的地方没有具体的位置吗jail。

一些管理员使用/jail，其他人使用/usr/jail，还有人使用/usr/local/jails。在本章中将使用/usr/local/jails。

除了/usr/local/jails之外，将创建其他目录：

* 媒体将包含已下载用户空间的压缩文件。
* 当使用 Thin Jail时，模板将包含模板。
* 容器将包含jail。

使用 OpenZFS 时，执行以下命令为这些目录创建数据集：

```
# zfs create -o mountpoint=/usr/local/jails zroot/jails
# zfs create zroot/jails/media
# zfs create zroot/jails/templates
# zfs create zroot/jails/containers
```

|  | 在这种情况下，zroot 用于父数据集，但也可以使用其他数据集。|
| -- | ------------------------------------------------------------- |

使用 UFS 时，执行以下命令来创建这些目录：

```
# mkdir /usr/local/jails/
# mkdir /usr/local/jails/media
# mkdir /usr/local/jails/templates
# mkdir /usr/local/jails/containers
```

### 17.3.4. Jail 配置文件

有两种方式可配置 jail 。

第一种方式是在文件 /etc/jail.conf 中为每个 jail 添加一个条目。另一种选择是在目录 /etc/jail.conf.d/ 中为每个 jail 创建一个文件。

如果主机系统少jail，可以在/etc/jail.conf 文件中为每个jail添加一个条目。如果主机系统有许多jail，最好为/etc/jail.conf.d/目录中的每个jail有一个配置文件。

/etc/jail.conf.d/中的文件必须以 .conf 作为扩展名，并且必须包含在/etc/jail.conf 中：

```
.include "/etc/jail.conf.d/*.conf";
```

典型的jail条目如下：

```
jailname { 
  # STARTUP/LOGGING
  exec.start = "/bin/sh /etc/rc"; 
  exec.stop = "/bin/sh /etc/rc.shutdown"; 
  exec.consolelog = "/var/log/jail_console_${name}.log"; 

  # PERMISSIONS
  allow.raw_sockets; 
  exec.clean; 
  mount.devfs; 

  # HOSTNAME/PATH
  host.hostname = "${name}"; 
  path = "/usr/local/jails/containers/${name}"; 

  # NETWORK
  ip4.addr = 192.168.1.151; 
  ip6.addr = ::ffff:c0a8:197 
  interface = em0; 
}
```

|  | jailname - jail 的名称。                                                                                                                           |
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
|  | exec.start - 当创建 jail 时在 jail 环境中运行的命令。一个典型的要运行的命令是 "/bin/sh /etc/rc"。                                                 |
|  | exec.stop - 在移除 jail 前在 jail 环境中运行的命令。一个典型的要运行的命令是 "/bin/sh /etc/rc.shutdown"。                                         |
|  | exec.consolelog - 将命令输出（标准输出和标准错误）重定向到文件。                                                                                   |
|  | allow.raw_sockets - 允许在jail内部创建原始套接字。设置此参数允许诸如 ping(8)和 traceroute(8)之类的实用程序在jail内部运行。                         |
|  | exec.clean - 在干净的环境中运行命令。                                                                                                              |
|  | mount.devfs - 在 chrooted /dev 目录上挂载 devfs(5) 文件系统，并将 devfs_ruleset 参数中的规则集应用于限制 jail 内可见的设备。                       |
|  | host.hostname - jail 的主机名。                                                                                                                    |
|  | path - jail 的根目录。在 jail 中运行的任何命令，无论是由 jail 运行还是从 jexec(8) 运行，都将从此目录运行。                                         |
|  | ip4.addr - IPv4 地址。IPv4 有两种配置可能性。第一种是建立一个 IP 或 IP 列表，就像在示例中所做的那样。另一种是改用 ip4，并将 inherit 值设置为继承主机的 IP 地址。|
|  | ip6.addr - IPv6 地址。IPv6 有两种配置可能性。第一种是建立一个 IP 或 IP 列表，就像在示例中所做的那样。另一种是改用 ip6，并将 inherit 值设置为继承主机的 IP 地址。|
|  | interface - 用于添加jail的 IP 地址的网络接口。通常使用主机接口。                                                                                   |

有关配置变量的更多信息可以在jail（8）和jail.conf（5）中找到。
