# 17.4.传统 jail（厚 jail）

这些jail类似于一个真实的 FreeBSD 系统。它们可以被更多或更少地像普通主机系统一样管理并独立更新。

### 创建经典 Jail 17.4.1。

原则上，jail 只需要主机名、根目录、IP 地址和用户区。

jail 的用户区可以从官方 FreeBSD 下载服务器获得。

执行以下命令下载用户端:

```
# fetch https://download.freebsd.org/ftp/releases/amd64/amd64/13.2-RELEASE/base.txz -o /usr/local/jails/media/13.2-RELEASE-base.txz
```

下载完成后，需要将内容提取到jail目录中。

执行以下命令将用户端提取到jail目录中。

```
# mkdir -p /usr/local/jails/containers/classic
# tar -xf /usr/local/jails/media/13.2-RELEASE-base.txz -C /usr/local/jails/containers/classic --unlink
```

提取用户区域到 jail 目录后，需要复制时区和 DNS 服务器文件：

```
# cp /etc/resolv.conf /usr/local/jails/containers/classic/etc/resolv.conf
# cp /etc/localtime /usr/local/jails/containers/classic/etc/localtime
```

复制文件后，下一步是通过执行以下命令更新到最新的补丁级别：

```
# freebsd-update -b /usr/local/jails/containers/classic/ fetch install
```

最后一步是配置 jail。必须在配置文件 /etc/jail.conf 或 jail.conf.d 中添加一个条目，带有 jail 的参数。

一个例子是以下内容：

```
classic {
  # STARTUP/LOGGING
  exec.start = "/bin/sh /etc/rc";
  exec.stop = "/bin/sh /etc/rc.shutdown";
  exec.consolelog = "/var/log/jail_console_${name}.log";

  # PERMISSIONS
  allow.raw_sockets;
  exec.clean;
  mount.devfs;

  # HOSTNAME/PATH
  host.hostname = "${name}";
  path = "/usr/local/jails/containers/${name}";

  # NETWORK
  ip4.addr = 192.168.1.151;
  interface = em0;
}
```

执行以下命令以启动jail：

```
# service jail start classic
```

有关如何管理jail的更多信息可在Jail管理部分找到。
