# 17.6.管理 jail

创建 jail 之后，就可以执行许多操作，如启动、重启或删除jail，在其中安装软件等。本节将说明主机可以执行的与jail相关的不同操作。

### 17.6.1. 列出运行中的 Jails

要列出在主机系统上运行的 jail，可以使用命令 jls（8）：

```
# jls
```

输出应类似于以下内容：

```
   JID  IP Address      Hostname                      Path
     1  192.168.250.70  classic                       /usr/local/jails/containers/classic
```

jls（8）支持 --libxo 参数，通过 libxo（3）库能让显示其他类型的格式，比如 JSON，HTML，等等。

例如，执行以下命令以获取 JSON 输出：

```
# jls --libxo=json
```

输出应该类似于以下内容：

```
{"__version": "2", "jail-information": {"jail": [{"jid":1,"ipv4":"192.168.250.70","hostname":"classic","path":"/usr/local/jails/containers/classic"}]}}
```

### 17.6.2. 启动、重启和停止 Jail

service(8) 用于启动、重启或停止主机上的 jail。

例如，要启动 jail，运行以下命令：

```
# service jail start jailname
```

更改 start 参数为 restart 或 stop 以在jail上执行其他操作。

### 17.6.3. 销毁Jail

销毁jail不像停止使用 service(8)和移除jail目录和 /etc/jail.conf 条目那样简单。

FreeBSD 非常认真地对待系统安全性。因此，有一些文件甚至 root 用户也无法删除。这个功能称为文件标志。

第一步是停止所需的jail执行以下命令：

```
# service jail stop jailname
```

第二步是通过执行以下命令使用 chflags(1)来删除这些标志，其中 classic 是要删除的jail的名称：

```
# chflags -R 0 /usr/local/jails/containers/classic
```

第三步是删除jail所在的目录：

```
# rm -rf /usr/local/jails/containers/classic
```

最后，需要在/etc/jail.conf 或jail.conf.d 中删除jail条目。

### 17.6.4. Jail中处理软件包

pkg(8) 工具支持 -j 参数，用于处理安装在 jail 中的软件包。

例如，要在 jail 中安装 nginx-lite，可以从主机执行下一个命令：

```
# pkg -j classic install nginx-lite
```

有关在 FreeBSD 中处理软件包的更多信息，请参阅安装应用程序：软件包和 Ports。

### 访问 Jail

正如前面所述，最好从主机系统管理 jail，可以使用 jexec(8) 输入 jail。

可以通过从主机运行 jexec(8) 来输入 jail。

```
# jexec -u root jailname
```

当访问jail时，将显示在 motd(5)中配置的消息。

### 17.6.6. 在Jail中执行命令

要在jail中从主机系统执行命令，可以使用 jexec(8)。

例如，要停止在jail内部运行的服务，需要执行以下命令：

```
# jexec -l jailname service nginx stop
```
