# 17.7.更新 jail

升级 FreeBSD Jails 确保孤立的环境保持安全、最新，并与 FreeBSD 生态系统中可用的最新功能和改进保持一致。

### 17.7.1. 使用 OpenZFS 快照升级经典 Jail 或薄 Jail

必须从主机操作系统更新 Jails。在 FreeBSD 中，默认行为是禁止在 jail 中使用 chflags(1)。这将阻止更新某些文件，因此无法从 jail 中更新。

要将 jail 更新到运行的 FreeBSD 版本的最新补丁发布版，请在主机上执行以下命令：

```
# freebsd-update -j classic fetch install
# service jail restart classic
```

要将jail升级到新的主要或次要版本，首先按照执行主要和次要版本升级中说明的步骤升级主机系统。主机升级并重启之后，就可以升级jail了。

|  | 如果从一个版本升级到另一个版本，创建一个新的jail比完全升级更容易。|
| -- | -------------------------------------------------------------------- |

例如，要从 13.1-RELEASE 升级到 13.2-RELEASE，在主机上执行以下命令：

```
# freebsd-update -j classic -r 13.2-RELEASE upgrade
# freebsd-update -j classic install
# service jail restart classic
# freebsd-update -j classic install
# service jail restart classic
```

|  | 需要执行 install 步骤两次。第一次升级内核，第二次升级其余组件。|
| -- | ----------------------------------------------------------------- |

然后，如果是一个主版本升级，重新安装所有已安装的软件包并重启jail。这是必需的，因为在 FreeBSD 的主要版本之间升级时 ABI 版本会发生变化。

 从主机：

```
# pkg -j jailname upgrade -f
# service jail restart jailname
```

### 17.7.2。使用 NullFS 升级薄 Jail

由于使用 NullFS 的薄 Jails 共享大多数系统目录，因此它们非常易于更新。只需更新模板。这能让同时更新多个 jail。

要将模板更新到运行的 FreeBSD 版本的最新补丁版本，请在主机上执行以下命令：

```
# freebsd-update -b /usr/local/jails/templates/13.1-RELEASE-base/ fetch install
# service jail restart
```

要升级模板到一个新的主要或次要版本，首先按照执行主要和次要版本升级中说明的步骤升级主机系统。主机升级并重启之后，然后可以升级模板。

例如，要从 13.1-RELEASE 升级到 13.2-RELEASE，在主机上执行以下命令：

```
# freebsd-update -b /usr/local/jails/templates/13.1-RELEASE-base/ -r 13.2-RELEASE upgrade
# freebsd-update -b /usr/local/jails/templates/13.1-RELEASE-base/ install
# service jail restart
# freebsd-update -b /usr/local/jails/templates/13.1-RELEASE-base/ install
# service jail restart
```
