# 18.1.概述

FreeBSD 支持基于 POSIX®.1e 草案的安全扩展。这些安全机制包括文件系统访问控制列表（“访问控制列表”）和强制访问控制（MAC）。MAC 能让加载访问控制模块以实施安全策略。一些模块为系统的一小部分提供保护，加强特定服务。其他提供全面的标记安全，涉及所有主体和对象。定义的强制部分表明控制的执行由管理员和操作系统执行。这与默认安全机制自主访问控制（DAC）形成对比，其中控制执行留给用户的自行决定。

这一章节关注 MAC 框架以及 FreeBSD 提供的一组可插入的安全策略模块，用于启用各种安全机制。

阅读完这一章节后，你将了解：

* 与 MAC 框架相关的术语。
* MAC 安全策略模块的功能以及标记和非标记策略之间的区别。
* 在配置系统以使用 MAC 框架之前需要考虑的因素。
* FreeBSD 中包含的 MAC 安全策略模块及其配置方法。
* 如何使用 MAC 框架实现更安全的环境。
* 如何测试 MAC 配置以确保框架已正确实施。

在阅读本章之前，你应该：

* 了解 UNIX®和 FreeBSD 基础知识（FreeBSD 基础知识）。
* 对与安全性以及它与 FreeBSD 的关系有一定的了解（安全性）。

|  | 不正确的 MAC 配置可能导致系统访问丧失，用户受到激怒，或者无法访问 Xorg 提供的功能。更重要的是，MAC 不应被依赖来完全保护系统。MAC 框架仅仅是对现有安全策略的一种补充。如果没有良好的安全实践和定期的安全检查，系统将永远不会完全安全。<br /><br />本章包含的示例仅供演示目的，示例设置不应在生产系统上实施。实施任何安全策略都需要很好的理解，适当的设计和彻底的测试。|
| -- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

虽然本章涉及与 MAC 框架相关的广泛安全问题，但不涉及新的 MAC 安全策略模块的开发。MAC 框架中包含的一些安全策略模块具有特定特征，可供测试和新模块开发使用。有关这些安全策略模块及它们提供的各种机制的更多信息，请参阅 mac_test(4)、mac_stub(4)和 mac_none(4)。
