# 18.2.关键术语

下面是在提到 MAC 框架时使用的关键术语：

* “隔间”: 一组程序和数据，可以被分割或隔离，用户可以明确访问系统的特定组件。一个隔间代表一个组，比如工作组、部门、项目或主题。隔间使实施需要知道权限的安全策略变得可能。
* “完整性”: 数据可信赖的程度。随着数据完整性的提高，人们对数据的信任也随之增强。
* “级别”: 安全属性的增加或减小设置。随着级别的提高，其安全性也被认为提高。
* 标签: 一种安全属性，可应用于系统中的文件、目录或其他项目。它可以被视为一种机密性标记。当在文件上放置标签时，它说明了该文件的安全属性，并且只允许具有类似安全设置的文件、用户和资源访问。标签值的含义和解释取决于策略配置。一些策略将标签视为对象的完整性或保密性，而其他策略可能使用标签保存访问规则。
* 多标签: 此属性是文件系统选项，可以在单用户模式下使用 tunefs(8)、在引导过程中使用 fstab(5)或在创建新文件系统时设置。此选项允许管理员在不同对象上应用不同的 MAC 标签。此选项仅适用于支持标记的安全策略模块。
* 单标签: 一种策略，整个文件系统使用一个标签来强制对数据流的访问控制。每当 multilabel 未设置时，所有文件将符合相同的标签设置。
* 对象：在主体的指导下，信息流动的实体。这包括目录，文件，字段，屏幕，键盘，内存，磁存储，打印机或任何其他数据存储或传输设备。对象是数据容器或系统资源。访问对象实质上意味着访问其数据。
* 主体：引起对象之间信息流动的任何活跃实体，如用户，用户进程或系统进程。在 FreeBSD 上，这几乎总是代表用户在进程中操作的线程。
* 策略：定义实现目标方式的一组规则。政策通常记录了如何处理某些项目。本章认为政策是控制数据和信息流动的一组规则，定义谁可以访问该数据和信息。
* 高水位标记：这种策略允许提高安全级别以访问更高级别的信息。在大多数情况下，完成进程后会恢复原始级别。目前，FreeBSD MAC 框架不包括这种类型的策略。
* 低水位标记：这种策略允许降低安全级别以访问不太安全的信息。在大多数情况下，用户的原始安全级别在进程完成后会恢复。FreeBSD 中唯一使用这种策略的安全策略模块是 mac_lomac(4)。
* 敏感度：通常在讨论多级安全性 (MLS) 时使用。敏感度级别说明数据应当有多重要或机密。随着敏感度级别的提高，数据的机密性或保密性的重要性也会增加。
