# 18.3.了解 MAC 标签

MAC 标签是一个安全属性，可以应用于系统中的主体和对象。设置标签时，管理员必须了解其影响，以防止系统出现意外或不希望的行为。对象上可用的属性取决于加载的策略模块，因为策略模块以不同方式解释其属性。

对象上的安全标签作为策略的一部分用于安全访问控制决策。在某些策略中，标签包含做出决策所需的所有信息。在其他策略中，标签可能作为更大规则集的一部分进行处理。

有两种标签策略：单标签和多标签。默认情况下，系统将使用单标签。管理员应该了解每种策略的利弊，以便实施符合系统安全模型要求的策略。

单标签安全策略仅允许为每个主体或对象使用一个标签。由于单标签策略会在整个系统范围内强制执行一组访问权限，因此它提供了较低的管理开销，但降低了支持标记的策略的灵活性。不过，在许多环境中，单标签策略可能就是所需的全部。

一个单标签策略在某种程度上类似于 DAC，因为 root 配置策略，使用户被放置在适当的类别和访问级别中。一个显著的区别是许多策略模块也可以限制 root。对对象的基本控制然后将释放给组，但是 root 可以随时撤销或修改设置。

在适当的情况下，在 UFS 文件系统上可以通过将 multilabel 传递给 tunefs(8) 来设置多标签策略。多标签策略允许每个主体或对象具有自己独立的 MAC 标签。决定使用多标签策略还是单标签策略只在实现标记功能的策略中需要，如 biba，lomac 和 mls。一些策略，如 seeotheruids，portacl 和 partition，根本不使用标签。

在分区上使用多标签策略，并建立多标签安全模型，可以增加管理开销，因为该文件系统中的所有内容都有一个标签，包括目录、文件，甚至设备节点。

以下命令将在指定的 UFS 文件系统上设置 multilabel。这只能在单用户模式下执行，不是交换文件系统的要求。

```
# tunefs -l enable /
```

|  | 一些用户在根分区上设置 multilabel 标志时遇到问题。如果是这种情况，请查看 MAC 框架故障排除。|
| -- | --------------------------------------------------------------------------------------------- |

由于多标签策略是基于每个文件系统设置的，如果文件系统布局设计良好，则可能不需要多标签策略。考虑一个 FreeBSD web 服务器的安全 MAC 模型示例。该计算机在默认文件系统中为所有内容使用单标签 biba/high。如果 Web 服务器需要以 biba/low 运行以防止写入能力，则可以将其安装到单独的 UFS /usr/local 文件系统中，设置为 biba/low。

### 18.3.1. 标签配置

几乎所有标签策略模块配置都将使用基本系统实用程序来执行。这些命令提供了一个简单的界面，用于对象或主体的配置，或进行配置的操作和验证。

所有配置均可使用 setfmac 完成, 该命令用于在系统对象上设置 MAC 标签, setpmac 用于在系统主体上设置标签。例如，要在测试上将 biba MAC 标签设置为 high ：

```
# setfmac biba/high test
```

如果配置成功，提示将会无错误地返回。一个常见的错误是 Permission denied，通常发生在将标签设置或修改为受限对象时。其他条件可能导致不同的失败。例如，文件可能不属于尝试重新标记对象的用户，对象可能不存在，或者对象可能是只读的。强制策略不允许进程重新标记文件，可能是因为文件的属性，进程的属性，或者提议的新标签值的属性。例如，如果以低完整性运行的用户试图更改高完整性文件的标签，或者以低完整性运行的用户尝试将低完整性文件的标签更改为高完整性标签，这些操作将失败。

系统管理员可以使用 setpmac 来通过为调用的进程分配不同的标签来覆盖策略模块的设置：

```
# setfmac biba/high test
Permission denied
# setpmac biba/low setfmac biba/high test
# getfmac test
test: biba/high
```

对于当前正在运行的进程，如 sendmail，通常使用 getpmac。此命令将进程 ID（PID）用于命令名称的位置。如果用户尝试操作不在其访问范围内的文件，受加载的策略模块规则约束，则会显示 Operation not permitted 错误。

### 18.3.2. 预定义标签

支持标签功能的一些 FreeBSD 策略模块提供三个预定义标签: low , equal , 和 high，其中:

* low 被视为对象或主体可以拥有的最低标签设置。在对象或主体上设置此标签会阻止它们访问标记为高的对象或主体。
* equal 设置为被禁用或不受影响的主题或对象，应仅放置在被视为豁免策略的对象上。
* high 授予 Biba 和 MLS 策略模块中可用的最高设置的对象或主题。

此类策略模块包括 mac_biba(4)，mac_mls(4)和 mac_lomac(4)。每个预定义标签都建立了不同的信息流指令。请参考模块的手册页面以确定通用标签配置的特征。

### 数字标签

Biba 和 MLS 策略模块支持一个数字标签，可以设置以指示精确的分层控制级别。这个数字级别用于将信息分成不同的分类组或对信息进行排序，只允许访问该组或更高级别的组。例如：

```
biba/10:2+3+6(5:2+3-20:2+3+4+5+6)
```

可以解释为“Biba 策略标签/等级 10：区段 2、3 和 6：（等级 5 ...）"

在这个例子中，第一个等级被认为是有效等级，具有有效的隔间，第二个等级是低等级，最后一个是高等级。在大多数配置中，这些细粒度的设置是不需要的，因为它们被认为是高级配置。

系统对象只有当前等级和隔间。系统主体反映系统中可用权限的范围，以及网络接口，在那里它们用于访问控制。

主体和对象对中的等级和隔间用于构建一个称为支配的关系，其中一个主体支配一个对象，对象支配主体，两者都不支配对方，或者两者互相支配。当两个标签相等时，会发生“两者互相支配”的情况。由于 Biba 的信息流特性，用户对一组可能对应于项目的隔间具有权限，但对象也有一组隔间。用户可能需要使用 su 或 setpmac 对其权限进行子集处理，以便从受限制的隔间访问对象。

### 用户标签

用户需要具有标签，以便他们的文件和进程与系统上定义的安全策略正确互动。这是在 /etc/login.conf 中使用登录类进行配置的。每个使用标签的策略模块都将实现用户类设置。

要设置将由 MAC 执行的用户类默认标签，请添加一个 label 条目。下面显示了一个包含每个策略模块的示例 label 条目。请注意，在真实配置中，管理员永远不会启用每个策略模块。强烈建议在实施任何配置之前先查看本章的其余部分。

```
default:\
	:copyright=/etc/COPYRIGHT:\
	:welcome=/etc/motd:\
	:setenv=MAIL=/var/mail/$,BLOCKSIZE=K:\
	:path=~/bin:/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/sbin:/usr/local/bin:\
	:manpath=/usr/share/man /usr/local/man:\
	:nologin=/usr/sbin/nologin:\
	:cputime=1h30m:\
	:datasize=8M:\
	:vmemoryuse=100M:\
	:stacksize=2M:\
	:memorylocked=4M:\
	:memoryuse=8M:\
	:filesize=8M:\
	:coredumpsize=8M:\
	:openfiles=24:\
	:maxproc=32:\
	:priority=0:\
	:requirehome:\
	:passwordtime=91d:\
	:umask=022:\
	:ignoretime@:\
	:label=partition/13,mls/5,biba/10(5-15),lomac/10[2]:
```

当用户无法修改默认值时，他们可以在登录后更改其标签，但受政策约束。上面的示例告诉 Biba 策略，一个进程的最小完整性是 5，其最大完整性是 15，默认有效标签是 10。该进程将在 10 运行，直到选择更改标签，可能是由于用户使用 setpmac，这将受到 Biba 配置范围的限制。

对于任何对 login.conf 进行的更改，必须使用 cap_mkdb 重新构建登录类能力数据库。

许多站点拥有大量需要几种不同用户类别的用户。需要深入规划，因为这可能会变得难以管理。

### 18.3.5. 网络接口标签

标签可设置在网络接口上，以帮助控制数据在网络中的流动。使用网络接口标签的策略与对象相关的策略的功能相同。例如，在 Biba 的高设置下，用户将不被允许访问具有标签 low 的网络接口。

在设置网络接口的 MAC 标签时，可能会传递 maclabel 到 ifconfig ：

```
# ifconfig bge0 maclabel biba/equal
```

该示例将在 bge0 接口上设置 biba/equal 的 MAC 标签。当使用类似 biba/high(low-high) 的设置时，应引用整个标签以防止返回错误。

每个支持标签的策略模块都有一个可调节的选项，可用于禁用网络接口上的 MAC 标签。将标签设置为 equal 将产生类似的效果。查看 sysctl 的输出，策略手册页面以及本章节其他信息，获取关于这些可调节选项的更多信息。
