# 18.4.规划安全配置

在实施任何 MAC 政策之前，建议进行规划阶段。在规划阶段，管理员应考虑实施要求和目标，例如：

* 如何对目标系统上可用的信息和资源进行分类。
* 需要限制访问的哪些信息或资源以及应该施加的限制类型。
* 为实现此目标需要哪些 MAC 模块。

在使用 MAC 实现在生产系统上之前，应该对受信任的系统及其配置进行试运行。由于不同的环境有不同的需求和要求，建立完整的安全配置文件将减少系统投入运行后的更改需求。

考虑 MAC 框架如何增强整个系统的安全性。MAC 框架提供的各种安全策略模块可用于保护网络和文件系统，或阻止用户访问某些ports和套接字。也许策略模块的最佳用途是同时加载多个安全策略模块，以提供 MLS 环境。这种方法不同于硬化策略，后者通常只用于加固系统仅用于特定目的的元素。MLS 的缺点是增加了管理开销。

与提供选择所需特定配置策略的框架的持久效果相比，开销是很小的，并且可以降低性能开销。减少不需要的策略支持可以提高系统的整体性能，同时提供选择的灵活性。良好的实现将考虑整体安全要求，并有效实现框架提供的各种安全策略模块。

使用 MAC 的系统保证用户不会被允许随意更改安全属性。所有用户实用程序、程序和脚本必须在所选安全策略模块提供的访问规则约束内运行，MAC 访问规则的控制在系统管理员手中。

仔细选择正确的安全策略模块是系统管理员的职责。对于需要限制网络访问控制的环境，mac_portacl(4)、mac_ifoff(4)和 mac_biba(4)策略模块是不错的起点。对于需要严格保密文件系统对象的环境，可以考虑 mac_bsdextended(4)和 mac_mls(4)策略模块。

可以基于网络配置做出政策决策。如果只有特定用户应被允许访问 ssh(1)，mac_portacl(4)策略模块是一个不错的选择。在文件系统的情况下，对对象的访问可能被视为对某些用户保密，但不对其他用户保密。举例来说，一个大型开发团队可能被分成较小的项目，项目 A 中的开发人员可能不被允许访问项目 B 中的开发人员编写的对象。然而，两个项目可能都需要访问项目 C 中开发人员创建的对象。使用 MAC 框架提供的不同安全策略模块，用户可以被划分到这些组，并然后被赋予访问适当对象的权限。

每个安全策略模块在处理系统整体安全性方面都有独特的方式。模块选择应基于深思熟虑的安全策略，可能需要进行修订和重新实施。了解 MAC 框架提供的不同安全策略模块将帮助管理员为其情况选择最佳策略。

本章的其余部分涉及可用模块，说明了它们的使用和配置，并在某些情况下提供了适用情况的见解。

|  | 实施 MAC 很像实施防火墙，因为必须小心防止完全被系统锁定。应考虑能够恢复到以前的配置，并且在远程连接上执行 MAC 时应极度谨慎。|
| -- | ------------------------------------------------------------------------------------------------------------------------------ |
