# 18.5.可用的 MAC 策略

默认的 FreeBSD 内核包括 options MAC。这意味着与 MAC 框架一起包含的每个模块都可以作为运行时内核模块加载 kldload。测试模块后，请将模块名称添加到/boot/loader.conf，以便在引导期间加载。每个模块还为那些选择编译自己的自定义内核的管理员提供了一个内核选项。

FreeBSD 包括一组涉及大多数安全要求的策略。每个策略如下总结。最后三个策略支持整数设置，代替三个默认标签。

### 18.5.1. MAC 查看其他 UID 策略

模块名称：mac_seeotheruids.ko

内核配置行: options MAC_SEEOTHERUIDS

 引导选项: mac_seeotheruids_load="YES"

mac_seeotheruids(4) 模块扩展了 security.bsd.see_other_uids 和 security.bsd.see_other_gids sysctl 可调节参数。此选项在配置之前不需要设置任何标签，并且可以与其他模块透明地配合工作。

载入模块后，以下 sysctl 可用于控制其功能：

* security.mac.seeotheruids.enabled 启用该模块，并实施默认设置，拒绝用户查看其他用户拥有的进程和套接字。
* security.mac.seeotheruids.specificgid_enabled 允许指定的组豁免此策略。若要豁免特定组，请使用 security.mac.seeotheruids.specificgid=<em>XXX</em><span> </span>sysctl 可调节器，将 XXX 替换为要豁免的数字组 ID。
* security.mac.seeotheruids.primarygroup_enabled 用于豁免特定的主要组免受此策略的影响。在使用此可调节项时，security.mac.seeotheruids.specificgid_enabled 可能不能设置。

### 18.5.2. MAC BSD 扩展策略

模块名称：mac_bsdextended.ko

内核配置行: options MAC_BSDEXTENDED

 引导选项: mac_bsdextended_load="YES"

mac_bsdextended(4) 模块强制执行文件系统防火墙。它为标准文件系统权限模型提供扩展，允许管理员创建类似防火墙规则集以保护文件，实用程序和文件系统层次结构中的目录。当尝试访问文件系统对象时，将迭代规则列表，直到找到匹配的规则或到达末尾为止。可以使用 security.mac.bsdextended.firstmatch_enabled 更改此行为。与 FreeBSD 中的其他防火墙模块类似，可以创建包含访问控制规则的文件，并使用 rc.conf(5) 变量在引导时由系统创建和读取。

规则列表可以使用类似于 ipfw(8)的语法输入 ugidfw(8)。可以通过在 libugidfw(3)库中使用函数来编写更多工具。

加载 mac_bsdextended(4)模块后，可以使用以下命令列出当前的规则配置：

```
# ugidfw list
0 slots, 0 rules
```

默认情况下，没有定义规则，一切都是完全可访问的。要创建一个规则，阻止用户的所有访问但不影响 root ：

```
# ugidfw add subject not uid root new object not uid root mode n
```

虽然此规则简单易实现，但却是一个非常糟糕的主意，因为它会阻止所有用户发出任何命令。一个更现实的示例是阻止 user1 所有访问，包括目录列表，到 <em>user2</em> 的主目录：

```
# ugidfw set 2 subject uid user1 object uid user2 mode n
# ugidfw set 3 subject uid user1 object gid user2 mode n
```

可以使用 not uid<span> </span><em>user2</em> 代替 user1，以便为所有用户强制相同的访问限制。然而，root 用户不受这些规则影响。

|  | 在使用此模块时应格外小心，因为不正确的使用可能会阻止访问文件系统的某些部分。|
| -- | ------------------------------------------------------------------------------ |

### 18.5.3. MAC 接口静音策略

模块名称：mac_ifoff.ko

内核配置行: options MAC_IFOFF

 引导选项： mac_ifoff_load="YES"

mac_ifoff(4) 模块用于在运行时禁用网络接口，并防止在系统启动期间启动网络接口。它不使用标签，也不依赖于任何其他 MAC 模块。

通过这些 sysctl 可调节项执行大部分该模块的控制操作：

* security.mac.ifoff.lo_enabled 启用或禁用回环 lo(4) 接口上的所有流量。
* security.mac.ifoff.bpfrecv_enabled 启用或禁用 Berkeley Packet Filter 接口 bpf(4) 上的所有流量。
* security.mac.ifoff.other_enabled 启用或禁用所有其他接口上的流量。

用途之一是在不允许在引导序列期间传输网络流量的环境中进行网络监控。另一个用途是编写一个脚本，该脚本使用诸如 security/aide 之类的应用程序，在受保护的目录中发现新文件或更改的文件时自动阻止网络流量。

### 18.5.4. MAC Port 访问控制列表策略

模块名称：mac_portacl.ko

内核配置行： MAC_PORTACL

 启动选项： mac_portacl_load="YES"

mac_portacl(4) 模块用于限制绑定到本地 TCP 和 UDP ports，从而可以允许非 root 用户绑定到指定的特权 ports（1024 之下）。

加载之后，该模块将在所有套接字上启用 MAC 策略。以下可用的可调参数有：

* security.mac.portacl.enabled 启用或禁用策略。
* security.mac.portacl.port_high 设置 mac_portacl(4)保护的最高port编号。
* security.mac.portacl.suser_exempt，当设置为非零值时，豁免该策略下的 root 用户。
* security.mac.portacl.rules 指定策略为形式为 rule[,rule,…] 的文本字符串，需要多少个规则就有多少个规则，其中每个规则的形式为 idtypeprotocol:port。idtype 要么是 uid 要么是 gid。protocol 参数可以是 tcp 或 udp。port 参数是允许指定用户或组绑定到的port数字。用户 ID、组 ID 和port参数只能使用数值。

默认情况下，低于 1024 的ports只能被作为 root 运行的特权进程使用。为了使 mac_portacl(4) 允许非特权进程绑定到低于 1024 的ports，请将以下可调整参数设置如下：

```
# sysctl security.mac.portacl.port_high=1023
# sysctl net.inet.ip.portrange.reservedlow=0
# sysctl net.inet.ip.portrange.reservedhigh=0
```

為了防止 root 用戶受到此策略的影響，將 security.mac.portacl.suser_exempt 設置為非零值。

```
# sysctl security.mac.portacl.suser_exempt=1
```

為了允許 UID 80 的 www 用戶綁定到port 80，而無需 root 權限：

```
# sysctl security.mac.portacl.rules=uid:80:tcp:80
```

下一個示例允許具有 UID 為 1001 的用戶綁定到 TCP ports 110（POP3）和 995（POP3s）：

```
# sysctl security.mac.portacl.rules=uid:1001:tcp:110,uid:1001:tcp:995
```

### 18.5.5. MAC 分区策略

模块名称：mac_partition.ko

内核配置行： options MAC_PARTITION

 引导选项: mac_partition_load="YES"

mac_partition(4) 策略根据它们的 MAC 标签将进程放入特定的 "分区"。此策略的大部分配置是使用 setpmac(8) 完成的。这个策略有一个 sysctl 可调整项可用：

* security.mac.partition.enabled 启用 MAC 进程分区的执行。

当启用此策略时，用户只能查看自己的进程以及其分区内的其他进程，但不允许与此分区范围之外的实用程序一起使用。例如，insecure 类中的用户将不被允许访问 top 以及许多其他必须生成进程的命令。

此示例将 top 添加到 insecure 类用户的标签集中。由 insecure 类用户生成的所有进程将保留在 partition/13 标签中。

```
# setpmac partition/13 top
```

此命令显示分区标签和进程列表:

```
# ps Zax
```

这个命令显示另一个用户的进程分区标签和该用户当前运行的进程。

```
# ps -ZU trhodes
```

|  | 用户可以看到 root 的标签中的进程，除非加载了 macseeotheruids(4)策略。|
| -- | ----------------------------------------------------------------------- |

### 18.5.6. MAC 多级安全模块

 模块名称：mac_mls.ko

内核配置行： options MAC_MLS

 引导选项： mac_mls_load="YES"

策略 mac_mls(4)通过执行严格的信息流策略来控制系统中主体和客体之间的访问。

在 MLS 环境中，每个主体或客体的标记中都设置了一个“许可”级别，以及隔间。由于这些许可级别可能达到数千，因此彻底配置每个主体或客体将是一项艰巨的任务。为了减轻这种管理开销，此策略中包括三个标签： mls/low，mls/equal 和 mls/high，其中：

* 任何带有 mls/low 标签的内容都将具有低许可级别，并且不被允许访问更高级别的信息。该标签还会阻止具有更高许可级别的客体向更低级别的客体编写或传递信息。
* mls/equal 应该放置在应该被豁免政策的对象上。
* mls/high 是可能的最高级别的许可。分配此标签的对象将控制系统中的所有其他对象；但是，它们不会允许信息泄露到较低级别的对象。

 MLS 提供：

* 具有一组非层次化类别的分层安全级别。
* 固定规则 . 这意味着主体可以对其自身级别或以下的对象具有读访问权限，但不能对其上方的对象具有读访问权限。类似地，主体可以对其自身级别或以上的对象具有写访问权限，但不能对其下方的对象具有写访问权限。
* 保密，或防止数据被不当披露。
* 同时处理多个敏感级别数据的系统设计基础，而不会在机密和保密之间泄露信息。

下列 sysctl 可调参数可用：

* security.mac.mls.enabled 用于启用或禁用 MLS 策略。
* security.mac.mls.ptys_equal 在创建过程中将所有 pty(4)设备标记为 mls/equal。
* security.mac.mls.revocation_enabled 在对象的标签更改为较低等级的标签后撤销访问权限。
* security.mac.mls.max_compartments 设置系统上允许的最大隔室级别数。

使用 setfmac(8)来操纵 MLS 标签。要为对象分配一个标签：

```
# setfmac mls/5 test
```

要获取文件 test 的 MLS 标签：

```
# getfmac test
```

另一种方法是在/etc/中创建一个主策略文件，其中指定 MLS 策略信息，并将该文件提供给 setfmac。

当使用 MLS 策略模块时，管理员计划控制敏感信息的流动。默认 block read up block write down 将所有内容设置为低状态。一切都是可访问的，管理员会逐渐增加信息的保密性。

除了三个基本的标签选项外，管理员可能根据需要将用户和组分组以阻止它们之间的信息流动。用描述性词汇来看清除级别的信息可能更容易，比如 Confidential 、 Secret 和 Top Secret 的分类。一些管理员会根据项目级别创建不同的组。无论分类方法如何，实施限制策略之前必须有一个深思熟虑的计划。

MLS 策略模块的一些示例情况包括电子商务 Web 服务器、保存重要公司信息的文件服务器和金融机构环境。

### 18.5.7. MAC Biba 模块

模块名称：mac_biba.ko

内核配置行： options MAC_BIBA

 引导选项： mac_biba_load="YES"

mac_biba(4)模块加载了 MAC Biba 策略。该策略与 MLS 策略类似，唯一的区别在于信息流规则略有颠倒。这是为了防止敏感信息向下流动，而 MLS 策略则阻止敏感信息向上流动。

在 Biba 环境中，每个主体或对象上都设置了一个“完整性”标签。这些标签由分层等级和非分层组件组成。随着等级的提升，完整性也随之提升。

支持的标签是 biba/low，biba/equal 和 biba/high，其中：

* biba/low 被视为对象或主体可能具有的最低完整性。将此设置为对象或主体会阻止它们对标记为 biba/high 的对象或主体进行写访问，但不会阻止读取访问。
* biba/equal 应仅放置在被视为豁免策略的对象上。
* biba/high 允许写入设置为较低标签的对象，但不允许读取该对象。建议将此标签放置在影响整个系统完整性的对象上。

 Biba 提供：

* 具有一组非层次完整性类别的分层完整性级别。
* 固定规则是 no write up, no read down，与 MLS 相反。一个主体可以对其自身级别或以下的对象具有写访问权限，但不能对其以上的对象具有访问权限。类似地，一个主体可以对其自身级别或以上的对象具有读访问权限，但不能对其以下的对象具有访问权限。
* 通过防止数据不当修改来保持完整性。
* 完整性级别而不是 MLS 敏感性级别。

下列可调节项可用于操作 Biba 策略：

* security.mac.biba.enabled 用于在目标机器上启用或禁用 Biba 策略的强制执行。
* security.mac.biba.ptys_equal 用于禁用 pty(4)设备上的 Biba 策略。
* 如果 security.mac.biba.revocation_enabled 更改标签以控制主体，则会强制撤销对对象的访问权限。

要访问系统对象上的 Biba 策略设置，请使用 setfmac 和 getfmac ：

```
# setfmac biba/low test
# getfmac test
test: biba/low
```

完整性与敏感性不同，用于保证信息不会被不受信任的方面操作。这包括主体和对象之间传递的信息。它确保用户只能修改或访问他们明确获得访问权限的信息。mac_biba(4)安全策略模块允许管理员配置用户可以查看和调用哪些文件和程序，同时确保这些程序和文件对于该用户而言是受系统信任的。

在初始规划阶段，管理员必须准备将用户分成等级、级别和领域。只要启用此策略模块，系统将默认为高标签，管理员需要配置用户的不同等级和级别。一个良好的规划方法可以包括主题，而不使用许可级别。例如，只允许开发人员修改访问源代码存储库、源代码编译器和其他开发工具。其他用户将被分组到其他类别，如测试人员、设计师或最终用户，并且只被允许读取访问。

低完整性主体无法写入高完整性主体，高完整性主体不能列出或读取低完整性对象。在最低等级设置标签可能会使主体无法访问对象。此安全策略模块的一些潜在环境包括受限制的 Web 服务器，开发和测试机器以及源代码存储库。一个不太有用的实现方式可能是个人工作站，用作路由器的机器或网络防火墙。

### 18.5.8. MAC 低水位模块

模块名称：mac_lomac.ko

内核配置行： options MAC_LOMAC

 启动选项： mac_lomac_load="YES"

与 MAC Biba 策略不同，mac_lomac(4)策略允许访问较低完整性对象，但仅在降低完整性级别后方可不破坏任何完整性规则访问。

低水位完整性策略的工作方式几乎与 Biba 相同，唯一的区别是使用浮动标签来支持通过辅助等级隔间实现主体降级。这个辅助隔间的形式为 [auxgrade]。在分配带有辅助等级的策略时，请使用语法 lomac/10[2]，其中 2 是辅助等级。

该策略依赖于对所有系统对象进行完整性标记，允许主体从低完整性对象读取，然后将主体上的标记降级以阻止未来对高完整性对象的写入使用 [auxgrade]。该策略可能提供更高的兼容性，需要比 Biba 更少的初始配置。

像 Biba 和 MLS 政策一样，setfmac 和 setpmac 用于在系统对象上放置标签：

```
# setfmac /usr/home/trhodes lomac/high[low]
# getfmac /usr/home/trhodes lomac/high[low]
```

辅助等级 low 是仅由 MACLOMAC 政策提供的功能。
