# 18.7.MAC Jail 中的 Nagios


本部分演示了在 MAC 环境中实施 Nagios 网络监控系统所需的步骤。这只是一个示例，仍然需要管理员在生产环境中使用之前测试实施的策略是否符合网络的安全要求。

此示例要求在每个文件系统上设置 multilabel。在尝试将其集成到 MAC 框架之前，还假定 net-mgmt/nagios-plugins、net-mgmt/nagios 和 www/apache22 都已安装、配置和正常工作。

### 18.7.1. 创建一个不安全的用户类

通过将以下用户类添加到/etc/login.conf 开始该过程：

```
insecure:\
:copyright=/etc/COPYRIGHT:\
:welcome=/etc/motd:\
:setenv=MAIL=/var/mail/$,BLOCKSIZE=K:\
:path=~/bin:/sbin:/bin:/usr/sbin:/usr/bin:/usr/local/sbin:/usr/local/bin
:manpath=/usr/share/man /usr/local/man:\
:nologin=/usr/sbin/nologin:\
:cputime=1h30m:\
:datasize=8M:\
:vmemoryuse=100M:\
:stacksize=2M:\
:memorylocked=4M:\
:memoryuse=8M:\
:filesize=8M:\
:coredumpsize=8M:\
:openfiles=24:\
:maxproc=32:\
:priority=0:\
:requirehome:\
:passwordtime=91d:\
:umask=022:\
:ignoretime@:\
:label=biba/10(10-10):
```

然后，在默认用户类部分添加以下行：

```
:label=biba/high:
```

保存修改并输入以下命令以重建数据库：

```
# cap_mkdb /etc/login.conf
```

### 18.7.2. 配置用户

将 root 用户设置为默认类别：

```
# pw usermod root -L default
```

现在，所有非 root 的用户账户将需要登录类别。登录类别是必需的，否则用户将被拒绝访问常见命令。以下 sh 脚本应该足够好：

```
# for x in `awk -F: '($3 >= 1001) && ($3 != 65534) { print $1 }' \
	/etc/passwd`; do pw usermod $x -L default; done;
```

接下来，将 nagios 和 www 账户放入不安全的类别中：

```
# pw usermod nagios -L insecure
# pw usermod www -L insecure
```

### 18.7.3. 创建上下文文件

现在应该创建一个名为/etc/policy.contexts 的上下文文件：

```
# This is the default BIBA policy for this system.

# System:
/var/run(/.*)?			biba/equal

/dev/(/.*)?			biba/equal

/var				biba/equal
/var/spool(/.*)?		biba/equal

/var/log(/.*)?			biba/equal

/tmp(/.*)?			biba/equal
/var/tmp(/.*)?			biba/equal

/var/spool/mqueue		biba/equal
/var/spool/clientmqueue		biba/equal

# For Nagios:
/usr/local/etc/nagios(/.*)?	biba/10

/var/spool/nagios(/.*)?		biba/10

# For apache
/usr/local/etc/apache(/.*)?	biba/10
```

该策略通过对信息流的限制来实施安全，在该特定配置中，用户（ 包括 root ）不应允许访问 Nagios。Nagios 的配置文件和进程将完全自包含或被禁锢起来。

运行 setfsmac 后，将在每个文件系统上读取此文件。此示例设置根文件系统的策略：

```
# setfsmac -ef /etc/policy.contexts /
```

接下来，将这些编辑添加到 /etc/mac.conf 的主要部分：

```
default_labels file ?biba
default_labels ifnet ?biba
default_labels process ?biba
default_labels socket ?biba
```

### 18.7.4. Loader 配置

要完成配置，请将以下行添加到/boot/loader.conf 中：

```
mac_biba_load="YES"
mac_seeotheruids_load="YES"
security.mac.biba.trust_all_interfaces=1
```

并将以下行添加到存储在/etc/rc.conf 中的网络卡配置。如果主网络配置通过 DHCP 完成，则可能需要在每次系统启动后手动配置：

```
maclabel biba/equal
```

### 18.7.5. 测试配置

首先，确保 Web 服务器和 Nagios 不会在系统初始化和重启时启动。确保 root 无法访问 Nagios 配置目录中的任何文件。如果 root 可以列出 /var/spool/nagios 的内容，那么有问题。相反，应返回 "权限被拒绝" 错误。

如果一切正常，现在可以启动 Nagios、Apache 和 Sendmail：

```
# cd /etc/mail && make stop && \
setpmac biba/equal make start && setpmac biba/10\(10-10\) apachectl start && \
setpmac biba/10\(10-10\) /usr/local/etc/rc.d/nagios.sh forcestart
```

再次检查以确保一切工作正常。如果没有，请检查错误消息的日志文件。如果需要，使用 sysctl(8) 来禁用 mac_biba(4) 安全策略模块，然后尝试像往常一样重启所有内容。

```
# setpmac biba/10 csh
```

为阻止这种情况发生，强制用户进入范围，使用 login.conf(5)。如果 setpmac(8) 尝试在隔间范围之外运行命令，将返回错误，命令将不会执行。在这种情况下，root 设置为 biba/high(high-high)。
