# 18.8.MAC 框架的故障排除


本节讨论了常见的配置错误以及如何解决它们。

multilabel 标志不能在根 (/) 分区上保持启用以下步骤可能解决这个瞬时错误:

1. 编辑 /etc/fstab 并将根分区设置为 ro 以进行只读。
2. 重启到单用户模式。
3. 在/上运行 tunefs -l enable。
4. 重启系统。
5. 在/上运行 mount -urw，并在/etc/fstab 中将 ro 更改回 rw，然后再次重启系统。
6. 请仔细检查从 mount 的输出，以确保根文件系统已正确设置 multilabel。

在使用 MAC 建立安全环境之后，Xorg 不再启动这可能是 MAC partition 政策造成的，也可能是 MAC 标签政策中的一个标签错误。要进行调试，请尝试以下操作：

1. 检查错误消息。如果用户在 insecure 类中，可能是 partition 政策引起了问题。尝试将用户的类设置回 default 类，并使用 cap_mkdb 重新构建数据库。如果问题仍然存在，请执行第二步。
2. 确保为用户、Xorg 和 /dev 条目正确设置标签策略。
3. 如果以上两者都无法解决问题，请将错误消息和环境说明发送至 FreeBSD 通用问题邮件列表。

_secure_path: unable to stat .login_conf 错误出现当用户尝试从 root 用户切换到系统中的另一个用户时会出现此错误。当用户尝试成为比自己设置更高标签的用户时，通常会出现此消息。例如，如果 joe 的默认标签为 biba/low，而 root 的标签为 biba/high，root 无法查看 joe 的主目录。无论 root 是否使用 su 成为 joe，Biba 完整性模型都不允许 root 查看设置为较低完整性级别的对象。

系统不再识别 root 当发生这种情况时，whoami 返回 0 和 su 返回 who are you?。

如果已通过 sysctl(8) 禁用标签策略或卸载了策略模块，可能会发生这种情况。如果策略已禁用，需要重新配置登录能力数据库。请仔细检查 /etc/login.conf，确保已删除所有 label 选项，并使用 cap_mkdb 重建数据库。

如果策略限制对 master.passwd 的访问也可能导致这种情况。通常是由管理员在使用与系统通用策略冲突的标签下更改文件导致的。在这些情况下，系统将读取用户信息并阻止访问，因为文件已继承新标签。使用 sysctl(8) 禁用策略，一切应该恢复正常。
