# 19.3.审计配置

用户空间对事件审计的支持作为基本的 FreeBSD 操作系统的一部分安装。内核支持默认在通用内核中可用，并且可以通过将以下行添加到/etc/rc.conf 来启用 auditd(8)。

```
auditd_enable="YES"
```

然后，启动审计守护进程:

```
# service auditd start
```

偏爱编译自定义内核的用户必须在其自定义内核配置文件中包含以下行:

```
options	AUDIT
```

### 19.3.1. 事件选择表达式

审计配置中使用选择表达式来确定应该审计哪些事件。表达式包含要匹配的事件类列表。选择表达式从左到右进行评估，通过将一个表达式附加到另一个表达式来组合两个表达式。

默认审计事件类总结了默认的审计事件类：

表 1. 默认审计事件类

| 类名    | 描述           | 操作                                                                                             |
| --------- | ---------------- | -------------------------------------------------------------------------------------------------- |
| 所有    | 所有           | 匹配所有事件类。                                                                  |
| aa      | 身份验证和授权 |                                                                                                  |
| ad      | 管理的         | 对整个系统执行的管理操作。                                                        |
| ap      | 应用程序       | 应用程序定义的操作。                                                              |
| cl      | 文件关闭       | 审核调用 close 系统调用。                                                         |
| ext: ex | 执行           | 执行程序审计。通过 audit_control(5) 使用 argv 和 envv 参数来控制命令行参数和环境变量的审计设置。|
| fa      | 文件属性访问   | 审计对象属性访问，如 stat（1）和 pathconf（2）。                                  |
| fc      | 创建文件       | 作为结果创建文件的审计事件。                                                      |
| fd      | 删除文件       | 发生文件删除的审计事件。                                                          |
| fm      | 文件属性修改   | 当文件属性修改发生时进行审核的事件，例如通过 chown(8)，chflags(1)和 flock(2)。    |
| fr      | 读取文件       | 当数据被读取或文件被打开进行阅读时进行审计事件。                                  |
| 防火墙  | 文件写入       | 数据被写入或文件被写入或修改的审计事件。                                          |
| io      | ioctl          | 使用 ioctl 系统调用审计。                                                         |
| ip      | 进程间通信     | 审计各种形式的进程间通信，包括 POSIX 管道和 System V IPC 操作。                   |
| lo      | 登录注销       | 审计登录(1)和注销(1)事件。                                                        |
| na      | 不可归因的     | 审计不可归因事件。                                                                |
| 否      | 无效的类       | 匹配无审计事件。                                                                  |
| nt      | 网络           | 审计与网络操作相关的事件，例如 connect(2)和 accept(2)。                           |
| ot      | 其他           | 审计其他事件。                                                                    |
| 电脑    | 进程           | 对诸如 exec(3)和 exit(3)之类的操作进行审计。                                      |

可以通过修改 audit_class 和 audit_event 配置文件来定制这些审计事件类别。

每个审计事件类别都可以与前缀组合，指示是否匹配成功/失败的操作，以及该条目是添加还是移除该类别和类型的匹配。审计事件类别的前缀总结了可用的前缀：

表 2. 审计事件类别的前缀

| 前缀   | 动作                                     |
| -------- | ------------------------------------------ |
| +      | 在此类中审计成功事件。    |
| -      | 在此类中审计失败事件。    |
| \^  | 此类中的审计既没有成功也没有失败的事件。|
| \^+ | 不要审计此类中的成功事件。|
| \^- | 不要审核此类中的失败事件。|

如果没有前缀，事件的成功和失败实例都将被审计。

以下示例选择字符串选择成功和失败的登录/注销事件，但只选择成功执行事件。

```
lo,+ex
```

### 19.3.2. 配置文件

安全事件审计的以下配置文件位于 /etc/security：

* audit_class：包含审计类的定义。
* 审计控制：控制审计子系统的各个方面，例如默认审计类、日志卷上保留的最小磁盘空间以及最大审计跟踪大小。
* 审计事件：系统审计事件的文本名称和描述，以及每个事件属于哪些类的列表。
* 审计用户：登录时与全局默认设置相结合的特定用户审计要求。
* audit_warn：由 auditd(8)使用的可定制shell脚本，用于在异常情况下生成警告消息，例如当审计记录空间不足或审计跟踪文件已轮转时。

|  | 审计配置文件应被小心编辑和维护，因为配置错误可能导致事件日志记录不正确。|
| -- | -------------------------------------------------------------------------- |

在大多数情况下，管理员只需要修改 audit_control 和 audit_user 两个文件。第一个文件控制系统范围的审计属性和策略，第二个文件可用于按用户微调审计。

#### 19.3.2.1. The audit_control File

A number of defaults for the audit subsystem are specified in audit_control:

```
dir:/var/audit
dist:off
flags:lo,aa
minfree:5
naflags:lo,aa
policy:cnt,argv
filesz:2M
expire-after:10M
```

The `dir` entry is used to set one or more directories where audit logs will be stored. If more than one directory entry appears, they will be used in order as they fill. It is common to configure audit so that audit logs are stored on a dedicated file system, in order to prevent interference between the audit subsystem and other subsystems if the file system fills.

如果 dist 字段设置为 on 或 yes，则将为/var/audit/dist 中的所有跟踪文件创建硬链接。

flags 字段设置可追溯事件的系统范围默认预选掩码。在上面的示例中，所有用户都对所有用户进行成功和失败的登入/登出事件以及身份验证和授权进行审计。

minfree 条目定义了存储审计跟踪的文件系统的可用空间的最低百分比。

naflags 条目指定要审计的审计类别，用于非属性事件，如登录/注销过程以及身份验证和授权。

policy 条目指定一组逗号分隔的策略标志，控制审计行为的各个方面。cnt 标志表示系统在发生审计失败时应继续运行（强烈建议使用）。另一个标志，argv，使得 execve(2)系统调用的命令行参数作为命令执行的一部分被审计。

filesz 条目指定审计跟踪文件在自动终止和轮转之前的最大大小。0 的值禁用自动日志轮转。如果请求的文件大小低于最低的 512k，则会被忽略，并生成一个日志消息。

expire-after 字段指定审计日志文件何时到期并被删除。

#### 19.3.2.2. 审计用户文件

管理员可以在 audit_user 中为特定用户指定进一步的审计要求。每行通过两个字段配置用户的审计： alwaysaudit 字段指定应始终为用户审计的事件集，neveraudit 字段指定不应为用户审计的事件集。

以下示例条目审计 root 的登录/注销事件和成功的命令执行，并审计 www 的文件创建和成功的命令执行。如果与默认的审计控制（audit_control）一起使用，root 的 lo 条目是多余的，并且登录/注销事件也将被审计 www。

```
root:lo,+ex:no
www:fc,+ex:no
```
