# 19.4.使用审计跟踪

由于审计跟踪是以 BSM 二进制格式存储的，因此有几个内置工具可用于修改或将这些跟踪转换为文本。要将跟踪文件转换为简单的文本格式，请使用 praudit。要为分析、存档或打印目的减少审计跟踪文件，请使用 auditreduce。此实用程序支持各种选择参数，包括事件类型、事件类别、用户、事件的日期或时间，以及所操作的文件路径或对象。

例如，要以纯文本形式转储指定审计日志的全部内容：

```
# praudit /var/audit/AUDITFILE
```

其中，AUDITFILE 是要转储的审计日志。

审计跟踪由一系列审核记录组成，这些记录由标记组成，praudit 按顺序打印，每行一个。每个标记都是特定类型的，例如 header （审核记录头）或 path （来自名称查找的文件路径）。以下是 execve 事件的示例：

```
header,133,10,execve(2),0,Mon Sep 25 15:58:03 2006, + 384 msec
exec arg,finger,doug
path,/usr/bin/finger
attribute,555,root,wheel,90,24918,104944
subject,robert,root,wheel,root,wheel,38439,38032,42086,128.232.9.100
return,success,0
trailer,133
```

此审计表示一个成功的 execve 调用，其中命令 finger doug 已运行。exec arg 令牌包含由 shell 提交给内核的处理命令行。path 令牌保存了内核查找的可执行文件路径。attribute 令牌说明了二进制文件并包括文件模式。subject 令牌存储了审计用户 ID、有效用户 ID 和组 ID、真实用户 ID 和组 ID、进程 ID、会话 ID、port ID 和登录地址。请注意，审计用户 ID 和真实用户 ID 不同，因为用户 robert 在运行此命令之前切换到 root 账户，但使用的是原始经过身份验证的用户进行审计。return 令牌指示成功执行，trailer 结束记录。

XML 输出格式也受支持，并可通过包含 -x 来选择。

由于审计日志可能非常庞大，可以使用 auditreduce 选择记录的子集。此示例选择存储在 AUDITFILE 中的用户 trhodes 生成的所有审计记录：

```
# auditreduce -u trhodes /var/audit/AUDITFILE | praudit
```

audit 组的成员有权限读取/var/audit 中的审计跟踪。默认情况下，此组为空，因此只有 root 用户可以读取审计跟踪。用户可以添加到 audit 组，以委派审计审查权限。由于跟踪审计日志内容能够提供用户和进程行为的重要见解，建议谨慎进行审计审查权限的委派。

### 19.4.1. 使用审计管道进行实时监控

审计管道是克隆伪设备，能让应用程序获取实时审计记录流。这主要是对入侵检测和系统监控应用程序的作者感兴趣。但是，审计管道设备是管理员能让实时监控的便捷方式，而无需担心审计跟踪文件的所有权问题或日志轮替中断事件流。为了跟踪实时审计事件流：

```
# praudit /dev/auditpipe
```

默认情况下，审计管道设备节点仅对 root 用户可访问。要使它们对 audit 组的成员可访问，请向/etc/devfs.rules 中添加 devfs 规则：

```
add path 'auditpipe*' mode 0440 group audit
```

有关配置 devfs 文件系统的更多信息，请参阅 devfs.rules(5)。

|  | 很容易产生审计事件反馈循环，即查看每个审计事件会导致更多审计事件的生成。例如，如果对所有网络 I/O 进行审计，并且从 SSH 会话中运行 praudit，将以较高速率生成持续的审计事件流，因为打印每个事件将生成另一个事件。因此，建议在没有细粒度 I/O 审计的会话中从审计管道设备运行 praudit。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

### 19.4.2. 旋转和压缩审计跟踪文件

内核写入审计跟踪，由审计守护程序 auditd(8) 管理。管理员不应尝试使用 newsyslog.conf(5) 或其他工具直接旋转审计日志。取而代之的是，audit 应该用于关闭审计，重新配置审计系统，并执行日志轮转。以下命令会导致审计守护程序创建新的审计日志，并向内核发信号切换到使用新日志。旧日志将被终止并重命名，此时管理员可以对其进行操作。

```
# audit -n
```

如果 auditd(8) 当前未运行，则此命令将失败并生成错误消息。

将以下行添加到 /etc/crontab 将安排每十二小时进行此轮换：

```
0     */12       *       *       *       root    /usr/sbin/audit -n
```

保存 /etc/crontab 之后，更改将生效。

可以根据文件大小在 audit_control 中使用 filesz 进行审计跟踪文件的自动轮换，就像《审计控制文件》中所说明的那样。

由于审计跟踪文件可能变得非常大，因此通常希望在审计守护程序关闭后压缩或归档这些跟踪文件。audit_warn 脚本可用于执行各种与审计相关事件的定制操作，包括在轮转审计跟踪文件时清理终止审计跟踪。例如，可以添加以下内容到/etc/security/audit_warn 以在关闭时压缩审计跟踪：

```
#
# Compress audit trail files on close.
#
if [ "$1" = closefile ]; then
        gzip -9 $2
fi
```

其他归档活动可能包括将跟踪文件复制到集中服务器，删除旧的跟踪文件或缩减审计跟踪以删除不必要的记录。此脚本仅在审计跟踪文件被干净地终止时运行。它不会在因不正确关闭而导致的未终止跟踪上运行。
