# 2.3.安装前的准备工作

在确定设备满足安装 FreeBSD 的最低硬件要求后，就可以下载安装文件，准备安装介质了。

>**技巧**
>
>如果你想在已安装其他操作系统的系统上使用 FreeBSD，请考虑使用[虚拟化](https://docs.freebsd.org/en/books/handbook/virtualization/#virtualization)。


在进行安装之前，请检查下列清单中的项目，查看系统是否准备就绪：

>1. **备份重要数据**  
>
>    在安装任何操作系统之前，请 **始终** 先备份所有重要数据。不要将备份存储在要安装的系统上，而应将数据保存到可移动磁盘，如 USB 驱动器、网络上的其他系统和在线备份服务。请在开始安装之前测试备份，以确保它包含所有所需文件。在安装程序格式化系统磁盘后，存储在该磁盘上的所有数据都将丢失。
>
>2. **选择安装 FreeBSD 的位置**  
>
>    如果你仅安装 FreeBSD 这一个操作系统，则可以跳过此步骤。但如果 FreeBSD 将与其他操作系统共享磁盘，则需决定使用哪块磁盘和分区。
>
>    在 i386 和 amd64 架构中，可以使用两种分区方案之一将磁盘划分为多个分区。传统的 *主引导记录*（MBR）包含一个分区表，最多可定义四个 *主分区*。出于历史原因，FreeBSD 称这些主分区为 *切片*（slice）。其中某主分区可以作为 *扩展分区*，可包含多个 *逻辑分区*。*GUID 分区表*（GPT）是一种新款且更简单的磁盘分区方法。常见的 GPT 实现可使每块磁盘最多有 128 个分区，消除了对逻辑分区的需求。
>
>    FreeBSD 引导加载程序需要一个主分区/GPT 分区。如果所有主分区/GPT 分区已被使用，则必须为 FreeBSD 释放一个分区。要在不删除现有数据的情况下创建分区，可以使用分区调整工具缩小现有分区，使用释放的空间创建新分区。
>
>    另一种修改系统现有磁盘分区的方法是使用[虚拟化](https://docs.freebsd.org/en/books/handbook/virtualization/#virtualization)，这能让多个操作系统同时运行，而无需更改分区。
>
>    各种免费和商业的分区调整工具列在[磁盘分区软件列表的维基百科条目](https://en.wikipedia.org/wiki/List_of_disk_partitioning_software)上。[GParted Live](https://gparted.org/livecd.php) 是一款免费的 Live CD，内置 GParted 分区编辑器。
>
>>**警告**
>>
>>若使用得当，磁盘缩小工具可安全地为创建新分区创造空间。由于可能选择错误的分区，请始终备份重要数据，并在修改磁盘分区之前检查备份的完整性。 
>
>　　包含不同操作系统的磁盘分区使在一台计算机上安装多个操作系统成为可能。
>
>3. **收集网络信息**  
>
>    某些 FreeBSD 安装方法需要网络连接用于下载安装文件。在安装后，安装程序会提供设置系统网络接口的选项。
>
>    如果网络有 DHCP 服务器，则可以用它来提供自动网络配置。如果没有 DHCP，则必须从本地网络管理员或互联网服务提供商获取以下网络信息：
>
>    所需的网络信息：
>
>    1. IP 地址
>    2. 子网掩码
>    3. 默认网关的 IP 地址
>    4. 网络的域名
>    5. 网络的 DNS 服务器 IP 地址
>
>4. **查阅 FreeBSD Errata**  
>
>    尽管 FreeBSD 项目努力确保每款 FreeBSD RELEASE 都尽可能地稳定，但偶尔会出现 bug。在极少数情况下，这些 bug 会影响安装过程。随着这些问题的发现和修复，它们会在每个 RELEASE 的 FreeBSD Errata 页面上注明。请在安装前查阅 errata，以确保不存在可能影响安装的问题。
>
>    可以在[FreeBSD 版本信息](https://www.freebsd.org/releases/)页面找到所有 RELEASE 的信息及 errata 。

## 2.3.1. 准备安装介质

FreeBSD 安装程序不是能在其他操作系统中运行的应用程序。请下载 FreeBSD 安装文件，将其刻录到与其文件类型和大小相对应的介质（CD、DVD 或 USB）上，然后从插入的介质安装启动系统。

可以在 [FreeBSD 下载页面](https://www.freebsd.org/where/)上获取 FreeBSD 安装文件。每个安装文件的名称包括 FreeBSD 的发布版本、架构和文件类型。

安装文件以多种格式提供，可以使用 [xz(1)](https://man.freebsd.org/cgi/man.cgi?query=xz&sektion=1&format=html) 压缩/未压缩。格式因计算机架构和介质类型而异。

安装文件类型：

- `-bootonly.iso`：这是最小的安装文件，仅包含安装程序。安装过程中需要一个有效的互联网连接，因为安装程序会下载完成 FreeBSD 安装所需的文件。该文件应刻录到光盘上。
- `-disc1.iso`：该文件包含安装 FreeBSD 所需的所有文件、源代码和 Ports。应将该文件刻录到光盘上。
- `-dvd1.iso`：该文件包含安装 FreeBSD 所需的所有文件、源代码和 Ports。它还包含一组流行的二进制包，用于安装窗口管理器和一些应用程序，以便可以从介质安装完整的系统，而无需连接互联网。应将该文件刻录到光盘上。
- `-memstick.img`：该文件包含安装 FreeBSD 所需的所有文件、源代码和 Ports。将此文件写入 USB 闪存驱动器，如[写入 USB 镜像文件](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-usb)所示。
- `-mini-memstick.img`：与 `-bootonly.iso` 类似，不包含安装文件，而是根据需要下载。安装过程中需要一个有效的互联网连接。应将其写入 USB 闪存驱动器，如[写入 USB 镜像文件](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-usb)所示。

下载镜像文件后，请从同一目录下载至少一个 *checksum*（校验和）文件。有两个校验和文件可用，文件名包含发布编号和架构名称。例如：`CHECKSUM.SHA256-FreeBSD-13.1-RELEASE-amd64` 和 `CHECKSUM.SHA512-FreeBSD-13.1-RELEASE-amd64`。

下载其中一个文件（或两个文件）后，计算镜像文件的校验和并与 *checksum* 文件中显示的进行比较。请注意，你需要将计算出的校验和与正确的文件进行比较，因为它们对应于两种不同的算法：SHA256 和 SHA512。FreeBSD 提供了 [sha256(1)](https://man.freebsd.org/cgi/man.cgi?query=sha256&sektion=1&format=html)、[sha512(1)](https://man.freebsd.org/cgi/man.cgi?query=sha512&sektion=1&format=html) 用于计算 *checksum*。其他操作系统也有类似的程序。

在 FreeBSD 中，可以通过执行以下命令自动完成校验和的验证：

```sh
% sha256sum -c CHECKSUM.SHA256-FreeBSD-13.1-RELEASE-amd64 FreeBSD-13.1-RELEASE-amd64-dvd1.iso
FreeBSD-13.1-RELEASE-amd64-dvd1.iso: OK
```

校验和必须完全匹配。如果校验和不符合，则镜像文件已损坏，必须重新下载。

### 2.3.1.1. 将镜像文件写入 USB

`*memstick.img` 文件是 USB 闪存驱动器内容的 *镜像*。它 *不能* 作为文件复制到目标设备。可用多个应用程序将 `*.img` 写入 USB 闪存驱动器。本节介绍了其中两个工具。

>**重要**
>
>在继续之前，请备份 USB 闪存驱动器上的所有重要数据。此过程将删除驱动器上的现有数据。


>**使用 ​`dd`​ 写入镜像的步骤**
>
>>**警告**
>>
>>此示例使用 `/dev/da0` 作为目标设备，镜像将在此设备上写入。请 **务必小心**，使用正确的设备，因为此命令将删除指定目标设备上的现有数据。 
>
>1. 此命令行工具可在 BSD、Linux® 和 Mac OS® 系统上使用。要使用 `dd` 刻录镜像，请插入 USB 闪存驱动器，然后确定其设备名称。接下来，指定下载的安装文件的名称和 USB 闪存驱动器的设备名称。此示例将在现有 FreeBSD 系统的首个 USB 设备上刻录 amd64 安装镜像。
>
>   ```sh
>   # dd if=FreeBSD-13.1-RELEASE-amd64-memstick.img of=/dev/da0 bs=1M conv=sync
>   ```
>
>   如果此命令失败，请检查，不应挂载 USB 闪存驱动器，并且设备名称是磁盘，而非分区。
>
>   某些操作系统可能要求使用 [sudo(8)](https://man.freebsd.org/cgi/man.cgi?query=sudo&sektion=8&format=html) 运行此命令。[dd(1)](https://man.freebsd.org/cgi/man.cgi?query=dd&sektion=1&format=html) 的语法在不同平台之间略有不同；例如，Mac OS® 需要小写的 `bs=1m`。像 Linux® 这样的系统可能会缓冲写入。要强制所有写入完成，请使用 [sync(8)](https://man.freebsd.org/cgi/man.cgi?query=sync&sektion=8&format=html)。

>**使用 Windows® 写入镜像的步骤**
>
>**警告**
>
>>请确保选择了正确的驱动器字母，因为所指定驱动器上的现有数据将被覆盖和删除。
>
>1. **获取 Windows® 镜像写入工具**  
>
>   Windows® 镜像写入工具是一款免费应用程序，可以正确地将镜像文件写入 USB 闪存驱动器。请从 [win32diskimager 主页](https://sourceforge.net/projects/win32diskimager/)下载，然后将其解压到一个文件夹中。
>
>2. **使用镜像写入工具写入镜像**  
>
>   双击 Win32DiskImager 图标可启动程序。验证 `Device` 下显示的驱动器字母是否有 USB 闪存驱动器。单击文件夹图标，选择要写入内存棒的镜像。单击 **Save** 以接受镜像文件名。验证一切是否正确，并确保 USB 闪存驱动器中的文件夹未在其他窗口中打开。待一切准备就绪，单击 **Write** 将镜像文件写入内存棒。
