# 2.4.开始安装


>**重要**
>
>在默认情况下，出现以下信息之前，安装器将不会对磁盘进行任何更改：
>
>```sh
>Your changes will now be written to disk. If you
>have chosen to overwrite existing data, it will
>be PERMANENTLY ERASED. Are you sure you want to
>commit your changes?
>```
>
>在此警告之前，可以随时退出安装。如果担心某些配置错误，只需在此之前关闭计算机，设备磁盘将不会有任何变更。

本节讲解了如何从使用[准备安装介质](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-installation-media)的说明准备的安装介质启动系统。当使用可引导 USB 闪存驱动器时，请在打开计算机之前插入 USB 闪存驱动器。当从 CD/DVD 启动时，请在打开计算机后立刻插入介质。如何配置系统从插入的介质启动取决于架构。

## 2.4.1. FreeBSD 引导加载程序菜单

在系统从安装介质启动后，将显示类似如下内容的菜单：

![FreeBSD 引导加载程序菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-newboot-loader-menu.png)

**图 1. FreeBSD 引导加载程序菜单**

在默认情况下，在启动 FreeBSD 安装程序（在 FreeBSD 已安装的情况下会启动 FreeBSD）之前菜单将等待十秒钟。要暂停启动计时器来查看选项，请按 **空格键**。要选择某选项，请按其高亮显示的数字、字符/按键。以下选项可用。

- `Boot Multi User`：将继续 FreeBSD 启动过程。如果启动计时器已暂停，请按 **1**、大写/小写的 **B** 或 **回车键**。
- `Boot Single User`：此模式可用于修复现有的 FreeBSD 安装，详见[“单用户模式”](https://docs.freebsd.org/en/books/handbook/boot/#boot-singleuser)。按 **2** 或大写/小写的 **S** 可进入此模式。
- `Escape to loader prompt`：将系统引导到修复提示符，其包含少量的底层命令。此提示在[“第三阶段”](https://docs.freebsd.org/en/books/handbook/boot/#boot-loader)中进行了说明。按 **3** 或 **Esc** 可进入此提示。
- `Reboot`：重新启动系统。
- `Cons`：可通过 `video`、`serial`、`Dual (serial primary)` 或 `Dual (Video primary)` 继续安装。
- `Kernel`：加载不同的内核。
- `Boot Options`：打开在[FreeBSD 引导选项菜单](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-boot-options-menu) 中显示和说明的菜单。

![显示不同引导选项的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-boot-options-menu.png)

**图 2. FreeBSD 引导选项菜单**

引导选项菜单分为两个部分。第一部分可用于返回主引导菜单或将任何已切换的选项重置为默认值。

下一部分用于通过按选项的高亮数字/字符来切换可用选项为 `On`/`Off`。系统将始终使用这些选项的设置进行引导，直到它们被修改。可以通过此菜单切换几个选项：

- `ACPI Support`：如果在引导期间系统卡住，请尝试将此选项切换为 `Off`。此选项仅在可用但非必需的情况下存在。
- `Safe Mode`：如果哪怕在将 `ACPI Support` 设置为 `Off` 的情况下系统仍然卡住，请尝试将此选项设置为 `On`。
- `Single User`：将此选项切换为 `On` 可修复现有的 FreeBSD 安装，详见[“单用户模式”](https://docs.freebsd.org/en/books/handbook/boot/#boot-singleuser)。解决问题后，情切换回 `Off`。
- `Verbose`：将此选项切换为 `On` 以查看引导过程中的详细消息。这在故障排除硬件时可能很有用。

在做出必要的选择后，按 **1** 或 **退格键** 返回主引导菜单，然后按 **回车键** 继续引导 FreeBSD。随着 FreeBSD 进行硬件设备探测、加载安装程序，会出现一系列引导信息。引导完成后，将显示[欢迎菜单](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-choose-mode)。

![FreeBSD 安装欢迎菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-choose-mode.png)

**图 3. 欢迎菜单**

按 **回车键** 可选择默认的 **Install** 进入安装程序。本章的其余部分解释了如何使用此安装程序。还可以使用左右箭头/彩色字母选择所需的菜单项。**Shell** 可以用于使用 FreeBSD shell，能在安装之前使用命令行工具准备磁盘。选项 **Live CD** 可用于在安装之前试用 FreeBSD。Live 版本在[使用 Live CD](https://docs.freebsd.org/en/books/handbook/bsdinstall/#using-live-cd) 中进行了介绍。

>**技巧**
>
>要查看引导消息，包括硬件设备探测，请按大写/小写的 **S**，然后按 **回车键** 以访问 shell。在 shell 提示符下，输入 `more /var/run/dmesg.boot`，再使用 **空格键** 滚动信息。在完成后，输入 `exit` 可返回欢迎菜单。 
