# 2.5.使用 bsdinstall


本部分展示了 bsdinstall 菜单的顺序以及在系统安装之前将询问的信息类型。使用箭头键高亮菜单选项，然后按 **空格键** 选择/取消选择该菜单项。在完成后，按 **回车键** 可保存选择，进入下一个界面。

## 2.5.1. 键盘布局选择菜单

在开始安装过程之前，bsdinstall 将加载键盘布局文件，如[加载键盘布局](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-keymap-loading)所示。

![加载键盘布局](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-keymap-loading.png)

**图 4. 键盘布局加载**

在加载键盘布局后，bsdinstall 将显示[键盘布局选择菜单](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-keymap-10)。使用上下箭头选择与系统接入的键盘最相符的键盘布局。按 **回车键** 保存选择。

![键盘布局选择菜单，显示所有受支持的键盘](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-keymap-10.png)

**图 5. 键盘布局选择菜单**

>**注意**
>
>按 **Esc** 可退出此菜单，使用默认键盘布局。如果不确定要选择哪个键盘布局，使用 United States of America ISO-8859-1 也是一个稳妥的选择。 

此外，在选择不同的键盘布局时，用户可测试该布局，确保正确，然后再继续，如[键盘布局测试菜单](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-keymap-testing)中所示。

![键盘布局测试菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-keymap-testing.png)

**图 6. 键盘布局测试菜单**

## 2.5.2. 设置主机名

接下来的 bsdinstall 菜单用于为新安装的系统设置主机名。

![设置主机名](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-config-hostname.png)

**图 7. 设置主机名**

输入在网络中唯一的主机名。应为一个完全限定的主机名，例如 `machine3.example.com`。

## 2.5.3. 选择要安装的组件

接下来，bsdinstall 将提示选择要安装的可选组件。

![可以安装的不同组件。例如：base-dbg](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-config-components.png)

**图 8. 选择要安装的组件**

决定安装哪些组件在很大程度上取决于系统的预期用途和可用的磁盘空间。FreeBSD 内核和用户空间，统称为 *基本系统*，始终会被安装。根据架构，某些组件可能不会出现：

* `base-dbg`——含有调试符号的基础工具，如 cat 和 ls 等。
* `kernel-dbg`——含有调试符号的内核和模块。
* `lib32-dbg`——用于在 64 位版本 FreeBSD 上运行 32 位应用程序的兼容库，含有调试符号。
* `lib32``——用于在 64 位版本 FreeBSD 上运行 32 位应用程序的兼容库。
* `ports``——FreeBSD Ports 是一个文件集，可自动下载、编译和安装第三方软件包。有关如何使用 Ports 的信息，请参见[安装应用程序：软件包和 Ports](https://docs.freebsd.org/en/books/handbook/ports/#ports)。

>**警告**
>
>安装程序不会检查磁盘空间是否充足。请仅在有足够硬盘空间的情况下选择此选项。FreeBSD Ports 约占用 3 GB 磁盘空间。

* `src`——FreeBSD 内核和用户空间的完整源代码。虽然大多数应用程序并不需要，但可能需要构建设备驱动程序、内核模块或某些来自 Ports 的应用程序。它也用于开发 FreeBSD 本身。完整的源代码需要 1 GB 磁盘空间，重新编译整个 FreeBSD 系统需要额外的 5 GB 空间。
* `tests`——FreeBSD 测试套件。

## 2.5.4. 从网络安装

在[从网络安装](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-netinstall-notify)中显示的菜单仅在安装 `-bootonly.iso`/`-mini-memstick.img` 时出现，因为这些安装介质未包含安装文件的副本。由于必须通过网络连接下载安装文件，因此该菜单要求必须先配置网络接口。如果在安装过程中显示此菜单，请记得遵循[配置网络接口](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-config-network-dev)中的说明。

![指示未找到某些组件并将通过网络下载](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-netinstall-files.png)

**图 9. 网络安装**
