# 2.6.分配磁盘空间

接下来的菜单用于确定磁盘空间的分配方法。

![显示不同的分区选项。如：手动](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-zfs-partmenu.png)

**图 10. 分区选择**

bsdinstall 提供了四种磁盘空间分配方法：

* `Auto (ZFS)` 分区可创建一个基于 ZFS 的根文件系统，并可选支持 *引导环境* 的 GELI 加密。
* `Auto (UFS)` 分区可自动设置使用 `UFS` 文件系统的磁盘分区。
* `Manual` 分区能让高级用户从菜单选项中创建自定义分区。
* `Shell` 将打开命令行提示符，高级用户可使用命令行工具（如 [gpart(8)](https://man.freebsd.org/cgi/man.cgi?query=gpart&sektion=8&format=html)、[fdisk(8)](https://man.freebsd.org/cgi/man.cgi?query=fdisk&sektion=8&format=html) 和 [bsdlabel(8)](https://man.freebsd.org/cgi/man.cgi?query=bsdlabel&sektion=8&format=html)）创建自定义分区。

本节说明了在布置磁盘分区时需要考虑的事项。然后演示了如何使用不同的分区方法。

## 2.6.1. 设计分区布局

默认的文件系统分区布局有一个用于整个系统的文件系统。在使用 `UFS` 时，如果有足够的磁盘空间或多块磁盘，规划使用多个文件系统是值得的。在布局文件系统时，请记住，硬盘从外圈到内圈的数据传输速度更快。因此，较小且访问频繁的文件系统应靠近硬盘外侧，而较大的分区（如 `/usr`）应放置在磁盘的内侧。创建分区的顺序建议类似于：`/`、交换分区、`/var` 和 `/usr`。

`/var` 分区的大小反映了预期机器的使用情况。此分区用于存放邮箱、日志文件和打印缓存。邮箱和日志文件的大小可能会因用户数量和日志文件保留时间的不同而意外增长。通常情况下，大多数用户的 `/var`，无需超过约 1 GB 的空闲磁盘空间。

>**注意**
>
>有时，`/var/tmp` 需要大量磁盘空间。当安装新软件时，打包工具会在 `/var/tmp` 下解压缩软件包的临时副本。如果 `/var/tmp` 下没有足够的磁盘空间，在安装大型软件包（如 Firefox/LibreOffice）时可能会很棘手。 

`/usr` 分区存放了许多支持系统的文件，包括 FreeBSD Ports 和系统源代码。建议为此分区分配至少 2 GB 的空间。另外，用户的主目录默认放在 `/usr/home`，但可以放在其他分区。在默认情况下，`/home` 是指向 `/usr/home` 的符号链接。

在选择分区大小时，请考虑空间需求。当一个分区中空间用尽，而另一个几乎未使用时可能会很麻烦。

作为经验法则，交换分区的大小应约为物理内存（RAM）大小的两倍。内存较少的系统（交换分区在较大内存配置下可更小）可能在配置更大交换分区时表现更好。配置过小的交换分区可能会导致虚拟内存页面扫描代码效率低下，并在增加更多内存时可能出现问题。

在配备多块 SCSI 磁盘或多个在不同控制器上运行的 IDE 磁盘的大型机上，建议为每个驱动器都配置交换分区，最多可达四个驱动器。交换分区的大小应大致相同。内核可以处理任意大小，但内部数据结构的规模为最大交换分区的 4 倍。保持交换分区大小相近将使内核能够在磁盘之间最优地划分交换空间。较大的交换空间可能会引发内核关于总配置交换的警告信息。如警告信息所示，通过增加用于跟踪交换分区分配的内存量，可以提高此限制。在强制重启之前，可能更容易从失控程序中恢复。

通过正确分区，较小的写入密集型分区引入的碎片将不会扩散到主要用于读取的分区。将写入负载较重的分区靠近磁盘边缘将提高这些分区的 I/O 性能。虽然较大分区中的 I/O 性能可能是必要的，但将它们更多地移向磁盘边缘不会比将 `/var` 移向边缘带来显著的性能提升。

## 2.6.2. 使用 UFS 的引导分区

选择此方法后，将显示可用磁盘的菜单。如果连接了多块磁盘，请选择要安装 FreeBSD 的磁盘。

![显示可以安装 FreeBSD 的磁盘列表](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-part-guided-disk.png)

**图 11. 从多块磁盘中选择**

选择磁盘后，下一菜单提示要么安装到整块磁盘，要么使用空闲空间创建分区。若选择 **Entire Disk**，则会自动创建填充整块磁盘的一般分区布局。选择 **Partition** 则会从磁盘上的未使用空间创建分区布局。

![菜单询问用户是否要使用磁盘上所有可用空间或希望创建分区](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-part-entire-part.png)

**图 12. 选择整块磁盘/分区**

选择 **Entire Disk** 选项后，bsdinstall 会显示一个对话框，指示磁盘将被擦除。

![菜单指示用户磁盘上的所有数据将被删除并询问确认](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-ufs-warning.png)

**图 13. 确认**

下一个菜单显示可用分区方案类型的列表。对于 amd64 计算机，GPT 通常是最合适的选择。对于不兼容 GPT 的旧计算机，应使用 MBR。其他分区方案通常用于不常见或旧计算机。更多信息请参见 [分区方案](https://docs.freebsd.org/en/books/handbook/bsdinstall/#partition-schemes)。

![菜单向用户显示不同类型的分区，并请求选择其中一种](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-part-manual-partscheme.png)

**图 14. 选择分区方案**

在创建分区布局后，请检查以确保满足安装需求。选择 **Revert** 将重置分区为其原始值。按 **Auto** 将重新创建自动 FreeBSD 分区。分区也可以手动创建、修改或删除。当分区正确时，选择 **Finish** 继续安装。

![菜单显示已创建的分区](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-part-review.png)

**图 15. 审阅已创建的分区**

磁盘配置完成后，下一菜单提供最后一次机会在格式化选定驱动器之前进行更改。如果需要更改，请选择 **Back** 返回到主分区菜单。选择 **Revert & Exit** 将在不对驱动器进行任何更改的情况下退出安装程序。选择 **Commit** 可开始安装过程。

![菜单指示用户所有更改将写入磁盘，并告知如果决定继续，现有数据将被永久删除。](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-final-confirmation.png)

**图 16. 最终确认**

要继续安装过程，请转到 [获取分发文件](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-fetching-distribution)。

## 2.6.3. 手动分区

选择此方法将打开分区编辑器：

![显示分区编辑器的菜单。](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-part-manual-create.png)

**图 17. 手动创建分区**

高亮显示安装驱动器（在此示例中为 `ada0`），然后选择 **Create** 可显示可用分区方案的菜单：

![显示不同类型分区方案的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-part-manual-partscheme.png)

**图 18. 手动创建分区**

GPT 通常是 amd64 计算机最合适的选择。不兼容 GPT 的较旧计算机应使用 MBR。其他分区方案通常用于不常见或较旧的计算机。

**表 1. 分区方案**

|缩写 | 说明 |
 | :----: | :---- |
| APM | Apple 分区表，供 PowerPC® 使用。 |
| BSD | 无 MBR 的 BSD 标签，有时称为 *危险专用模式*，因为非 BSD 磁盘工具可能无法识别它。 |
| GPT | [GUID 分区表](https://en.wikipedia.org/wiki/GUID_Partition_Table)。 |
| MBR | [主引导记录](https://en.wikipedia.org/wiki/Master_boot_record)。 |

选择并创建分区方案后，再次选择 **Create** 可创建分区。使用 **Tab** 可以将焦点移到字段（在循环浏览 **<OK>**、**<Options>** 和 **<Cancel>** 后）。

![请求类型的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-part-manual-addpart.png)

**图 19. 手动创建分区**

标准 FreeBSD GPT 安装至少使用三个分区，包括 UFS 或 ZFS：

* `freebsd-boot`/`efi`——存放 FreeBSD 启动代码。
* `freebsd-ufs`——FreeBSD UFS 文件系统。
* `freebsd-zfs`——FreeBSD ZFS 文件系统。更多有关 ZFS 的信息，请参见 [Z 文件系统 (ZFS)](https://docs.freebsd.org/en/books/handbook/zfs/#zfs)。
* `freebsd-swap`——FreeBSD 交换空间。

有关可用 GPT 分区类型的说明，请参见 [gpart(8)](https://man.freebsd.org/cgi/man.cgi?query=gpart&sektion=8&format=html)。

可以创建多个文件系统分区。有些人喜欢传统布局，为 `/`、`/var`、`/tmp` 和 `/usr` 分配单独的分区。

>**技巧**
>
>注意，`/tmp` 可以稍后作为基于内存的文件系统（[tmpfs(5)](https://man.freebsd.org/cgi/man.cgi?query=tmpfs&sektion=5&format=html)）添加，前提是系统内存足够。 

有关示例，请参见[创建传统拆分文件系统分区](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-part-manual-splitfs)。

`Size` 可以用常用缩写输入：*K* 代表千字节，*M* 代表兆字节，*G* 代表吉字节。

>**技巧**
>
>正确的扇区对齐可以提供最佳性能，且将分区大小设为 4K 字节的偶数倍有助于确保在 512 字节/4K 字节扇区的驱动器上保持对齐。一般来说，使用 1M/1G 的偶数倍分区大小是确保每个分区从 4K 的偶数倍开始的最简单方法。有个例外：由于当前引导代码的限制，*freebsd-boot* 分区的大小不得超过 512K。 

如果分区将包含文件系统，则需要一个 `Mountpoint`。如果只创建单个 UFS 分区，挂载点应为 `/`。

`Label` 是分区的名称。驱动器名称或编号在驱动器连接到不同控制器/端口时可能会变化，但分区标签不会变化。在像 `/etc/fstab` 这样的文件中使用标签而不是驱动器名称和分区编号，使系统对硬件变化更具兼容性。GPT 标签在连接磁盘时出现在 `/dev/gpt/` 中。其他分区方案具有不同的标签功能，其标签出现在 `/dev/` 中的不同目录。

>**技巧**
>
>在每个分区上使用唯一标签以避免相同标签的冲突。可以在标签中添加计算机名称、用途或位置的一些字母。例如，可以将 UFS 根分区的标签设置为 `labroot` 或 `rootfslab`，前提是计算机命名为 `lab`。 

>**示例 1. 创建传统拆分文件系统分区**
>
>对于传统的分区布局，其中 `/`、`/var`、`/tmp` 和 `/usr` 目录在各自的分区上是单独的文件系统，创建一个 GPT 分区方案，然后按如下所示创建分区。所示的分区大小适用于 20G 的目标磁盘。如果目标磁盘上有更多空间，较大的交换分区或 `/var` 分区可能会很有用。这里显示的标签以 `ex` 开头表示“示例”，但读者应使用上述说明的其他唯一标签值。
>
>在默认情况下，FreeBSD 的 `gptboot` 期望第一个 UFS 分区为 `/` 分区。
>
>| 分区类型 | 大小                                       | 挂载点 | 标签 |
>| :--------: | :--------------------------------------------: | :------------: | :-------: |
>| `freebsd-boot`               | `512K`                                           |            |       |
>| `freebsd-ufs`               | `2G`                                           | `/`           | `exrootfs`      |
>| `freebsd-swap`               | `4G`                                           |            | `exswap`      |
>| `freebsd-ufs`               | `2G`                                           | `/var`           | `exvarfs`      |
>| `freebsd-ufs`               | `1G`                                           | `/tmp`           | `extmpfs`      |
>| `freebsd-ufs`               | 使用默认值（剩余磁盘空间） | `/usr`           | `exusrfs`      |

创建自定义分区后，选择 **Finish** 可继续安装，并转到 [获取发行版文件](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-fetching-distribution)。

## 2.6.4. 使用 ZFS 根文件系统的引导分区

此分区模式仅适用于整块磁盘，将清除整块磁盘的内容。主要的 ZFS 配置菜单提供多个选项以控制池的创建。

![显示配置 ZFS 池的不同选项的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-zfs-menu.png)

**图 20. ZFS 分区菜单**

以下是此菜单中选项的概述：

* `Install`——使用选定的选项继续安装。
* `Pool Type/Disks`——配置 `Pool Type` 和将构成池的磁盘。自动 ZFS 安装程序目前仅支持创建一个顶级 vdev，除非在条带模式下。要创建更复杂的池，请参阅 [Shell 模式分区](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-part-shell) 中的说明。
* `Rescan Devices`——重新填充可用磁盘的列表。
* `Disk Info`——此菜单可用于检查每块磁盘，包括其分区表以及设备型号和序列号等其他信息（如可用）。
* `Pool Name`——确定池的名称。默认名称为 *zroot*。
* `Force 4K Sectors?`——强制使用 4K 扇区。默认情况下，安装程序将自动创建与 4K 边界对齐的分区，并强制 ZFS 使用 4K 扇区。这在 512 字节扇区的磁盘上是安全的，并且可以确保在 512 字节磁盘上创建的池将来可以添加 4K 扇区的磁盘，无论是作为额外的存储空间还是替换故障磁盘。按 **回车键** 选择是否激活此选项。
* `Encrypt Disks?`——加密磁盘允许用户使用 GELI 对磁盘进行加密。有关磁盘加密的更多信息，请参见 [“使用 geli 进行磁盘加密”](https://docs.freebsd.org/en/books/handbook/disks/#disks-encrypting-geli)。按 **回车键** 选择是否激活此选项。
* `Partition Scheme`——选择分区方案。大多数情况下推荐使用 GPT。按 **回车键** 在不同选项之间进行选择。
* `Swap Size`——确定交换空间的大小。
* `Mirror Swap?`——是否在磁盘之间镜像交换。请注意，启用镜像交换将破坏崩溃转储。按 **回车键** 激活或不激活此选项。
* `Encrypt Swap?`——是否加密交换。每次系统启动时将使用临时密钥加密交换，并在重启时丢弃。按 **回车键** 选择是否激活此选项。有关交换加密的更多信息，请参见 [“加密交换分区”](https://docs.freebsd.org/en/books/handbook/disks/#swap-encrypting)。

选择 **T** 可配置 `Pool Type` 和将构成池的磁盘。

![请求虚拟设备类型的菜单。如：条带](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-zfs-vdev_type.png)

**图 21. ZFS 池类型**

以下是此菜单中可以选择的 `Pool Type` 的摘要：

* `stripe`——条带化提供所有连接设备的最大存储，但没有冗余。如果仅有一块磁盘故障，池中的数据将永久丢失。
* `mirror`——镜像在每块磁盘上存储所有数据的完整副本。镜像提供良好的读取性能，因为数据是从所有磁盘并行读取的。写入性能较慢，因为数据必须写入池中的所有磁盘。允许除了一块磁盘外的所有磁盘故障。此选项至少需要两块磁盘。
* `raid10`——条带镜像。提供最佳性能，但存储容量最少。此选项需要偶数块磁盘，至少四块磁盘。
* `raidz1`——单重冗余 RAID。允许一块磁盘同时故障。此选项至少需要三块磁盘。
* `raidz2`——双重冗余 RAID。允许两块磁盘同时故障。此选项至少需要四块磁盘。
* `raidz3`——三重冗余 RAID。允许三块磁盘同时故障。此选项至少需要五块磁盘。

选择了 `Pool Type` 后，将显示可用磁盘的列表，系统会提示用户选择一块或多块磁盘以构成池。然后将验证配置，以确保选择了足够的磁盘。如果验证失败，请选择 **<Change Selection>** 返回磁盘列表，或选择 **<Back>** 更改 `Pool Type`。

![请求添加到池的磁盘数量的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-zfs-disk_select.png)

**图 22. 磁盘选择**

![指示未选择足够磁盘的菜单。](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-zfs-vdev_invalid.png)

**图 23. 无效选择**

如果列表中缺少一块或多块磁盘，或在启动安装程序后新加了磁盘，请选择 **- Rescan Devices** 可刷新可用磁盘的列表。

![重新设备扫描](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-zfs-rescan-devices.png)

**图 24. 重新扫描设备**

为了避免意外擦除错误的磁盘，可以使用菜单 **- Disk Info** 检查每块磁盘，包括其分区表以及设备型号和序列号等其他信息（如果可用）。

![显示分区信息的菜单。](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-zfs-disk_info.png)

**图 25. 分析磁盘**

选择 **N** 可配置 `Pool Name`。输入所需的名称，然后选择 **<OK>** 确定名称，或选择 **<Cancel>** 返回主菜单来采用默认名称。

![请求池名称的菜单。](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-zfs-pool-name.png)

**图 26. 池名称**

选择 **S** 设置交换空间的大小。输入所需的交换分区大小，然后选择 **<OK>** 确定，或选择 **<Cancel>** 返回主菜单并使用默认值。

![请求交换内存大小的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-zfs-swap-amount.png)

**图 27. 交换大小**

若所有选项设置为所需值，选择菜单顶部的选项 **>>> Install**。安装程序将提供最后一次取消的机会，确认所选驱动器的内容将被销毁以创建 ZFS 池。

![指示用户数据将丢失的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-zfs-warning.png)

**图 28. 最后机会**

如果启用了 GELI 磁盘加密，安装程序将两次提示输入用于加密磁盘的密码短语。然后将开始初始化加密。

![请求加密设备密码的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-zfs-geli_password.png)

**图 29. 磁盘加密密码**

![显示加密初始化的菜单。](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-zfs-init-encription.png)

**图 30. 初始化加密**

安装过程将正常进行。要继续安装，请访问[获取发行版文件](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-fetching-distribution)。

## 2.6.5. Shell 模式分区

在进行高级安装时，bsdinstall 的分区菜单可能无法提供所需的灵活性。高级用户可以从分区菜单中选择 **Shell** 选项，以手动对驱动器进行分区，创建文件系统，填写 `/tmp/bsdinstall_etc/fstab`，并在 `/mnt` 下挂载文件系统。在完成后，输入 `exit` 可返回 bsdinstall 继续安装。
