# 2.8.账户、时区、服务和安全

## 2.8.1. 设置 `root` 密码

首先，必须设置 `root` 密码。在输入密码时，屏幕上不会回显正在输入的字符。为防止输入错误，密码需要输入两次。

![请求输入 root 用户密码的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-post-root-passwd.png)

**图 34. 设置 `root` 密码**

## 2.8.2. 配置网络接口

接下来，将显示计算机上找到的网络接口列表。选择要配置的接口。

![显示不同网络接口供配置的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-configure-network-interface.png)

**图 35. 选择网络接口**

如果选择以太网接口，安装程序将跳转到菜单[选择 IPv4 网络](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-configure-net-ipv4)。如果选择无线网络接口，系统将扫描无线接入点：

![显示无线网络扫描的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-configure-wireless-scan.png)

**图 36. 扫描无线接入点**

无线网络通过服务集标识 (SSID) 进行识别；每个网络都有个简短、独特的名称。在扫描过程中会列出找到的 SSID，然后提供该网络的可用加密类型的概述。如果所需 SSID 未出现在列表中，可选择 **Rescan** 进行重新扫描。若所需网络仍未出现，请检查天线连接是否存在问题，或尝试将计算机移近接入点。每次更改后都应重新扫描。

![显示不同无线网络供连接的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-configure-wireless-accesspoints.png)

**图 37. 选择无线网络**

接下来，输入连接到选定无线网络的加密信息。强烈建议使用 WPA2 加密，而不是提供较少安全性的旧加密类型，如 WEP。若网络使用 WPA2，请输入密码，也称为预共享密钥 (PSK)。出于安全原因，输入框中输入的字符将以星号显示。

![请求输入无线网络密码的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-configure-wireless-wpa2setup.png)

**图 38. WPA2 设置**

接下来，选择是否在以太网或无线接口上配置 IPv4 地址：

![指示是否要为选定接口配置 IPv4 的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-configure-network-interface-ipv4.png)

**图 39. 选择 IPv4 网络**

有两种方法可配置 IPv4。DHCP 会自动正确配置网络接口，如果网络提供了 DHCP 服务器，则应使用。若没有 DHCP 服务器，则需要手动输入地址信息，采用静态配置。

>**注意**
>
>请不要乱输网络信息，因为这没用。若没有 DHCP 服务器，请从网络管理员或互联网服务提供商处获取[所需网络信息](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-collect-network-information)中列出的信息。

如果可用 DHCP 服务器，请在下一个菜单中选择 **Yes** 以自动配置网络接口。安装程序会暂停约一分钟，用于查找 DHCP 服务器，获取系统的地址信息。

![指示是否要为选定接口配置 DHCP 的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-configure-network-interface-ipv4-dhcp.png)

**图 40. 选择 IPv4 DHCP 配置**

如果没有 DHCP 服务器，请选择 **No** 并在此菜单中输入以下地址信息：

![请求配置 IPv4 网络的数据的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-configure-network-interface-ipv4-static.png)


**图 41.静态 IPv4 配置**

* `IP Address`——分配给这台计算机的 IPv4 地址。该地址必须是唯一的，不能被局域网上的其他设备使用。
* `Subnet Mask`——网络的子网掩码。
* `Default Router`——网络默认网关的 IP 地址。

接下来的界面将询问是否应为接口配置 IPv6。如果 IPv6 可用且需要，请选择 **Yes** 进行选择。

![指示是否要为选定接口配置 IPv6 的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-configure-network-interface-ipv6.png)

**图 42. 选择 IPv6 网络**

也有两种方法可配置 IPv6。无状态地址自动配置 (SLAAC) 将自动从本地路由器请求正确的配置信息。更多有关信息，请参阅 [rfc4862](http://tools.ietf.org/html/rfc4862)。静态配置需要手动输入网络信息。

若 IPv6 路由器可用，请在下个界面中选择 **Yes** 自动配置网络接口。安装程序会暂停约一分钟，用于查找路由器并获取系统的地址信息。

![指示是否要为选定接口配置 SLAAC 的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-configure-network-interface-slaac.png)

**图 43. 选择 IPv6 SLAAC 配置**

如果没有 IPv6 路由器，请选择 **No** 并在此菜单中输入以下地址信息：

![请求配置 IPv6 网络的数据的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-configure-network-interface-ipv6-static.png)

**图 44.静态 IPv6 配置**

* `IPv6 Address`——分配给这台计算机的 IPv6 地址。该地址必须是唯一的，不能被局域网上的其他设备使用。
* `Default Router`——网络默认网关的 IPv6 地址。

最后一个网络配置菜单用于配置域名系统 (DNS) 解析器，它将主机名转换为网络地址和反向转换。如果使用 DHCP/SLAAC 自动配置了网络接口，`Resolver Configuration` 值可能已经填写。否则，在 `Search` 字段中输入本地网络的域名。`DNS #1` 和 `DNS #2` 是 DNS 服务器的 IPv4/IPv6 地址。至少需要一个 DNS 服务器。

![请求配置网络 DNS 的数据的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-configure-network-ipv4-dns.png)

**图 45. DNS 配置**

在接口配置完成后，选择一个位于与 FreeBSD 正在安装的计算机相同区域的镜像站点。当镜像站靠近目标计算机时，可以更快地下载文件，从而减少安装时间。

>**技巧**
>
>选择 `ftp://download.freebsd.org (Main Site)` 将自动路由到最近的镜像。 

![请求选择网络镜像的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-netinstall-mirrorselect.png)

**图 46. 选择镜像**

## 2.8.3. 设置时区

接下来的菜单用于通过选择地理区域、国家/区域和时区来确定正确的本地时间。设置时区可以让系统自动纠正区域时间变化，例如夏令时，并正确执行其他与时区相关的功能。

下面的示例适用于位于西班牙欧洲大陆时区的机器。选择会根据地理位置而有所不同。

![请求时区区域的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-timezone-region.png)

**图 47. 选择区域**

使用方向键选择适当的区域，然后按 **回车键**。

![请求时区国家/地区的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-timezone-country.png)

**图 48. 选择国家/区域**

使用方向键选择适当的国家/区域并按 **回车键**。

![请求时区的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-timezone-zone.png)

**图 49. 选择时区**

使用方向键选择适当的时区并按 **回车键**。

![请求确认所选时区的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-timezone-confirm.png)

**图 50. 确认时区**

确认时区的缩写是否正确。

![请求系统日期的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-timezone-date.png)

**图 51. 选择日期**

使用方向键选择适当的日期，然后按 **Set Date**。还可以通过按 **Skip** 来跳过日期选择。

![请求系统时间的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-timezone-time.png)

**图 52. 选择时间**

使用方向键选择适当的时间，然后按 **Set Time**。还可以通过按 **Skip** 来跳过时间选择。

## 2.8.4. 启用服务

下个界面用于配置系统启动时将启动哪些系统服务。所有这些服务都是可选的。只启动系统功能所需的服务。

![显示可用不同服务的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-config-services.png)

**图 53. 选择要启用的附加服务**

以下是可以在此菜单中启用的服务摘要：

* `local_unbound`——启用本机 DNS unbound。请记住，这只是用于本机缓存转发解析器的配置。如果目标是为整个网络设置解析器，请安装 [dns/unbound](https://cgit.freebsd.org/ports/tree/dns/unbound/)。
* `sshd`——安全外壳（SSH）守护进程用于通过加密连接远程访问系统。应仅在允许系统远程登录时才启用此服务。
* `moused`——如果要在命令行系统控制台使用鼠标，请启用此服务。
* `ntpdate`——启用启动时的自动时钟同步。请注意，该程序的功能现在已在 [ntpd(8)](https://man.freebsd.org/cgi/man.cgi?query=ntpd&sektion=8&format=html) 守护进程中提供，且 [ntpdate(8)](https://man.freebsd.org/cgi/man.cgi?query=ntpdate&sektion=8&format=html) 工具将很快被弃用。
* `ntpd`——网络时间协议（NTP）守护进程，用于自动时钟同步。如果希望将系统时钟与远程时间服务器或池同步，请启用此服务。
* `powerd`——系统电源控制实用程序，用于电源控制和节能。
* `dumpdev`——崩溃转储在调试系统问题时非常有用，因此建议用户启用它们。

## 2.8.5. 启用安全加固选项

下个菜单用于配置要启用的安全选项。所有这些选项都是可选的，但建议使用。

![显示不同安全加固选项的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-hardening.png)

**图 54. 选择安全加固选项**

以下是可以在此菜单中启用的选项摘要：

* `hide_uids`——隐藏以其他用户（UID）身份运行的进程。防止无权限用户查看其他用户正在运行的进程。
* `hide_gids`——隐藏以其他组（GID）身份运行的进程。防止无权限用户查看其他组正在运行的进程。
* `hide_jail`——隐藏在 jail 中运行的进程。防止无权限用户查看在 jail 内部运行的进程。
* `read_msgbuf`——禁止无权限用户读取内核信息缓冲区。防止无权限用户使用 [dmesg(8)](https://man.freebsd.org/cgi/man.cgi?query=dmesg&sektion=8&format=html) 查看内核日志缓冲区中的信息。
* `proc_debug`——禁止无权限用户使用进程调试功能。禁用各种无权限的进程间调试服务，包括某些 procfs 功能、`ptrace()` 和 `ktrace()`。请注意，这也会阻止使用诸如 [lldb(1)](https://man.freebsd.org/cgi/man.cgi?query=lldb&sektion=1&format=html)、[truss(1)](https://man.freebsd.org/cgi/man.cgi?query=truss&sektion=1&format=html) 和 [procstat(1)](https://man.freebsd.org/cgi/man.cgi?query=procstat&sektion=1&format=html) 的调试工具，以及某些脚本语言（如 PHP）中的一些内置调试功能。
* `random_pid`——随机化进程的 PID。
* `clear_tmp`——在系统启动时清理 `/tmp` 目录。
* `disable_syslogd`——禁用打开 syslogd 网络套接字。在默认情况下，FreeBSD 以安全的方式运行 syslogd——使用 `-s`。这防止守护进程监听端口 514 上的传入 UDP 请求。启用此选项后，syslogd 将以 `-ss` 运行，从而阻止 syslogd 打开任何端口。有关更多信息，请参见 [syslogd(8)](https://man.freebsd.org/cgi/man.cgi?query=syslogd&sektion=8&format=html)。
* `disable_sendmail`——禁用 sendmail 邮件传输代理。
* `secure_console`——使命令提示符在进入单用户模式时请求 `root` 密码。
* `disable_ddtrace`——DTrace 可以以影响运行内核的模式运行。除非明确启用，否则不允许使用破坏性操作。在使用 DTrace 时，请使用 `-w` 来启用此选项。有关更多信息，请参见 [dtrace(1)](https://man.freebsd.org/cgi/man.cgi?query=dtrace&sektion=1&format=html)。
* `enable_aslr`——启用地址布局随机化。有关地址布局随机化的更多信息，请参阅[维基百科文章](https://en.wikipedia.org/wiki/Address_space_layout_randomization)。

## 2.8.6. 添加用户

下个界面提示，要创建至少一个用户账户。建议使用用户账户而不要以 `root` 身份登录系统。在以 `root` 身份登录时，几乎没有限制和保护措施。以普通用户身份登录更安全。

选择 **Yes** 来添加新用户。

![请求是否要向系统添加用户的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-adduser1.png)

**图 55. 添加用户账户**

按照提示输入用户账户的所需信息。示例中所示[输入用户信息](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-add-user2)创建 `asample` 用户账户。

![请求新用户不同信息的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-adduser2.png)

**图 56. 输入用户信息**

以下是要输入的信息摘要：

* `Username`——用户登录时输入的名称。常见的约定是使用名字的首字母与姓氏组合，只要每个用户名在系统中是唯一的。用户名区分大小写，不应包含空格。
* `Full name`——用户的全名。可以包含空格，并作为用户账户的概述。
* `Uid`——用户 ID。通常留空，以便系统自动分配一个值。
* `Login group`——用户的组。通常留空以选用默认值。
* `Invite user into other groups?`——用户将作为成员加入的附加组。如果用户需要管理权限，请在此处输入 `wheel`。
* `Login class`——通常留空以选择默认值。
* `Shell`——输入所列值之一以设置用户的交互式 shell。有关 shell 的更多信息，请参见 [Shell](https://docs.freebsd.org/en/books/handbook/basics/#shells)。
* `Home directory`——用户的主目录。默认值通常是正确的。
* `Home directory permissions`——用户主目录的权限。默认值通常是正确的。
* `Use password-based authentication?`——通常选择 `yes`，以便在登录时提示用户输入密码。
* `Use an empty password?`——通常选择 `no`，因为空/空白密码不安全。
* `Use a random password?`——通常选择 `no`，以便用户在下一个提示中可以设置自己的密码。
* `Enter password`——此用户的密码。输入的字符不会在界面上显示。
* `Enter password again`——必须再次输入密码以进行验证。
* `Lock out the account after creation?`——通常选择 `no`，以便用户可以登录。

输入所有详细信息后，将显示摘要以供检查。如果发现错误，输入 `no` 以进行更正。一切正确后，输入 `yes` 创建新用户。

![显示新用户信息并请求确认是否正确的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-adduser3.png)

**图 57. 退出用户和组管理**

如果还有更多用户要添加，回答 `Add another user?` 的问题为 `yes`。输入 `no` 可结束添加用户并继续安装。

有关添加用户和用户管理的更多信息，请参见[用户和基本账户管理](https://docs.freebsd.org/en/books/handbook/basics/#users-synopsis)。

## 2.8.7. 最终配置

在所有内容安装和配置完成后，将提供最后一次修改设置的机会。

![显示在完成安装前进行的不同操作的菜单。例如：添加用户](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-finalconfiguration.png)

**图 58. 最终配置**

使用此菜单进行任何更改或进行额外配置，然后完成安装。

* `Add User`—— [添加用户](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-addusers)中概述。
* `Root Password`——在[设置 `root` 密码](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-post-root)中概述。
* `Hostname`——在[设置主机名](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-hostname)中概述。
* `Network`——在[配置网络接口](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-config-network-dev)中概述。
* `Services`——在[启用服务](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-sysconf)中概述。
* `System Hardening`——在[启用安全加固选项](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-hardening)中概述。
* `Time Zone`——在[设置时区](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-timezone)中概述。
* `Handbook`——下载、安装 FreeBSD 手册。

配置完成后，选择 **Exit**。

![显示安装已完成的菜单，并询问是否要打开 shell 进行手动更改](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-final-modification-shell.png)

**图 59. 手动配置**

bsdinstall 会提示需要在重启新系统之前进行的任何额外配置。选择 **Yes** 以退出到新系统中的 shell，或选择 **No** 以继续安装的最后一步。

![显示安装已完成并询问是否重启系统或访问 Live CD 的菜单](https://docs.freebsd.org/images/books/handbook/bsdinstall/bsdinstall-mainexit.png)

**图 60. 完成安装**

如果需要进一步的配置或特殊设置，选择 **Live CD** 以将安装媒体启动为 Live CD 模式。

如果安装完成，选择 **Reboot** 以重启计算机，启动新的 FreeBSD 系统。不要忘记移除 FreeBSD 安装媒体，否则计算机可能会再次从中启动。

当 FreeBSD 启动时，会显示信息信息。系统启动完成后，将显示登录提示。在 `login:` 提示符下，输入安装过程中添加的用户名。避免以 `root` 身份登录。有关如何在需要管理访问时成为超级用户的说明，请参见[超级用户账户](https://docs.freebsd.org/en/books/handbook/basics/#users-superuser)。

在启动过程中出现的信息可以通过按 **Scroll-Lock** 来打开回滚缓冲区进行查看。可以使用 **PgUp**、**PgDn** 和方向键向上滚动查看信息。完成后，再次按 **Scroll-Lock** 解锁显示并返回控制台。要在系统运行一段时间后查看这些信息，可以从命令提示符下输入 `less /var/run/dmesg.boot`。查看后按 **q** 返回命令行。

如果在[选择要启用的附加服务](https://docs.freebsd.org/en/books/handbook/bsdinstall/#bsdinstall-config-serv)中启用了 sshd，则第一次启动可能会稍慢，因为系统正在生成 SSH 主机密钥。后续启动会更快。然后将显示密钥的指纹，如以下示例所示：

```sh
Generating public/private rsa1 key pair.
Your identification has been saved in /etc/ssh/ssh_host_key.
Your public key has been saved in /etc/ssh/ssh_host_key.pub.
The key fingerprint is:
10:a0:f5:af:93:ae:a3:1a:b2:bb:3c:35:d9:5a:b3:f3 root@machine3.example.com
The key's randomart image is:
+--[RSA1 1024]----+
|    o..          |
|   o . .         |
|  .   o          |
|       o         |
|    o   S        |
|   + + o         |
|o . + *          |
|o+ ..+ .         |
|==o..o+E         |
+-----------------+
Generating public/private dsa key pair.
Your identification has been saved in /etc/ssh/ssh_host_dsa_key.
Your public key has been saved in /etc/ssh/ssh_host_dsa_key.pub.
The key fingerprint is:
7e:1c:ce:dc:8a:3a:18:13:5b:34:b5:cf:d9:d1:47:b2 root@machine3.example.com
The key's randomart image is:
+--[ DSA 1024]----+
|       ..     . .|
|      o  .   . + |
|     . ..   . E .|
|    . .  o o . . |
|     +  S = .    |
|    +  . = o     |
|     +  . * .    |
|    . .  o .     |
|      .o. .      |
+-----------------+
Starting sshd.
```

有关指纹和 SSH 的更多信息，请参见 [OpenSSH](https://docs.freebsd.org/en/books/handbook/security/#openssh)。

FreeBSD 默认不安装图形环境。有关安装和配置图形窗口管理器的更多信息，请参见 [X Window 系统](https://docs.freebsd.org/en/books/handbook/x11/#x11)。

正确关闭 FreeBSD 计算机有助于保护数据和硬件免受损坏。*在系统没有正确关闭之前，请勿关闭电源！* 如果用户是 `wheel` 组的成员，可以在命令行输入 `su`，再输入 `root` 密码以成为超级用户。然后，输入 `shutdown -p now`，系统可安全关闭，在硬件支持的情况下回自动关机。
