# 2.9.故障排除

本节涉及基本的安装故障排除，例如常见问题。

请查看 [FreeBSD 发行信息](https://www.freebsd.org/releases/)页面上列出的硬件注意事项，确保硬件受支持。

>**注意**
>
>某些安装问题可以通过更新各种硬件组件的固件来避免或缓解——最明显的是主板。主板固件通常被称为 BIOS。大多数主板和计算机制造商都有一个用于升级和升级信息的网站。
>
>制造商通常建议非必要不升级主板 BIOS，应仅在出现关键更新等情况下才考虑升级。升级过程 *可能* 出现问题，造成 BIOS 不完整，导致计算机无法正常工作。

如果系统在启动时探测硬件时卡住，或在安装过程中表现异常，ACPI 可能是罪魁祸首。在 i386 和 amd64 平台上，FreeBSD 在引导期间检测到系统 ACPI 服务时，会大量使用它来帮助系统配置。不幸的是，ACPI 驱动程序以及系统主板和 BIOS 固件中仍然存在一些错误。可通过在第三阶段引导加载程序中设置 hint `hint.acpi.0.disabled` 来禁用 ACPI：

```sh
set hint.acpi.0.disabled="1"
```

每次系统启动时，这个设置都会被重置，因此需要将 `hint.acpi.0.disabled="1"` 添加到文件 `/boot/loader.conf`。有关引导加载程序的更多信息，请参见 [“概要”](https://docs.freebsd.org/en/books/handbook/boot/#boot-synopsis)。
