# 20.10.内存盘

除了物理磁盘，FreeBSD 还支持创建和使用内存磁盘。内存磁盘的一个可能用途是访问 ISO 文件系统的内容，而无需先将其烧录到 CD 或 DVD 上，然后挂载 CD/DVD 媒体。

在 FreeBSD 中，md(4)驱动程序用于支持内存磁盘。通用内核包括此驱动程序。使用定制内核配置文件时，请确保包含以下行：

```
device md
```

### 20.10.1. 附加和分离现有镜像

要挂载现有的文件系统镜像，请使用 mdconfig 指定 ISO 文件的名称和一个空闲单元编号。然后，引用该单元编号将其挂载到现有挂载点上。挂载后，ISO 中的文件将出现在挂载点中。例如，将 diskimage.iso 附加到内存设备/dev/md0，然后将该内存设备挂载到/mnt：

```
# mdconfig -f diskimage.iso -u 0
# mount -t cd9660 /dev/md0 /mnt
```

注意，-t cd9660 用于挂载 ISO 格式。如果未指定单元号，则 mdconfig 将自动分配一个未使用的内存设备，并输出分配的单元名称，例如 md4。有关此命令及其选项的更多详细信息，请参阅 mdconfig(8)。

当内存磁盘不再使用时，应将其资源释放回系统。首先卸载文件系统，然后使用 mdconfig 分离磁盘并释放其资源。继续本例：

```
# umount /mnt
# mdconfig -d -u 0
```

要确定系统上仍附加有任何内存磁盘，请键入 mdconfig -l。

### 创建文件或内存支持的内存磁盘

FreeBSD 还支持内存磁盘，其中要使用的存储器来自硬盘或内存区域。第一种方法通常称为文件支持的文件系统，第二种方法称为内存支持的文件系统。这两种类型都可以使用 mdconfig 创建。

要创建新的内存支持的文件系统，请指定 swap 的类型和要创建的内存磁盘的大小。然后，像往常一样格式化内存磁盘为文件系统并挂载。此示例在单元 1 上创建了一个 5M 内存磁盘。然后将该内存磁盘格式化为 UFS 文件系统，然后挂载：

```
# mdconfig -a -t swap -s 5m -u 1
# newfs -U md1
/dev/md1: 5.0MB (10240 sectors) block size 16384, fragment size 2048
        using 4 cylinder groups of 1.27MB, 81 blks, 192 inodes.
        with soft updates
super-block backups (for fsck -b #) at:
 160, 2752, 5344, 7936
# mount /dev/md1 /mnt
# df /mnt
Filesystem 1K-blocks Used Avail Capacity  Mounted on
/dev/md1        4718    4  4338     0%    /mnt
```

创建一个新的文件支持的内存磁盘，首先分配一个要使用的磁盘区域。此示例创建一个名为 newimage 的空白 5MB 文件：

```
# dd if=/dev/zero of=newimage bs=1k count=5k
5120+0 records in
5120+0 records out
```

接下来，将该文件附加到内存磁盘，为内存磁盘命名并使用 UFS 文件系统格式化它，挂载内存磁盘，并验证文件支持磁盘的大小：

```
# mdconfig -f newimage -u 0
# bsdlabel -w md0 auto
# newfs -U md0a
/dev/md0a: 5.0MB (10224 sectors) block size 16384, fragment size 2048
        using 4 cylinder groups of 1.25MB, 80 blks, 192 inodes.
super-block backups (for fsck -b #) at:
 160, 2720, 5280, 7840
# mount /dev/md0a /mnt
# df /mnt
Filesystem 1K-blocks Used Avail Capacity  Mounted on
/dev/md0a       4710    4  4330     0%    /mnt
```

使用多个命令来使用 mdconfig 创建文件或内存支持的文件系统。FreeBSD 也附带 mdmfs，它会自动配置内存磁盘、使用 UFS 文件系统对其进行格式化，并挂载它。例如，在使用 dd 创建 newimage 后，此命令相当于运行上述显示的 bsdlabel 、 newfs 和 mount 命令：

```
# mdmfs -F newimage -s 5m md0 /mnt
```

使用此命令可以创建一个基于内存的新内存磁盘而不是 mdmfs。

```
# mdmfs -s 5m md1 /mnt
```

如果未指定单元号，mdmfs 将自动选择未使用的内存设备。有关 mdmfs 的详细信息，请参阅 mdmfs(8)。
