# 20.11.文件系统快照

FreeBSD 提供了与 Soft Updates 配合使用的功能：文件系统快照。

UFS 快照允许用户创建指定文件系统的镜像，并将其视为文件。如果你使用 Z 文件系统（ZFS），请参阅管理快照以了解如何使用快照。

快照文件必须在执行操作的文件系统中创建，用户每个文件系统最多可以创建 20 个快照。活动快照记录在超级块中，因此它们在卸载、重新挂载以及系统重启时是持久的。当不再需要快照时，可以使用 rm(1)删除它们。尽管可以以任意顺序删除快照，但可能无法获得所有已释放块的使用空间，因为另一个快照可能会索取某些已释放的块。

mksnap_ffs(8)在快照文件初始创建后设置不可更改的 snapshot 文件标志。由于允许快照文件被删除，unlink(1)对其进行了例外处理。

快照是使用 mount(8)创建的。要将 /var 的快照放入文件 /var/snapshot/snap 中，请使用以下命令：

```
# mount -u -o snapshot /var/snapshot/snap /var
```

或者，使用 mksnap_ffs(8)创建快照：

```
# mksnap_ffs /var /var/snapshot/snap
```

人们可以使用 find(1)在文件系统（例如 /var）上找到快照文件：

```
# find /var -flags snapshot
```

创建快照后，它有几个用途：

* 一些管理员会将快照文件用于备份目的，因为快照可以转移到 CD 或磁带上。
* 可以在快照上运行文件系统完整性检查器 fsck(8)。假设文件系统在挂载时是干净的，这应始终提供干净和不变的结果。
* 运行 dump(8) 在快照上会生成一个与文件系统和快照时间戳一致的转储文件。dump(8) 还可以在一个命令中拍摄快照、创建转储镜像，然后移除快照，使用 -L。
* 快照可以挂载为文件系统的冻结镜像。要挂载(8) 快照 /var/snapshot/snap，请运行：

  ```
  # mdconfig -a -t vnode -o readonly -f /var/snapshot/snap -u 4
  # mount -r /dev/md4 /mnt
  ```

冻结的 /var 现在通过 /mnt 可用。一切将处于快照创建时的相同状态，唯一的例外是任何早期的快照将显示为零长度文件。要卸载快照，请使用：

```
# umount /mnt
# mdconfig -d -u 4
```

关于 softupdates 和文件系统快照的更多信息，包括技术论文，请访问马歇尔·柯克·麦库西克的网站：http://www.mckusick.com/。
