# 20.12.磁盘配额

磁盘配额可用于限制用户或组成员在每个文件系统基础上分配的磁盘空间或文件数量的数量。这可以阻止一个用户或用户组占用所有可用磁盘空间。

本节介绍如何为 UFS 文件系统配置磁盘配额。要在 ZFS 文件系统上配置配额，请参考数据集、用户和组配额

### 20.12.1. 启用磁盘配额

要确定 FreeBSD 内核是否支持磁盘配额：

```
% sysctl kern.features.ufs_quota
kern.features.ufs_quota: 1
```

在这个例子中，1 表示配额支持。如果值改为 0，请将以下行添加到定制内核配置文件中，并按照《配置 FreeBSD 内核》中的说明重建内核：

```
options QUOTA
```

接下来，在 /etc/rc.conf 中启用磁盘配额：

```
quota_enable="YES"
```

通常在启动时，每个文件系统的配额完整性都会通过 quotacheck(8) 进行检查。这个程序确保配额数据库中的数据正确反映文件系统上的数据。这是一个耗时的过程，会显著影响系统启动时间。要跳过此步骤，请将此变量添加到 /etc/rc.conf 中：

```
check_quotas="NO"
```

最后，编辑 /etc/fstab 以启用按文件系统基础的磁盘配额。要在文件系统上启用按用户配额，请在 /etc/fstab 条目的选项字段中添加 userquota 以启用配额。例如：

```
/dev/da1s2g   /home    ufs rw,userquota 1 2
```

要启用组配额，请使用 groupquota 代替。要同时启用用户配额和组配额，请用逗号分隔选项：

```
/dev/da1s2g    /home    ufs rw,userquota,groupquota 1 2
```

默认情况下，配额文件存储在文件系统的根目录中，名称分别为 quota.user 和 quota.group。有关更多信息，请参阅 fstab(5)。不建议指定配额文件的替代位置。

配置完成后，重启系统，/etc/rc 将自动运行适当的命令，为 /etc/fstab 中启用的所有配额创建初始配额文件。

在正常操作过程中，通常不需要手动运行 quotacheck(8)，quotaon(8) 或 quotaoff(8)。但是，建议阅读这些手册页面，以熟悉它们的操作。

### 20.12.2. 设置配额限制

验证启用了配额，请运行：

```
# quota -v
```

每个启用了配额的文件系统的磁盘使用情况和当前配额限制应有一行摘要。

系统现在已准备好使用 edquota 分配配额限制。

为用户或组分配的磁盘空间限额和文件数量限额有多种选择。限额可以基于磁盘空间（块限额）、文件数量（索引节点限额）或两者结合来设定。每个限额进一步分为两类：硬限额和软限额。

不能超过硬限额。若用户达到硬限额，该用户在该文件系统上将无法再进行进一步的分配。例如，如果用户在文件系统上有 500 千字节的硬限额，目前正在使用 490 千字节，那么用户只能再分配 10 千字节。尝试再分配 11 千字节将失败。

软限额可以在有限的一段时间内超出，称为宽限期，默认为一周。如果用户超出其限额的时间超过宽限期，软限额将变为硬限额，不再能让进一步分配。当用户再次降至软限额以下时，宽限期将被重置。

在下面的例子中，正在编辑 test 账户的配额。当调用 edquota 时，将打开由 EDITOR 指定的编辑器，以编辑配额限制。默认编辑器设置为 vi。

```
# edquota -u test
Quotas for user test:
/usr: kbytes in use: 65, limits (soft = 50, hard = 75)
        inodes in use: 7, limits (soft = 50, hard = 60)
/usr/var: kbytes in use: 0, limits (soft = 50, hard = 75)
        inodes in use: 0, limits (soft = 50, hard = 60)
```

通常每个启用配额的文件系统有两行。一行代表块限制，另一行代表 inode 限制。更改值以修改配额限制。例如，要将/usr 的块限制提高到软限制 500 和硬限制 600，请按以下行中的值更改：

```
/usr: kbytes in use: 65, limits (soft = 500, hard = 600)
```

新的配额限制在退出编辑器时生效。

有时限定一系列用户的配额限制是可取的。首先，将所需的配额限制分配给一个用户。然后，使用 -p 来将该配额复制到指定范围的用户 ID（UID）。以下命令将为 UID 10,000 到 19,999 复制这些配额限制：

```
# edquota -p test 10000-19999
```

欲知详情，请参阅 edquota(8)。

### 20.12.3. 检查配额限制和磁盘使用情况

要检查单个用户或组的配额和磁盘使用情况，请使用 quota(1)命令。用户只能查看自己的配额以及其所属组的配额。只有超级用户可以查看所有用户和组的配额。要获取启用配额的文件系统的所有配额和磁盘使用情况摘要，请使用 repquota(8)命令。

通常，如果用户在某个文件系统上没有使用任何磁盘空间，则该文件系统不会显示在 quota 的输出中，即使用户对该文件系统有配额限制。使用 -v 命令可以显示这些文件系统。以下是对具有两个文件系统配额限制的用户的 quota -v 的示例输出。

```
Disk quotas for user test (uid 1002):
     Filesystem  usage    quota   limit   grace   files   quota   limit   grace
           /usr      65*     50      75   5days       7      50      60
       /usr/var       0      50      75               0      50      60
```

在此示例中，用户目前超过了/usr 文件系统 50 kbytes 的软限制 15 kbytes，并且剩余 5 天的宽限期。星号 * 表示用户目前超过配额限制。

### 20.12.4. NFS 上的配额

配额由 NFS 服务器上的配额子系统强制执行。rpc.rquotad(8) 守护进程将配额信息提供给 NFS 客户端的 quota，能让这些机器上的用户查看其配额统计信息。

在 NFS 服务器上，通过在 /etc/inetd.conf 文件中删除此行中的 # 来启用 rpc.rquotad ：

```
rquotad/1      dgram rpc/udp wait root /usr/libexec/rpc.rquotad rpc.rquotad
```

 然后重启 inetd ：

```
# service inetd restart
```
