# 20.13.加密磁盘分区

FreeBSD 提供了很好的在线保护，防止未经授权的数据访问。文件权限和强制访问控制(MAC)有助于防止未经授权的用户在操作系统活动和计算机开启时访问数据。然而，如果攻击者可以物理访问计算机，并将计算机的硬盘移动到另一个系统进行复制和分析，那么操作系统强制执行的权限就不相关了。

无论攻击者如何获得硬盘或关机的计算机，内建在 FreeBSD 中的基于 GEOM 的加密子系统能够保护计算机文件系统中的数据，即使是对拥有大量资源的高度动机的攻击者也是如此。与加密单个文件的方法不同，内置的 gbde 和 geli 实用程序可用于透明地加密整个文件系统。清文从不接触硬盘的盘片。

本章演示如何在 FreeBSD 上创建加密文件系统。首先演示使用 gbde 的过程，然后演示相同示例使用 geli。

### 20.13.1. 使用 gbde 进行磁盘加密

gbde（4）设施的目标是为攻击者提供强大的挑战，以防止其访问冷存储设备的内容。但是，如果计算机在运行时受到损害并且存储设备处于活动状态，或者攻击者可以访问有效的密码短语，则不会为存储设备的内容提供任何保护。因此，在系统运行时提供物理安全性并保护加密机制使用的密码短语至关重要。

该设施提供多个屏障，以保护存储在每个磁盘扇区中的数据。它使用 128 位 AES 加密方式对磁盘扇区的内容进行加密。磁盘上的每个扇区都使用不同的 AES 密钥进行加密。有关密码学设计的更多信息，包括如何从用户提供的密码短语派生扇区密钥，请参阅 gbde（4）。

FreeBSD 为 gbde 提供了一个内核模块，可以使用以下命令加载：

```
# kldload geom_bde
```

如果使用自定义内核配置文件，请确保它包含以下行：

`options GEOM_BDE`

以下示例演示了向系统添加一个新硬盘，该硬盘将容纳一个加密分区，该分区将被挂载为 /private。

过程：使用 gbde 加密分区

1. 将新硬盘安装到系统中，按照《添加磁盘》中的说明操作。在本例中，已添加新硬盘分区作为 /dev/ad4s1c，并且 /dev/ad0s1* 表示现有标准 FreeBSD 分区。

    ```
    # ls /dev/ad*
    /dev/ad0        /dev/ad0s1b     /dev/ad0s1e     /dev/ad4s1
    /dev/ad0s1      /dev/ad0s1c     /dev/ad0s1f     /dev/ad4s1c
    /dev/ad0s1a     /dev/ad0s1d     /dev/ad4
    ```
2. 创建一个目录来存放 gbde 锁文件

    ```
    # mkdir /etc/gbde
    ```

    gbde 锁文件包含 gbde 访问加密分区所需的信息。没有锁文件的访问，gbde 将无法解密加密分区中的数据，除非进行不受软件支持的重大手动干预。每个加密分区使用单独的锁文件。
3. 初始化 gbde 分区 gbde 分区必须在使用之前初始化。此初始化只需执行一次。此命令将打开默认编辑器，以便在模板中设置各种配置选项。对于 UFS 文件系统，请将 sector_size 设置为 2048：

    ```
    # gbde init /dev/ad4s1c -i -L /etc/gbde/ad4s1c.lock
    #
    # Sector size is the smallest unit of data which can be read or written.
    # Making it too small decreases performance and decreases available space.
    # Making it too large may prevent filesystems from working.  512 is the
    # minimum and always safe.  For UFS, use the fragment size
    #
    sector_size	=	2048
    [...]
    ```

    编辑保存后，用户将被要求两次输入用于保护数据的密码。密码两次输入必须相同。gbde 保护数据的能力完全取决于密码的质量。有关如何选择既安全又容易记忆的安全密码的提示，请参阅 http://world.std.com/~reinhold/diceware.htm。

    此初始化为 gbde 分区创建一个锁定文件。在本例中，它存储为/etc/gbde/ad4s1c.lock。锁定文件必须以“.lock”结尾，以便/etc/rc.d/gbde 启动脚本能够正确检测到。

    |  | 锁定文件必须与加密分区的内容一起备份。没有锁定文件，合法的所有者将无法访问加密分区上的数据。|
    | -- | ---------------------------------------------------------------------------------------------- |
4. 将加密分区附加到内核

    ```
    # gbde attach /dev/ad4s1c -l /etc/gbde/ad4s1c.lock
    ```

    此命令将提示输入在初始化加密分区期间选择的密码。新的加密设备将显示在/dev，如/dev/device_name.bde：

    ```
    # ls /dev/ad*
    /dev/ad0        /dev/ad0s1b     /dev/ad0s1e     /dev/ad4s1
    /dev/ad0s1      /dev/ad0s1c     /dev/ad0s1f     /dev/ad4s1c
    /dev/ad0s1a     /dev/ad0s1d     /dev/ad4        /dev/ad4s1c.bde
    ```
5. 加密设备已附加到内核之后，请在设备上创建文件系统。此示例创建了一个启用软更新的 UFS 文件系统。确保指定具有*.bde 扩展名的分区：

    ```
    # newfs -U /dev/ad4s1c.bde
    ```
6. 挂载加密分区创建挂载点并挂载加密文件系统：

    ```
    # mkdir /private
    # mount /dev/ad4s1c.bde /private
    ```
7. 验证加密文件系统是否可用加密文件系统现在应可见且可供使用：

    ```
    % df -H
    Filesystem        Size   Used  Avail Capacity  Mounted on
    /dev/ad0s1a      1037M    72M   883M     8%    /
    /devfs            1.0K   1.0K     0B   100%    /dev
    /dev/ad0s1f       8.1G    55K   7.5G     0%    /home
    /dev/ad0s1e      1037M   1.1M   953M     0%    /tmp
    /dev/ad0s1d       6.1G   1.9G   3.7G    35%    /usr
    /dev/ad4s1c.bde   150G   4.1K   138G     0%    /private
    ```

每次启动后，必须手动重新附加加密文件系统到内核，检查错误，并挂载文件系统，然后才能使用文件系统。要配置这些步骤，请将以下行添加到 /etc/rc.conf：

```
gbde_autoattach_all="YES"
gbde_devices="ad4s1c"
gbde_lockdir="/etc/gbde"
```

这要求在启动时在控制台输入密码短语。输入正确的密码短语后，加密分区将自动挂载。rc.conf(5) 中列出了其他 gbde 启动选项。

```
# gbde detach /dev/ad4s1c
```

### 20.13.2. 使用 geli 进行磁盘加密

可以使用 geli 来使用另一个替代的加密 GEOM 类。此控制实用程序添加了一些功能，并使用了不同的加密工作方案。它提供以下功能：

* 利用 crypto(9) 框架，并在可用时自动使用加密硬件。
* 支持多种加密算法，如 AES-XTS、AES-CBC 和 Camellia-CBCAES。
* 允许对根分区进行加密。访问加密的根分区所使用的口令将在系统启动时请求。
* 允许使用两个独立的密钥。
* 它速度快，因为它执行简单的扇区到扇区加密。
* 允许备份和恢复主密钥。如果用户销毁了他们的密钥，仍然可以通过从备份中恢复密钥来访问数据。
* 允许使用随机的一次性密钥连接磁盘，对于交换分区和临时文件系统非常有用。

在 geli(8) 中可以找到更多功能和使用示例。

以下示例说明了如何生成一个密钥文件，该文件将作为挂载在/private 下的加密提供程序的主密钥的一部分。密钥文件将提供用于加密主密钥的一些随机数据。主密钥也将受到密码短语的保护。提供程序的扇区大小将为 4kB。该示例说明了如何连接到 geli 提供程序，在上面创建文件系统，挂载它，处理它，最后如何将其拆卸。

过程：使用 geli 加密分区

1. 加载 geli 支持 geli 支持 geli 的加载内核模块可用。要配置系统以在启动时自动加载模块，请将以下行添加到/boot/loader.conf：

    ```
    geom_eli_load="YES"
    ```

    现在加载内核模块：

    ```
    # kldload geom_eli
    ```

    对于定制内核，请确保内核配置文件包含以下行：

    ```
    options GEOM_ELI
    device crypto
    ```
2. 生成主密钥以下命令生成一个将用于加密所有数据的主密钥。此密钥永远不会更改。而不是直接使用它，它会使用一个或多个用户密钥进行加密。用户密钥由来自文件（/root/da2.key）和/或密码短语的可选随机字节组合而成。在本例中，密钥文件的数据来源是/dev/random。此命令还将提供程序（/dev/da2.eli）的扇区大小配置为 4kB，以提升性能。

    ```
    # dd if=/dev/random of=/root/da2.key bs=64 count=1
    # geli init -K /root/da2.key -s 4096 /dev/da2
    Enter new passphrase:
    Reenter new passphrase:
    ```

    可以选择使用密码、密钥文件中的任一种方法来保护主密钥，两者中的任何一种方法都可以单独使用。

    如果密钥文件使用"-"，则使用标准输入。例如，此命令生成三个密钥文件：

    ```
    # cat keyfile1 keyfile2 keyfile3 | geli init -K - /dev/da2
    ```
3. 将生成的密钥附加到提供者。要附加提供者，请指定密钥文件、磁盘名称和密码：

    ```
    # geli attach -k /root/da2.key /dev/da2
    Enter passphrase:
    ```

    创建一个带有 .eli 扩展名的新设备：

    ```
    # ls /dev/da2*
    /dev/da2  /dev/da2.eli
    ```
4. 接下来创建新的文件系统，使用 UFS 文件系统格式化设备，并将其挂载到现有的挂载点上：

    ```
    # dd if=/dev/random of=/dev/da2.eli bs=1m
    # newfs /dev/da2.eli
    # mount /dev/da2.eli /private
    ```

    现在应该可以使用加密文件系统了：

    ```
    # df -H
    Filesystem     Size   Used  Avail Capacity  Mounted on
    /dev/ad0s1a    248M    89M   139M    38%    /
    /devfs         1.0K   1.0K     0B   100%    /dev
    /dev/ad0s1f    7.7G   2.3G   4.9G    32%    /usr
    /dev/ad0s1d    989M   1.5M   909M     0%    /tmp
    /dev/ad0s1e    3.9G   1.3G   2.3G    35%    /var
    /dev/da2.eli   150G   4.1K   138G     0%    /private
    ```

加密分区的工作完成之后，并且不再需要/private 分区，将设备置于冷藏状态是明智的做法，方法是卸载并从内核分离 geli 加密分区：

```
# umount /private
# geli detach da2.eli
```

提供了一个 rc.d 脚本，用于简化启动时 geli 加密设备的挂载。例如，将以下行添加到/etc/rc.conf：

```
geli_devices="da2"
geli_da2_flags="-k /root/da2.key"
```

这将配置/dev/da2 作为 geli 提供者，主密钥为/root/da2.key。系统将在系统关闭之前自动将提供者从内核分离。在启动过程中，脚本将提示输入密码，然后再附加提供者。在密码提示之前和之后，可能会显示其他内核消息。如果启动过程似乎停滞不前，请仔细查找其他消息中的密码提示。输入正确的密码后，提供者将被附加。然后文件系统通常由/etc/fstab 中的条目挂载。有关如何配置文件系统在启动时挂载的说明，请参阅“挂载和卸载文件系统”。
