# 20.14.加密交换分区

像加密磁盘分区一样，加密交换空间用于保护敏感信息。考虑一个处理密码的应用程序。只要这些密码保留在物理内存中，它们就不会被写入磁盘，并且在重启后将被清除。但是，如果 FreeBSD 开始交换内存页面以释放空间，密码可能会以未加密的形式写入磁盘。加密交换空间可以是这种情况的解决方案。

本部分演示如何使用 gbde（8）或 geli（8）加密配置加密的交换分区。假定/dev/ada0s1b 是交换分区。

### 20.14.1. 配置加密交换

交换分区默认情况下未加密，应在继续之前清除任何敏感数据。要使用随机垃圾覆盖当前交换分区，请执行以下命令：

```
# dd if=/dev/random of=/dev/ada0s1b bs=1m
```

使用 gbde(8) 加密交换分区，需在 /etc/fstab 的交换行后添加 .bde 后缀：

```
# Device		Mountpoint	FStype	Options		Dump	Pass#
/dev/ada0s1b.bde	none		swap	sw		0	0
```

若要改用 geli(8) 加密交换分区，请使用 .eli 后缀：

```
# Device		Mountpoint	FStype	Options		Dump	Pass#
/dev/ada0s1b.eli	none		swap	sw		0	0
```

默认情况下，geli(8) 使用 AES 算法，密钥长度为 128 位。通常情况下，这些默认设置已经足够。如果需要，可以在 /etc/fstab 的选项字段中修改这些默认设置。可能的标志包括：

 算法

用于确保加密数据未被篡改的数据完整性验证算法。有关受支持的算法列表，请参阅 geli(8)。

 算法

用于保护数据的加密算法。请参阅 geli(8) 以获取支持的算法列表。

 密钥长度

用于加密算法的密钥长度。请参阅 geli(8) 以获取每种加密算法支持的密钥长度。

 扇区大小

数据在加密之前被分成的块的大小。较大的扇区大小会提高性能，但会增加存储开销。建议的大小为 4096 字节。

此示例配置了一个使用 128 位密钥长度和 4 千字节扇区大小的 AES-XTS 算法的加密交换分区：

```
# Device		Mountpoint	FStype	Options				Dump	Pass#
/dev/ada0s1b.eli	none		swap	sw,ealgo=AES-XTS,keylen=128,sectorsize=4096	0	0
```

### 20.14.2. 加密交换验证

系统重启后，可以使用 swapinfo 来验证加密交换的正常运行。

如果正在使用 gbde(8)：

```
% swapinfo
Device          1K-blocks     Used    Avail Capacity
/dev/ada0s1b.bde   542720        0   542720     0
```

如果正在使用 geli(8)：

```
% swapinfo
Device          1K-blocks     Used    Avail Capacity
/dev/ada0s1b.eli   542720        0   542720     0
```
