# 20.2.添加磁盘

本节说明如何将新的 SATA 磁盘添加到当前仅有单个驱动器的计算机中。首先，关闭计算机，并根据计算机、控制器和驱动器制造商的说明安装驱动器。重启系统，然后进行 root。

检查 /var/run/dmesg.boot 以确保找到新磁盘。在这个示例中，新添加的 SATA 驱动器将显示为 ada1。

对于这个示例，将在新磁盘上创建一个单独的大分区。将使用 GPT 分区方案，而不是较旧且不太灵活的 MBR 方案。

|  | 如果要添加的磁盘不是空白的，则可以使用 gpart delete 删除旧的分区信息。有关详细信息，请参阅 gpart(8)。|
| -- | ------------------------------------------------------------------------------------------------------- |

分区方案已创建，然后添加了单个分区。为了改善在具有较大硬件块大小的新磁盘上的性能，分区将对齐到一兆字节的边界：

```
# gpart create -s GPT ada1
# gpart add -t freebsd-ufs -a 1M ada1
```

根据使用情况，可能需要多个较小的分区。查看 gpart(8) 以获取创建小于整个磁盘的分区的选项。

磁盘分区信息可使用 gpart show 查看：

```
% gpart show ada1
=>        34  1465146988  ada1  GPT  (699G)
          34        2014        - free -  (1.0M)
        2048  1465143296     1  freebsd-ufs  (699G)
  1465145344        1678        - free -  (839K)
```

在新磁盘的新分区上创建文件系统：

```
# newfs -U /dev/ada1p1
```

在原始磁盘的文件系统中创建一个空目录作为挂载点，用于挂载新磁盘：

```
# mkdir /newdisk
```

最后，在 /etc/fstab 中添加条目，以便新磁盘在启动时自动挂载：

```
/dev/ada1p1	/newdisk	ufs	rw	2	2
```

新磁盘可以手动挂载，无需重启系统：

```
# mount /newdisk
```
