# 20.3.调整和增加磁盘大小

磁盘的容量可以增加，而无需对已有数据进行任何更改。这在虚拟机中经常发生，当虚拟磁盘太小并被扩大时。有时，磁盘映像被写入 USB 存储设备，但未使用完整容量。在这里，我们说明了如何调整或扩展磁盘内容以利用增加的容量。

通过检查 /var/run/dmesg.boot 来确定要调整大小的磁盘的设备名称。在这个例子中，系统中只有一个 SATA 磁盘，因此该驱动器将显示为 ada0。

列出磁盘上的分区以查看当前配置：

```
# gpart show ada0
=>      34  83886013  ada0  GPT  (48G) [CORRUPT]
        34       128     1  freebsd-boot  (64k)
       162  79691648     2  freebsd-ufs  (38G)
  79691810   4194236     3  freebsd-swap  (2G)
  83886046         1        - free -  (512B)
```

```
# gpart recover ada0
ada0 recovered
```

现在磁盘上的额外空间可供新分区使用，或者可以扩展现有分区：

```
# gpart show ada0
=>       34  102399933  ada0  GPT  (48G)
         34        128     1  freebsd-boot  (64k)
        162   79691648     2  freebsd-ufs  (38G)
   79691810    4194236     3  freebsd-swap  (2G)
   83886046   18513921        - free -  (8.8G)
```

分区只能调整到相邻的空闲空间中。这里，磁盘上最后的分区是交换分区，但需要调整大小的是第二个分区。交换分区只包含临时数据，因此可以安全地卸载、删除，然后在调整第二个分区大小后重新创建第三个分区。

禁用交换分区：

```
# swapoff /dev/ada0p3
```

从磁盘 ada0 中删除第三个分区，由 -i 标志指定。

```
# gpart delete -i 3 ada0
ada0p3 deleted
# gpart show ada0
=>       34  102399933  ada0  GPT  (48G)
         34        128     1  freebsd-boot  (64k)
        162   79691648     2  freebsd-ufs  (38G)
   79691810   22708157        - free -  (10G)
```

```
# sysctl kern.geom.debugflags=16
```

调整分区大小，留出空间以重新创建所需大小的交换分区。要调整大小的分区由 -i 指定，新的所需大小由 -s 指定。可选地，可以使用 -a 控制分区的对齐方式。这仅修改分区的大小。分区中的文件系统将在单独的步骤中扩展。

```
# gpart resize -i 2 -s 47G -a 4k ada0
ada0p2 resized
# gpart show ada0
=>       34  102399933  ada0  GPT  (48G)
         34        128     1  freebsd-boot  (64k)
        162   98566144     2  freebsd-ufs  (47G)
   98566306    3833661        - free -  (1.8G)
```

重新创建交换分区并激活它。如果未使用 -s 指定大小，则使用所有剩余空间：

```
# gpart add -t freebsd-swap -a 4k ada0
ada0p3 added
# gpart show ada0
=>       34  102399933  ada0  GPT  (48G)
         34        128     1  freebsd-boot  (64k)
        162   98566144     2  freebsd-ufs  (47G)
   98566306    3833661     3  freebsd-swap  (1.8G)
# swapon /dev/ada0p3
```

扩展 UFS 文件系统以使用调整后分区的新容量：

```
# growfs /dev/ada0p2
Device is mounted read-write; resizing will result in temporary write suspension for /.
It's strongly recommended to make a backup before growing the file system.
OK to grow file system on /dev/ada0p2, mounted on /, from 38GB to 47GB? [Yes/No] Yes
super-block backups (for fsck -b #) at:
 80781312, 82063552, 83345792, 84628032, 85910272, 87192512, 88474752,
 89756992, 91039232, 92321472, 93603712, 94885952, 96168192, 97450432
```

如果文件系统是 ZFS，则通过运行 online 子命令和 -e 来触发调整大小：

```
# zpool online -e zroot /dev/ada0p2
```

现在，分区和其上的文件系统都已调整大小，以利用新的可用磁盘空间。
