# 20.4.USB 存储设备

许多外部存储解决方案，如硬盘驱动器、USB 拇指驱动器以及 CD 和 DVD 刻录机，使用通用串行总线（USB）。FreeBSD 提供对 USB 1.x、2.0 和 3.0 设备的支持。

|  | USB 3.0 支持与某些硬件不兼容，包括 Haswell（Lynx point）芯片组。如果 FreeBSD 引导显示 failed with error 19 消息，请在系统 BIOS 中禁用 xHCI / USB3。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------ |

对 USB 存储设备的支持内置于 GENERIC 内核中。对于自定义内核，请确保内核配置文件中包含以下行：

```
device scbus	# SCSI bus (required for ATA/SCSI)
device da	# Direct Access (disks)
device pass	# Passthrough device (direct ATA/SCSI access)
device uhci	# provides USB 1.x support
device ohci	# provides USB 1.x support
device ehci	# provides USB 2.0 support
device xhci	# provides USB 3.0 support
device usb	# USB Bus (required)
device umass	# Disks/Mass storage - Requires scbus and da
device cd	# needed for CD and DVD burners
```

FreeBSD 使用 umass（4）驱动程序，该驱动程序使用 SCSI 子系统来访问 USB 存储设备。由于任何 USB 设备都将被系统视为 SCSI 设备，因此，如果 USB 设备是 CD 或 DVD 刻录机，请勿在自定义内核配置文件中包含 device atapicam。

本节的其余部分演示如何验证 FreeBSD 认可 USB 存储设备，并配置设备以便使用。

### 20.4.1. 设备配置

要测试 USB 配置，请插入 USB 设备。使用 dmesg 确认驱动器是否出现在系统消息缓冲区中。应该看起来像这样：

```
umass0: <STECH Simple Drive, class 0/0, rev 2.00/1.04, addr 3> on usbus0
umass0:  SCSI over Bulk-Only; quirks = 0x0100
umass0:4:0:-1: Attached to scbus4
da0 at umass-sim0 bus 0 scbus4 target 0 lun 0
da0: <STECH Simple Drive 1.04> Fixed Direct Access SCSI-4 device
da0: Serial Number WD-WXE508CAN263
da0: 40.000MB/s transfers
da0: 152627MB (312581808 512 byte sectors: 255H 63S/T 19457C)
da0: quirks=0x2<NO_6_BYTE>
```

品牌、设备节点（da0）、速度和大小将根据设备而异。

由于 USB 设备被视为 SCSI 设备，可以使用 camcontrol 列出连接到系统的 USB 存储设备：

```
# camcontrol devlist
<STECH Simple Drive 1.04>          at scbus4 target 0 lun 0 (pass3,da0)
```

或者，可以使用 usbconfig 列出设备。有关此命令的更多信息，请参考 usbconfig(8)。

```
# usbconfig
ugen0.3: <Simple Drive STECH> at usbus0, cfg=0 md=HOST spd=HIGH (480Mbps) pwr=ON (2mA)
```

如果设备尚未格式化，请参考“添加磁盘”中的说明，了解如何格式化并在 U 盘上创建分区。如果驱动器已带有文件系统，则可以按照“挂载和卸载文件系统”中的说明，由 root 挂载。

|  | 允许不受信任的用户挂载任意媒体，通过如下说明启用 vfs.usermount，从安全角度来看是不安全的。大多数文件系统并不是为防范恶意设备而构建的。|
| -- | ----------------------------------------------------------------------------------------------------------------------------------------- |

要将设备作为普通用户挂载，一个解决方案是使用 pw(8) 使设备的所有用户成为 operator 组的成员。接下来，通过在 /etc/devfs.rules 中添加以下行确保 operator 能够读写该设备：

```
[localrules=5]
add path 'da*' mode 0660 group operator
```

```
add path 'da[3-9]*' mode 0660 group operator
```

排除前三个 SCSI 磁盘（da0 至 da2）不属于 operator 组。将 3 替换为内部 SCSI 磁盘的数量。有关此文件的更多信息，请参阅 devfs.rules(5)。

接下来，在/etc/rc.conf 中启用规则集：

```
devfs_system_ruleset="localrules"
```

然后，通过将以下行添加到/etc/sysctl.conf 来指示系统允许普通用户挂载文件系统：

```
vfs.usermount=1
```

由于此项只有在下次重启后生效，因此可以使用 sysctl 现在设置这个变量：

```
# sysctl vfs.usermount=1
vfs.usermount: 0 -> 1
```

最后一步是创建一个目录，用于挂载文件系统。这个目录需要被即将挂载文件系统的用户所拥有。一种方法是让 root 创建一个子目录，并将其所有权赋予该用户，如 /mnt/用户名。在下面的示例中，请用用户的登录名替换用户名，用用户组替换用户的主要组：

```
# mkdir /mnt/username
# chown username:usergroup /mnt/username
```

假设插入了一个 USB 闪存驱动器，并且出现了一个设备 /dev/da0s1。如果该设备使用 FAT 文件系统格式化，用户可以使用以下命令挂载它：

```
% mount -t msdosfs -o -m=644,-M=755 /dev/da0s1 /mnt/username
```

设备在被拔除之前必须先卸载：

```
% umount /mnt/username
```

设备移除后，系统消息缓冲区将显示类似以下内容的消息：

```
umass0: at uhub3, port 2, addr 3 (disconnected)
da0 at umass-sim0 bus 0 scbus4 target 0 lun 0
da0: <STECH Simple Drive 1.04> s/n WD-WXE508CAN263          detached
(da0:umass-sim0:0:0:0): Periph destroyed
```

### 20.4.2. 可移动介质的自动装载

USB 设备可以通过取消注释/etc/auto_master 中的这行来自动挂载:

```
/media		-media		-nosuid
```

然后在/etc/devd.conf 中添加这些行:

```
notify 100 {
	match "system" "GEOM";
	match "subsystem" "DEV";
	action "/usr/sbin/automount -c";
};
```

如果 autofs(5)和 devd(8)已经运行，请重新加载配置:

```
# service automount restart
# service devd restart
```

autofs(5)可以通过将此行添加到/etc/rc.conf 来在启动时启动：

```
autofs_enable="YES"
```

autofs(5)需要启用 devd(8)，默认情况下已启用。

立即启动服务：

```
# service automount start
# service automountd start
# service autounmountd start
# service devd start
```

每个可以自动挂载的文件系统都显示为/media/中的一个目录。该目录以文件系统标签命名。如果标签缺失，则该目录以设备节点命名。

文件系统在第一次访问时被透明地挂载，并在一段时间的不活动后被卸载。自动挂载的驱动器也可以手动卸载：

```
# automount -fu
```

这种机制通常用于存储卡和 USB 存储设备。它可用于任何块设备，包括光驱或 iSCSILUN。
