# 20.5.创建和使用 CD

紧凑盘（CD）媒体具有许多功能，使它们与传统磁盘有所区别。它们被设计成连续读取而无需在轨道之间移动磁头。虽然 CD 媒体确实有轨道，但这些是指要连续读取的数据部分，而不是磁盘的物理属性。ISO 9660 文件系统是为了解决这些差异而设计的。

FreeBSD ports 提供了多个用于烧录和复制音频和数据 CD 的实用工具。本章演示了几个命令行实用程序的使用。对于带有图形界面实用程序的 CD 刻录软件，请考虑安装 sysutils/xcdroast 或 sysutils/k3b 软件包或ports。

### 20.5.1. 支持的设备

通用内核提供对 SCSI、USB 和 ATAPICD 读取器和刻录机的支持。如果使用自定义内核，则需要在内核配置文件中包含特定于设备类型的选项。

对于 SCSI 烧录机，请确保这些选项存在：

```
device scbus	# SCSI bus (required for ATA/SCSI)
device da	# Direct Access (disks)
device pass	# Passthrough device (direct ATA/SCSI access)
device cd	# needed for CD and DVD burners
```

对于 USB 烧录机，请确保这些选项存在：

```
device scbus	# SCSI bus (required for ATA/SCSI)
device da	# Direct Access (disks)
device pass	# Passthrough device (direct ATA/SCSI access)
device cd	# needed for CD and DVD burners
device uhci	# provides USB 1.x support
device ohci	# provides USB 1.x support
device ehci	# provides USB 2.0 support
device xhci	# provides USB 3.0 support
device usb	# USB Bus (required)
device umass	# Disks/Mass storage - Requires scbus and da
```

对于 ATAPI 烧录机，请确保这些选项存在：

```
device ata	# Legacy ATA/SATA controllers
device scbus	# SCSI bus (required for ATA/SCSI)
device pass	# Passthrough device (direct ATA/SCSI access)
device cd	# needed for CD and DVD burners
```

```
device atapicam
```

或者，可以通过在 /boot/loader.conf 中添加以下行来在引导时加载此驱动程序：

```
atapicam_load="YES"
```

这将需要系统重启，因为此驱动程序只能在引导时加载。

要验证 FreeBSD 是否识别设备，请运行 dmesg 并查找设备的条目。在 10.x 之前的系统中，输出的第一行中设备名称将为 acd0 而不是 cd0。

```
% dmesg | grep cd
cd0 at ahcich1 bus 0 scbus1 target 0 lun 0
cd0: <HL-DT-ST DVDRAM GU70N LT20> Removable CD-ROM SCSI-0 device
cd0: Serial Number M3OD3S34152
cd0: 150.000MB/s transfers (SATA 1.x, UDMA6, ATAPI 12bytes, PIO 8192bytes)
cd0: Attempt to query device size failed: NOT READY, Medium not present - tray closed
```

### 20.5.2. 刻录光盘

在 FreeBSD 中，cdrecord 可以用来刻录光盘。此命令与 sysutils/cdrtools 软件包或port一起安装。

虽然 cdrecord 有许多选项，基本用法很简单。指定要刻录的 ISO 文件名，如果系统有多个刻录设备，请指定要使用的设备名称：

```
# cdrecord dev=device imagefile.iso
```

為了確定燒錄裝置的名稱，請使用{{ 0 }}，可能會產生如下結果：

```
# cdrecord -scanbus
ProDVD-ProBD-Clone 3.00 (amd64-unknown-freebsd10.0) Copyright (C) 1995-2010 Jörg Schilling
Using libscg version 'schily-0.9'
scsibus0:
        0,0,0     0) 'SEAGATE ' 'ST39236LW       ' '0004' Disk
        0,1,0     1) 'SEAGATE ' 'ST39173W        ' '5958' Disk
        0,2,0     2) *
        0,3,0     3) 'iomega  ' 'jaz 1GB         ' 'J.86' Removable Disk
        0,4,0     4) 'NEC     ' 'CD-ROM DRIVE:466' '1.26' Removable CD-ROM
        0,5,0     5) *
        0,6,0     6) *
        0,7,0     7) *
scsibus1:
        1,0,0   100) *
        1,1,0   101) *
        1,2,0   102) *
        1,3,0   103) *
        1,4,0   104) *
        1,5,0   105) 'YAMAHA  ' 'CRW4260         ' '1.0q' Removable CD-ROM
        1,6,0   106) 'ARTEC   ' 'AM12S           ' '1.06' Scanner
        1,7,0   107) *
```

找到 CD 燒錄機的項目，並使用逗號分隔的三個數字作為{{ 0 }} 的值。在這種情況下，Yamaha 燒錄機的裝置是{{ 1 }}，所以指定該裝置的適當輸入是{{ 2 }}。參考{{ 3 }}的手冊頁面，以其他方式指定這個值並獲取有關撰寫音軌和控制寫入速度的資訊。

或者執行以下命令以獲取燒錄裝置的設備地址：

```
# camcontrol devlist
<MATSHITA CDRW/DVD UJDA740 1.00>   at scbus1 target 0 lun 0 (cd0,pass0)
```

使用数字值 scbus，target 和 lun。对于本示例，1,0,0 是要使用的设备名称。

### 20.5.3. 写入数据到 ISO 文件系统

为了制作数据 CD，在将要烧录到 CD 上的数据文件之前必须进行准备。在 FreeBSD 中，sysutils/cdrtools 安装 mkisofs，它可以用来生成一个 ISO 9660 文件系统，这是 UNIX® 文件系统中目录树的镜像。最简单的用法是指定要创建的 ISO 文件的名称以及要放入 ISO 9660 文件系统中的文件的路径：

```
# mkisofs -o imagefile.iso /path/to/tree
```

此命令将指定路径中的文件名映射到符合标准 ISO 9660 文件系统限制的名称，并将排除不符合 ISO 文件系统标准的文件。

有许多选项可用于克服标准所施加的限制。特别地，-R 可启用通用于 UNIX® 系统的 Rock Ridge 扩展，而 -J 可启用 Microsoft® 系统使用的 Joliet 扩展。

对于仅在 FreeBSD 系统上使用的 CD，-U 可用于禁用所有文件名限制。与 -R 一起使用时，即使违反 ISO 9660 标准，它也会生成与指定的 FreeBSD 树完全相同的文件系统镜像。

通用用途的最后一个选项是 -b。此选项用于指定用于生成“El Torito”可引导 CD 的引导镜像的位置。此选项带有一个参数，即 CD 写入树顶部的引导镜像路径。默认情况下，mkisofs 创建一个在“软盘磁盘模拟”模式下的 ISO 镜像，因此期望引导镜像大小为 1200、1440 或 2880 KB。某些引导加载程序（如 FreeBSD 发行媒体使用的加载程序）不使用仿真模式。在这种情况下，应使用 -no-emul-boot。因此，如果 /tmp/myboot 包含一个可引导的 FreeBSD 系统，并且引导镜像位于 /tmp/myboot/boot/cdboot 中，此命令将生成 /tmp/bootable.iso：

```
# mkisofs -R -no-emul-boot -b boot/cdboot -o /tmp/bootable.iso /tmp/myboot
```

生成的 ISO 镜像可以作为内存磁盘挂载：

```
# mdconfig -a -t vnode -f /tmp/bootable.iso -u 0
# mount -t cd9660 /dev/md0 /mnt
```

然后可以验证 /mnt 和 /tmp/myboot 是否相同。

有许多其他选项可用于细化其行为。有关详细信息，请参阅 mkisofs(8)。

```
# dd if=/dev/cd0 of=file.iso bs=2048
```

生成的映像文件可以按照刻录 CD 中说明的方式刻录到 CD 上。

### 使用数据 CD

ISO 被刻录到 CD 之后，可以通过指定文件系统类型，包含 CD 的设备名称和现有的挂载点来挂载它：

```
# mount -t cd9660 /dev/cd0 /mnt
```

由于 mount 假设文件系统是 ufs 类型，如果在挂载数据 CD 时不包括 -t cd9660，将会发生 Incorrect super block 错误。

虽然任何数据 CD 都可以用这种方式挂载，但具有某些 ISO 9660 扩展的磁盘可能会表现出异常行为。例如，Joliet 磁盘使用两字节的 Unicode 字符存储所有文件名。如果一些非英文字符显示为问号，请使用 -C 指定本地字符集。有关更多信息，请参考 mount_cd9660(8)。

```
cd9660_iconv_load="YES"
```

然后重启计算机，或者直接使用 kldload 加载模块。

有时，在尝试挂载数据光盘时，会显示 Device not configured。这通常意味着光驱没有检测到托盘中的磁盘，或者驱动器在总线上不可见。CD 驱动器可能需要几秒钟才能检测到媒体，请耐心等待。

有时，SCSICD 驱动器可能丢失，因为它没有足够的时间来响应总线复位。要解决此问题，可以创建一个自定义内核，增加默认的 SCSI 延迟。将以下选项添加到自定义内核配置文件中，并按照“构建和安装自定义内核”中的说明重新构建内核：

```
options SCSI_DELAY=15000
```

这告诉 SCSI 总线在启动过程中暂停 15 秒钟，以便 CD 驱动器有可能回应总线重置。

```
# tar xzvf /dev/cd1
```

为了挂载数据 CD，数据必须使用 mkisofs 来写入。

### 复制音频 CD

复制音频 CD 的步骤是，从 CD 提取音频数据到一系列文件，然后将这些文件写入空白 CD。

过程：复制音频 CD 说明了如何复制和烧录音频 CD。如果 FreeBSD 版本小于 10.0，并且设备是 ATAPI，必须首先加载 atapicam 模块，方法请参考支持的设备中的说明。

复制音频 CD 的步骤

1. sysutils/cdrtools 软件包或port安装 cdda2wav。此命令可用于提取所有音轨，每个音轨写入当前工作目录的单独 WAV 文件：

    ```
    % cdda2wav -vall -B -Owav
    ```

    如果系统上只有一个 CD 设备，则无需指定设备名称。请参考 cdda2wav 手册页，了解如何指定设备以及了解此命令的其他选项。
2. 使用 cdrecord 来写入.wav 文件：

    ```
    % cdrecord -v dev=2,0 -dao -useinfo  *.wav
    ```

    确保 2.0 设置正确，如在刻录 CD 中所述。
