# 20.6.创建和使用 DVD

与 CD 相比，DVD 是光盘存储技术的下一代。DVD 可以存储比任何 CD 更多的数据，并且是视频出版的标准。

五种物理可记录格式可用于可记录的 DVD：

* DVD-R：这是最早的可记录 DVD 格式。DVD-R 标准由 DVD 论坛定义。这种格式只能写入一次。
* DVD-RW：这是 DVD-R 标准的可重写版本。DVD-RW 可以重写约 1000 次。
* DVD-RAM：这是一种可重写格式，可以被视为可移动硬盘。然而，这种介质与大多数 DVD-ROM 驱动器和 DVD 视频播放器不兼容，因为只有少数 DVD 写入器支持 DVD-RAM 格式。有关使用 DVD-RAM 的更多信息，请参阅使用 DVD-RAM。
* DVD+RW：这是由 DVD+RW 联盟定义的可重写格式。DVD+RW 可以重写约 1000 次。
* DVD+R：这种格式是 DVD+RW 格式的一次写入变体。

一张单层可录制的 DVD 可容纳多达 4,700,000,000 字节，实际上是 4.38 GB 或 4485 MB，因为 1 千字节等于 1024 字节。

|  | 必须区分介质和应用。例如，DVD-Video 是一种特定的文件布局，可写入任何可录制的 DVD 物理介质，例如 DVD-R、DVD+R 或 DVD-RW。在选择介质类型之前，请确保刻录机和 DVD-Video 播放器与考虑中的介质兼容。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

### 20.6.1. 配置

要执行 DVD 录制，请使用 growisofs（1）。此命令是 sysutils/dvd+rw-tools 实用程序的一部分，支持所有 DVD 媒体类型。

这些工具使用 SCSI 子系统来访问设备，因此必须加载或静态编译 ATAPI/CAM 支持到内核中。如果刻录机使用 USB 接口，则不需要此支持。有关 USB 设备配置的更多详细信息，请参阅 USB 存储设备。

还必须为 ATAPI 设备启用 DMA 访问，方法是将以下行添加到/boot/loader.conf 中：

```
hw.ata.atapi_dma="1"
```

在尝试使用 dvd+rw-tools 之前，请查阅硬件兼容性说明。

|  | 对于图形用户界面，请考虑使用 sysutils/k3b，它提供了一个用户友好的界面来使用 growisofs(1)和许多其他刻录工具。|
| -- | -------------------------------------------------------------------------------------------------------------- |

### 20.6.2. 刻录数据 DVD

由于 growisofs(1) 是 mkisofs 的前端，它将调用 mkisofs(8) 来创建文件系统布局并在 DVD 上进行写入。这意味着在烧录过程中不需要创建数据的镜像。

要将 /path/to/data 中的数据刻录到 DVD+R 或 DVD-R 上，请使用以下命令：

```
# growisofs -dvd-compat -Z /dev/cd0 -J -R /path/to/data
```

在此示例中，-J -R 被传递给 mkisofs(8) 来创建带有 Joliet 和 Rock Ridge 扩展的 ISO 9660 文件系统。有关更多细节，请参阅 mkisofs(8)。

用于初始会话录制，-Z 用于单个和多个会话。将 /dev/cd0 替换为 DVD 设备的名称。使用 -dvd-compat 表示磁盘将被关闭，录制将不可追加。这还应该提供更好的兼容性与 DVD-ROM 驱动器。

要烧录预先制作好的镜像，比如 imagefile.iso，请使用：

```
# growisofs -dvd-compat -Z /dev/cd0=imagefile.iso
```

写入速度应根据使用的介质和驱动器进行检测并自动设置。要强制写入速度，请使用 -speed=。请参阅 growisofs(1) 以获取示例用法。

```
% mkisofs -R -J -udf -iso-level 3 -o imagefile.iso /path/to/data
```

直接将文件刻录到光盘：

```
# growisofs -dvd-compat -udf -iso-level 3 -Z /dev/cd0 -J -R /path/to/data
```

如果 ISO 镜像已包含大文件，则不需要额外选项让 growisofs(1) 将该镜像刻录到光盘。

确保使用更新版本的 sysutils/cdrtools，其中包含 mkisofs(8)，因为旧版本可能不支持大文件。如果最新版本不起作用，请安装 sysutils/cdrtools-devel 并阅读其 mkisofs(8)。

### 20.6.3. 刻录 DVD-Video

DVD-Video 是基于 ISO 9660 和微型 UDF（M-UDF）规范的特定文件布局。由于 DVD-Video 呈现特定的数据结构层次，需要使用特定程序，如 multimedia/dvdauthor 来制作 DVD。

如果 DVD-Video 文件系统的镜像已存在，它可以像任何其他镜像一样刻录。如果使用 dvdauthor 制作 DVD，并且结果位于 /path/to/video，则应使用以下命令来刻录 DVD-Video：

```
# growisofs -Z /dev/cd0 -dvd-video /path/to/video
```

-dvd-video 被传递给 mkisofs(8) 来指示它创建一个 DVD-Video 文件系统布局。这个选项意味着 -dvd-compat growisofs(1) 选项。

### 20.6.4. 使用 DVD+RW

与 CD-RW 不同，一块新的 DVD+RW 在第一次使用前需要格式化。建议在适当时让 growisofs(1) 自动处理这个。但是，可以使用 dvd+rw-format 来格式化 DVD+RW：

```
# dvd+rw-format /dev/cd0
```

只执行一次此操作，并记住只有全新的 DVD+RW 媒体需要格式化。在格式化后，DVD+RW 就可以像往常一样进行刻录。

要烧录全新的文件系统，而不仅仅是在 DVD+RW 上追加一些数据，媒体不需要先清空。相反，可以像这样覆盖之前的录制：

```
# growisofs -Z /dev/cd0 -J -R /path/to/newdata
```

DVD+RW 格式支持在之前的录制基础上追加数据。这个操作包括将新会话合并到现有会话中，因此不被视为多会话写入。growisofs(1) 将会增加媒体上存在的 ISO 9660 文件系统。

例如，要向 DVD+RW 追加数据，请使用以下命令：

```
# growisofs -M /dev/cd0 -J -R /path/to/nextdata
```

下一次写入时应使用与刻录初始会话相同的 mkisofs(8)选项。

|  | 使用 -dvd-compat 以获得更好的 DVD-ROM 驱动器兼容性。在使用 DVD+RW 时，此选项不会阻止数据的添加。|
| -- | -------------------------------------------------------------------------------------------------- |

用于擦除媒体，请使用：

```
# growisofs -Z /dev/cd0=/dev/zero
```

### 20.6.5. 使用 DVD-RW

DVD-RW 可接受两种光盘格式：增量顺序写入和受限覆写。默认情况下，DVD-RW 光盘处于顺序格式。

一张未使用过的 DVD-RW 可以直接写入，无需格式化。但是，在顺序格式下的非空白 DVD-RW 在写入新的初始会话前需要先擦除。

要擦除顺序模式下的 DVD-RW：

```
# dvd+rw-format -blank=full /dev/cd0
```

```
# growisofs -use-the-force-luke=dao -Z /dev/cd0=imagefile.iso
```

由于 growisofs(1) 自动尝试检测快速擦除的介质并启用 DAO 写入，因此不应需要 -use-the-force-luke=dao。

使用任何 DVD-RW 应该改用受限覆写模式，因为这种格式比增量顺序更加灵活。

要在顺序 DVD-RW 上写入数据，请使用与其他 DVD 格式相同的说明：

```
# growisofs -Z /dev/cd0 -J -R /path/to/data
```

要在先前的录音上追加一些数据，请使用 growisofs(1) 的 -M。然而，如果在增量顺序模式下追加数据到 DVD-RW 上，则光盘将创建一个新会话，结果将是多会话光盘。

采用有限覆写格式的 DVD-RW 在进行新的初始会话之前不需要被擦除。相反，使用 -Z 覆写光盘。也可以使用 -M 来扩展已写入光盘上的现有 ISO 9660 文件系统。结果将是一个单会话 DVD。

要将 DVD-RW 设置为有限覆写格式，请使用以下命令：

```
# dvd+rw-format /dev/cd0
```

要切换回顺序格式，请使用：

```
# dvd+rw-format -blank=full /dev/cd0
```

### 20.6.6. 多会话

很少的 DVD-ROM 驱动器支持多会话 DVD，并且大多数情况下只读取第一个会话。顺序格式的 DVD+R、DVD-R 和 DVD-RW 可以接受多个会话。对于 DVD+RW 和 DVD-RW 有限覆写格式，不存在多个会话的概念。

在顺序格式的 DVD+R、DVD-R 或 DVD-RW 的初始非关闭会话之后，使用以下命令将向光盘添加新的会话：

```
# growisofs -M /dev/cd0 -J -R /path/to/nextdata
```

使用此命令与处于受限覆盖模式下的 DVD+RW 或 DVD-RW 一起将数据追加，同时将新会话合并到现有会话中。结果将是单一会话光盘。使用此方法在这些类型的介质上进行初始写入后添加数据。

|  | 由于在每个会话之间使用了一些空间来标记会话的结束和开始，因此应该添加大量数据的会话以优化介质空间利用。会话数对于 DVD+R 受限到 154 个，对于 DVD-R 约为 2000 个，对于 DVD+R 双层为 127 个。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |

### 20.6.7. 更多信息

要获取有关 DVD 的更多信息，请在指定的驱动器中插入光盘时使用 dvd+rw-mediainfo<span> </span><em>/dev/cd0</em>。

关于 dvd+rw-tools 的更多信息可以在 growisofs(1)、dvd+rw-tools 网站和 cdwrite 邮件列表归档中找到。

|  | 在创建与 dvd+rw-tools 使用有关的问题报告时，始终包括 dvd+rw-mediainfo 的输出。|
| -- | -------------------------------------------------------------------------------- |

### 使用 DVD-RAM 的 20.6.8。

DVD-RAM 编写器可以使用 SCSI 或 ATAPI 接口。对于 ATAPI 设备，必须通过向 /boot/loader.conf 添加以下行来启用 DMA 访问：

```
hw.ata.atapi_dma="1"
```

DVD-RAM 可被视为可移动硬盘。与任何其他硬盘一样，必须在使用之前格式化 DVD-RAM。在本示例中，整个磁盘空间将使用标准 UFS2 文件系统格式化：

```
# dd if=/dev/zero of=/dev/acd0 bs=2k count=1
# bsdlabel -Bw acd0
# newfs /dev/acd0
```

DVD 设备 acd0 必须根据配置更改。

 DVD-RAM 在格式化后就可以被挂载为普通硬盘：

```
# mount /dev/acd0 /mnt
```

挂载之后 DVD-RAM 将是可读写的。
