# 20.8.使用 NTFS 磁盘

本部分讲解如何在 FreeBSD 中挂载 NTFS 磁盘。

NTFS（新技术文件系统）是由 Microsoft®开发的专有日志文件系统。多年来，它一直是 Microsoft Windows®中的默认文件系统。FreeBSD 可以使用 FUSE 文件系统挂载 NTFS 卷。这些文件系统被实现为用户空间程序，通过明确定义的接口与 fusefs(5)内核模块交互。

**过程：挂载 NTFS 磁盘的步骤**

1. 在使用 FUSE 文件系统之前，我们需要加载 fusefs(5)内核模块：

    ```
    # kldload fusefs
    ```

    使用 sysrc(8) 在启动时加载模块：

    ```
    # sysrc kld_list+=fusefs
    ```
2. 从软件包中安装实际的 NTFS 文件系统，如示例中所示（请参阅使用 pkg 进行二进制软件包管理），或从ports（请参阅使用ports ）获取：

    ```
    # pkg install fusefs-ntfs
    ```
3. 最后，我们需要创建一个目录，用于挂载文件系统：

    ```
    # mkdir /mnt/usb
    ```
4. 插入 USB 磁盘后，可以使用 gpart(8) 查看磁盘分区信息：

    ```
    # gpart show da0
    =>	  63  1953525105  da0 MBR   (932G)
    	  63  1953525105    1 ntfs  (932G)
    ```
5. 我们可以使用以下命令挂载磁盘：

    ```
    # ntfs-3g /dev/da0s1 /mnt/usb/
    ```

    磁盘现在已经准备好使用。
6. 此外，可以将条目添加到 /etc/fstab 中：

    ```
    /dev/da0s1  /mnt/usb	ntfs mountprog=/usr/local/bin/ntfs-3g,noauto,rw  0 0
    ```

    现在可以使用以下命令挂载磁盘：

    ```
    # mount /mnt/usb
    ```
7. 可以使用以下命令卸载磁盘：

    ```
    # umount /mnt/usb/
    ```
