# 20.9.备份的基础知识

实施备份计划至关重要，可以帮助在磁盘故障、意外文件删除、随机文件损坏或完全机器毁坏（包括现场备份毁坏）时恢复数据能力。

备份类型和计划将根据数据的重要性、文件还原所需的粒度以及可接受的停机时间而变化。一些可能的备份技术包括:

* 整个系统的存档，备份到永久的离线介质。这提供了对上述所有问题的保护，但是恢复速度慢，对非特权用户来说也不方便。
* 文件系统快照，对于恢复已删除文件或文件先前版本很有用。
* 使用预定的 net/rsync 定期同步到网络上另一系统的完整文件系统或磁盘的副本。
* 硬件或软件 RAID，当磁盘故障时最小化或避免停机时间。

通常使用备份技术的混合。例如，可以创建一个计划自动化每周一次的完整系统备份，存储在离线位置，并补充这种备份与每小时的 ZFS 快照。此外，在进行文件编辑或删除之前，可以手动备份单个目录或文件。

本部分说明了一些可用于在 FreeBSD 系统上创建和管理备份的实用工具。

### 20.9.1. 文件系统备份

用于备份文件系统的传统 UNIX®程序是 dump(8)，用于创建备份，以及 restore(8)，用于恢复备份。这些实用工具在磁盘块级别工作，低于文件系统创建的文件、链接和目录的抽象层。与其他备份软件不同，dump 备份整个文件系统，并且无法备份文件系统的部分或跨多个文件系统的目录树的一部分。而不是写入文件和目录，dump 写入构成文件和目录的原始数据块。

|  | 如果 dump 用于根目录，它将不会备份/home、/usr 或许多其他目录，因为这些通常是其他文件系统的挂载点或指向这些文件系统的符号链接。|
| -- | -------------------------------------------------------------------------------------------------------------------------------- |

在恢复数据时，restore 默认情况下将临时文件存储在/tmp/中。如果使用的恢复盘/tmp/空间较小，请将 TMPDIR 设置为一个空间更大的目录，以确保恢复成功。

使用 dump 时，请注意它仍保留了一些自其早期版本在 AT&T UNIX® Version 6（大约 1975 年）的特殊之处。默认参数假定备份到 9 磁带，而不是到其他类型的介质或今天可用的高密度磁带。这些默认值必须在命令行上被覆盖。

可以通过网络将文件系统备份到另一台计算机或连接到另一台计算机的磁带驱动器。虽然可以使用 rdump(8)和 rrestore(8)工具来实现这一目的，但它们不被视为安全。

相反，可以通过 SSH 连接更安全地使用 dump 和 restore。该示例创建了/usr 的完整压缩备份，并通过 SSH 连接将备份文件发送到指定的主机。

示例 1. 使用 dump 通过 ssh

```
# /sbin/dump -0uan -f - /usr | gzip -2 | ssh -c blowfish \
          targetuser@targetmachine.example.com dd of=/mybigfiles/dump-usr-l0.gz
```

此示例设置 RSH 以便通过 SSH 连接将备份写入远程系统上的磁带驱动器：

示例 2. 使用 dump 在 ssh 中与 RSH 

```
# env RSH=/usr/bin/ssh /sbin/dump -0uan -f targetuser@targetmachine.example.com:/dev/sa0 /usr
```

|  | 使用 Z 文件系统（ZFS）的系统可以利用 zfs(8) 来创建快照，并将其发送和接收到/从远程系统。|
| -- | ----------------------------------------------------------------------------------------- |

### 20.9.2. 目录备份

有几个内置工具可用于根据需要备份和恢复指定的文件和目录。

对于备份目录中所有文件的良好选择是 tar(1)。此实用程序可以追溯到 AT&T UNIX® Version 6，并默认假定向本地磁带设备进行递归备份。可以使用开关来指定备份文件的名称。

该示例创建了当前目录的压缩备份，并将其保存到 /tmp/mybackup.tgz。创建备份文件时，请确保备份不要保存到被备份的同一目录中。

示例 3. 使用 tar 备份当前目录

```
# tar czvf /tmp/mybackup.tgz .
```

要还原整个备份，请将 cd 解压到要还原的目录中，并指定备份的名称。请注意，这将覆盖还原目录中任何更新版本的文件。如果有疑问，请还原到临时目录或指定要还原的备份文件名。

示例 4. 使用 tar 恢复当前目录

```
# tar xzvf /tmp/mybackup.tgz
```

tar(1) 说明了几十种可用的开关选项。此实用程序还支持使用排除模式，以指定在备份指定目录或从备份恢复文件时不应包括哪些文件。

要使用指定的文件和目录列表创建备份，cpio(1) 是一个不错的选择。与 tar 不同，cpio 不知道如何遍历目录树，必须提供要备份的文件列表。

例如，可以使用 ls 或 find 来创建文件列表。此示例会创建当前目录的递归列表，然后将其导出到 cpio，以创建名为/tmp/mybackup.cpio 的输出备份文件。

示例 5。使用 ls 和 cpio 来对当前目录进行递归备份

```
# ls -R | cpio -ovF /tmp/mybackup.cpio
```

一款备份实用程序，它试图弥补由 tar 和 cpio 提供的功能。多年来，tar 和 cpio 的各个版本变得略有不兼容。POSIX®创建了 pax，它尝试读取和写入许多不同的 cpio 和 tar 格式，以及一些新的格式。

pax 等同于之前的例子:

示例 6. 使用 pax 备份当前目录

```
# pax -wf /tmp/mybackup.pax .
```

### 20.9.3. 使用数据磁带进行备份

虽然磁带技术不断发展，现代备份系统倾向于将异地备份与本地可移动介质结合使用。FreeBSD 支持使用 SCSI 的任何磁带驱动器，如 LTO 或 DAT。对于 SATA 和 USB 磁带驱动器有限的支持。

对于 SCSI 磁带设备，FreeBSD 使用 sa(4)驱动程序以及/dev/sa0、/dev/nsa0 和/dev/esa0 设备。物理设备名称为/dev/sa0。使用/dev/nsa0 时，备份应用程序在写入文件后不会倒带磁带，能让将多个文件写入磁带。使用/dev/esa0 在设备关闭后弹出磁带。

在 FreeBSD 中，mt 用于控制磁带驱动器的操作，例如在磁带上查找文件或向磁带写入控制标记。例如，可以通过跳过前三个文件来保留磁带上的前三个文件，然后再写入新文件：

```
# mt -f /dev/nsa0 fsf 3
```

该实用程序支持许多操作。有关详细信息，请参阅 mt(1)。

要使用 tar 将单个文件写入磁带，请指定磁带设备的名称和要备份的文件：

```
# tar cvf /dev/sa0 file
```

将来自磁带上 tar 存档的文件恢复到当前目录：

```
# tar xvf /dev/sa0
```

使用 dump 备份 UFS 文件系统。此示例备份 /usr，完成后不倒回磁带：

```
# dump -0aL -b64 -f /dev/nsa0 /usr
```

从磁带上的 dump 文件交互式地恢复文件到当前目录：

```
# restore -i -f /dev/nsa0
```

### 20.9.4. 第三方备份工具

FreeBSD Ports 提供许多第三方实用工具，可用于安排备份的创建，简化磁带备份，并使备份更加便捷和方便。其中许多应用程序基于客户端/服务器架构，可用于自动化单个系统或网络中所有计算机的备份。

流行的实用工具包括：

* Amanda（misc/amanda-server 和 misc/amanda-client），
* Bacula（sysutils/bacula13-server 和 sysutils/bacula13-client），
* Bareos（sysutils/bareos-server 和 sysutils/bareos-client），
* net/rsync，
* 简化工具/duply, 和
* 简化工具/duplicity.

### 20.9.5. 紧急恢复

除了定期备份外，建议作为应急准备计划的一部分执行以下步骤。

创建以下命令输出的打印副本：

* `gpart show`
* `more /etc/fstab`
* `pkg prime-list`
* `dmesg`

将此打印件和安装介质的副本存储在安全位置。如果需要进行紧急恢复，启动安装介质并选择 Live CD 以访问救援shell。此救援模式可用于查看系统的当前状态，必要时重新格式化磁盘并从备份中恢复数据。

接下来，测试救援 shell 和备份。记录下操作步骤。将这些记录与媒体、打印件和备份存储在一起。这些记录可能会在紧急恢复操作时防止意外破坏备份数据。

为了增加安全保障，将最新的备份存储在距离计算机和硬盘驱动器有显著距离的远程位置。
