# 21.2.RAID0——条带

条带化将多个磁盘驱动器组合成单个卷。可通过使用硬件 RAID 控制器来执行条带化。GEOM 磁盘子系统为磁盘条带化（也称为 RAID0）提供软件支持，无需 RAID 磁盘控制器。

在 RAID0 中，数据被分割成块，并写入阵列中的所有驱动器。如下图所示，与系统等待将 256k 写入一个磁盘相比，RAID0 可以同时将 64k 写入阵列中的四个磁盘，提供更优异的 I/O 性能。通过使用多个磁盘控制器，可以进一步提升性能。

![Disk Striping Illustration](https://docs.freebsd.org/images/books/handbook/geom/striping.png)

RAID0 条带中的每个磁盘必须具有相同的大小，因为 I/O 请求被交错以并行读取或写入多个磁盘。

|  | RAID0 不提供任何冗余性。这意味着如果阵列中的一个磁盘故障，所有磁盘上的数据都会丢失。如果数据很重要，请实施定期将备份保存到远程系统或设备的备份策略。|
| -- | ------------------------------------------------------------------------------------------------------------------------------------------------------ |

创建在 FreeBSD 系统上使用普通磁盘创建基于 GEOM 的 RAID0 软件的过程如下。如条带创建完成，请参考 gstripe(8) 以获取有关如何控制现有条带的更多信息。

**步骤：创建未格式化 ATA 磁盘的条带**

1. 载入 geom_stripe.ko 模块:

    ```
    # kldload geom_stripe
    ```
2. 确保存在适当的挂载点。如果此卷将成为根分区，则暂时使用另一个挂载点，如 /mnt。
3. 确定将进行条带化的磁盘的设备名称，并创建新的条带设备。例如，要对两个未使用和未分区的 ATA 磁盘进行条带化，设备名称为 /dev/ad2 和 /dev/ad3：

    ```
    # gstripe label -v st0 /dev/ad2 /dev/ad3
    Metadata value stored on /dev/ad2.
    Metadata value stored on /dev/ad3.
    Done.
    ```
4. 在新卷上编写标准标签，也称为分区表，并安装默认引导代码：

    ```
    # bsdlabel -wB /dev/stripe/st0
    ```
5. 该过程应在/dev/stripe 中创建另外两个设备，除 st0 外还包括 st0a 和 st0c。此时，可以使用 newfs 在 st0a 上创建 UFS 文件系统。

    ```
    # newfs -U /dev/stripe/st0a
    ```

    许多数字将在屏幕上滑过，几秒钟后，该过程将完成。卷已创建并准备好挂载。
6. 要手动挂载创建的磁盘条带：

    ```
    # mount /dev/stripe/st0a /mnt
    ```
7. 在引导过程中自动挂载此条带文件系统，请将卷信息放在 /etc/fstab 中。在此示例中，创建了一个名为 stripe 的永久挂载点：

    ```
    # mkdir /stripe
    # echo "/dev/stripe/st0a /stripe ufs rw 2 2" \
    >> /etc/fstab
    ```
8. 还必须通过向 /boot/loader.conf 添加一行来在系统初始化期间自动加载 geom_stripe.ko 模块：

    ```
    # echo 'geom_stripe_load="YES"' >> /boot/loader.conf
    ```
