# 21.4.RAID3——带有专用奇偶校验的字节级条带

RAID3 是一种将多个磁盘驱动器组合成单个卷并带有专用奇偶校验磁盘的方法。在 RAID3 系统中，数据被分割为多个字节，这些字节被写入除了一个充当专用奇偶校验磁盘的磁盘外的所有驱动器中。这意味着从 RAID3 实现中读取磁盘会访问数组中的所有磁盘。通过使用多个磁盘控制器可以提高性能。RAID3 阵列提供了 1 个磁盘的容错能力，同时提供了阵列中所有驱动器总容量的 1 - 1/n 倍的容量，其中 n 是阵列中硬盘的数量。这样的配置大多适用于存储诸如多媒体文件等较大尺寸数据。

建立 RAID3 阵列需要至少 3 个物理硬盘驱动器。每个硬盘必须具有相同的大小，因为 I/O 请求被交错以并行读取或写入多个硬盘。此外，由于 RAID3 的特性，驱动器的数量必须等于 3、5、9、17 等，或者是 2^n + 1 的形式。

本节演示如何在 FreeBSD 系统上创建软件 RAID3。

|  | 虽然理论上可以在 FreeBSD 上从 RAID3 阵列引导，但这种配置并不常见，也不建议使用。|
| -- | ---------------------------------------------------------------------------------- |

### 创建专用 RAID3 阵列

在 FreeBSD 中，RAID3 的支持由 graid3(8) GEOM 类实现。在 FreeBSD 上创建专用 RAID3 阵列需要以下步骤。

1. 首先，通过以下命令加载 geom_raid3.ko 内核模块。

    ```
    # graid3 load
    ```

    或：

    ```
    # kldload geom_raid3
    ```
2. 确保存在适当的挂载点。此命令将创建一个新目录用作挂载点：

    ```
    # mkdir /multimedia
    ```
3. 确定要添加到阵列的磁盘的设备名称，并创建新的 RAID3 设备。列出的最终设备将充当专用奇偶校验盘。此示例使用三个未分区的 ATA 驱动器：ada1 和 ada2 用于数据，ada3 用于奇偶校验。

    ```
    # graid3 label -v gr0 /dev/ada1 /dev/ada2 /dev/ada3
    Metadata value stored on /dev/ada1.
    Metadata value stored on /dev/ada2.
    Metadata value stored on /dev/ada3.
    Done.
    ```
4. 将新创建的 gr0 设备分区，并在其上放置 UFS 文件系统：

    ```
    # gpart create -s GPT /dev/raid3/gr0
    # gpart add -t freebsd-ufs /dev/raid3/gr0
    # newfs -j /dev/raid3/gr0p1
    ```

    许多数字将在屏幕上滑动，经过一段时间后，过程将完成。卷已创建并准备好挂载：

    ```
    # mount /dev/raid3/gr0p1 /multimedia/
    ```

    RAID3 数组现在可以使用了。

需要额外的配置才能在系统重启后保留这个设置。

1. 在可以挂载阵列之前，必须加载 geom_raid3.ko 模块。要在系统初始化期间自动加载内核模块，请将以下行添加到 /boot/loader.conf 文件中：

    ```
    geom_raid3_load="YES"
    ```
2. 必须将以下卷信息添加到 /etc/fstab 文件中，以便在系统启动过程中自动挂载阵列的文件系统：

    ```
    /dev/raid3/gr0p1	/multimedia	ufs	rw	2	2
    ```
