# 21.5.软件 RAID 设备

一些主板和扩展卡可能会添加一些简单的硬件，通常只是一个只读存储器 (ROM)，可以让计算机从 RAID 阵列启动。启动后，对 RAID 阵列的访问由运行在计算机主处理器上的软件处理。这种“硬件辅助软件 RAID”提供的 RAID 阵列不依赖于任何特定操作系统，并且在加载操作系统之前即可正常运行。

支持多种 RAID 级别，具体取决于所使用的硬件。有关完整列表，请参阅 graid(8)。

graid(8)需要 geom_raid.ko 内核模块，该模块已包含在从 FreeBSD 9.1 开始的 GENERIC 内核中。如有需要，可以使用 graid load 手动加载。

### 创建阵列 21.5.1.

软件 RAID 设备通常在计算机启动时按下特定键进入菜单。菜单可用于创建和删除 RAID 阵列。graidd(8)也可以通过命令行直接创建阵列。

graid label 用于创建新的阵列。此示例中使用的主板具有 Intel 软件 RAID 芯片组，因此指定了 Intel 元数据格式。新阵列标记为 gm0，是镜像（RAID1），并使用驱动器 ada0 和 ada1。

|  | 当将驱动器制作成新阵列时，部分空间将被覆盖。请先备份现有数据！ |
| -- | ---------------------------------------------------------------- |

```
# graid label Intel gm0 RAID1 ada0 ada1
GEOM_RAID: Intel-a29ea104: Array Intel-a29ea104 created.
GEOM_RAID: Intel-a29ea104: Disk ada0 state changed from NONE to ACTIVE.
GEOM_RAID: Intel-a29ea104: Subdisk gm0:0-ada0 state changed from NONE to ACTIVE.
GEOM_RAID: Intel-a29ea104: Disk ada1 state changed from NONE to ACTIVE.
GEOM_RAID: Intel-a29ea104: Subdisk gm0:1-ada1 state changed from NONE to ACTIVE.
GEOM_RAID: Intel-a29ea104: Array started.
GEOM_RAID: Intel-a29ea104: Volume gm0 state changed from STARTING to OPTIMAL.
Intel-a29ea104 created
GEOM_RAID: Intel-a29ea104: Provider raid/r0 for volume gm0 created.
```

状态检查显示新的镜像已经准备就绪：

```
# graid status
   Name   Status  Components
raid/r0  OPTIMAL  ada0 (ACTIVE (ACTIVE))
                  ada1 (ACTIVE (ACTIVE))
```

阵列设备出现在/dev/raid/中。第一个阵列称为 r0。如果存在其他阵列，则将是 r1、r2 等。

一些设备的 BIOS 菜单可以创建带有特殊字符名称的阵列。为避免这些特殊字符带来问题，阵列被赋予简单的编号名称，如 r0。要显示实际标签，如上面示例中的 gm0，请使用 sysctl(8)：

```
# sysctl kern.geom.raid.name_format=1
```

### 21.5.2. 多卷

一些软件 RAID 设备支持在阵列上创建多个卷。卷类似于分区，能让将物理驱动器上的空间分割并以不同的方式使用。例如，Intel 软件 RAID 设备支持两个卷。这个示例创建了一个 40G 的镜像用于安全存储操作系统，接着是一个 20G 的 RAID0（条带）卷用于快速临时存储：

```
# graid label -S 40G Intel gm0 RAID1 ada0 ada1
# graid add -S 20G gm0 RAID0
```

卷会显示为 /dev/raid/ 下的额外 rX 条目。一个有两个卷的阵列将显示 r0 和 r1。

通过查看 graid(8) 可了解不同软件 RAID 设备支持的卷数。

### 21.5.3. 将单个驱动器转换为镜像

在特定条件下，可以将现有的单个驱动器转换为 graid(8) 阵列，而无需重新格式化。在转换过程中避免数据丢失，现有驱动器必须满足以下最低要求：

* 驱动器必须使用 MBR 分区方案进行分区。GPT 或其他在驱动器末尾具有元数据的分区方案将被 graid(8)元数据覆盖和损坏。
* 驱动器末尾必须有足够的未分区和未使用空间来容纳 graid(8)元数据。此元数据的大小不等，但最大的占用 64 M，因此建议至少有这么多的空闲空间。

如果驱动器符合这些要求，请先进行完整备份。然后使用该驱动器创建单驱动器镜像：

```
# graid label Intel gm0 RAID1 ada0 NONE
```

graid(8) 元数据被写入未使用空间的驱动器末尾。现在可以将第二个驱动器插入镜像：

```
# graid insert raid/r0 ada1
```

原始驱动器的数据将立即开始复制到第二个驱动器。在复制完成之前，镜像将以降级状态运行。

### 21.5.4. 将新驱动器插入阵列

驱动器可以插入阵列作为替换已损坏或丢失的驱动器。如果没有损坏或丢失的驱动器，则新驱动器将成为备用驱动器。例如，将新驱动器插入工作中的双驱镜像会导致一个带有一个备用驱动器的双驱镜像，而不是三驱镜像。

在示例镜像阵列中，数据立即开始复制到新插入的驱动器。新驱动器上的任何现有信息都将被覆盖。

```
# graid insert raid/r0 ada1
GEOM_RAID: Intel-a29ea104: Disk ada1 state changed from NONE to ACTIVE.
GEOM_RAID: Intel-a29ea104: Subdisk gm0:1-ada1 state changed from NONE to NEW.
GEOM_RAID: Intel-a29ea104: Subdisk gm0:1-ada1 state changed from NEW to REBUILD.
GEOM_RAID: Intel-a29ea104: Subdisk gm0:1-ada1 rebuild start at 0.
```

### 21.5.5. 从阵列中移除驱动器

个别驱动器可以永久从阵列中移除，它们的元数据将被擦除。

```
# graid remove raid/r0 ada1
GEOM_RAID: Intel-a29ea104: Disk ada1 state changed from ACTIVE to OFFLINE.
GEOM_RAID: Intel-a29ea104: Subdisk gm0:1-[unknown] state changed from ACTIVE to NONE.
GEOM_RAID: Intel-a29ea104: Volume gm0 state changed from OPTIMAL to DEGRADED.
```

### 21.5.6. 停止阵列

可以在不移除驱动器元数据的情况下停止阵列。系统重启时阵列会被重启。

```
# graid stop raid/r0
```

### 21.5.7. 检查阵列状态

随时可以检查阵列状态。在上面的示例中，将驱动器添加到镜像后，数据正在从原始驱动器复制到新驱动器：

```
# graid status
   Name    Status  Components
raid/r0  DEGRADED  ada0 (ACTIVE (ACTIVE))
                   ada1 (ACTIVE (REBUILD 28%))
```

某些类型的阵列，如 RAID0 或 CONCAT，如果磁盘故障，则可能不会显示在状态报告中。要查看这些部分故障的阵列，请添加 -ga ：

```
# graid status -ga
          Name  Status  Components
Intel-e2d07d9a  BROKEN  ada6 (ACTIVE (ACTIVE))
```

### 删除数组

通过删除所有卷来销毁数组。当最后一个卷被删除时，数组被停止，并且从驱动器中删除了元数据。

```
# graid delete raid/r0
```

### 删除意外数组

磁盘可能意外地包含了来自先前使用或制造商测试的 graid(8) 元数据。graid(8) 将检测到这些磁盘并创建一个阵列，从而干扰对单个磁盘的访问。要删除不需要的元数据：

1. 启动系统。在启动菜单中，选择 2 进入加载程序提示符。输入：

    ```
    OK set kern.geom.raid.enable=0
    OK boot
    ```

    系统将以禁用 graid(8) 的方式启动。
2. 备份受影响驱动器上的所有数据。
3. 作为解决方法，可以通过将其添加到/boot/loader.conf 来禁用 graid(8)数组检测。

    ```
    kern.geom.raid.enable=0
    ```

    添加到/boot/loader.conf。

    为了永久删除受影响驱动器上的 graid(8) 元数据，请引导 FreeBSD 安装 CD-ROM 或内存棒，并选择 Shell。使用 status 找到阵列的名称，通常为 raid/r0 ：

    ```
    # graid status
       Name   Status  Components
    raid/r0  OPTIMAL  ada0 (ACTIVE (ACTIVE))
                      ada1 (ACTIVE (ACTIVE))
    ```

    按名称删除卷：

    ```
    # graid delete raid/r0
    ```

    如果显示了多个卷，请对每个卷重复此过程。删除最后一个阵列后，卷将被销毁。

    重启并验证数据，如有必要，从备份中恢复。在元数据被移除后，/boot/loader.conf 中的 kern.geom.raid.enable=0 条目也可以被移除。
