# 21.6.GEOM Gate 网络设备

GEOM 通过使用 GEOM Gate 网络守护程序 ggated 提供对设备（如磁盘、CD 和文件系统）的远程访问提供了简单的机制。带有设备的系统运行服务器守护程序，该守护程序处理客户端使用 ggatec 发出的请求。设备不应包含任何敏感数据，因为客户端和服务器之间的连接未加密。

类似于 NFS，在网络文件系统（NFS）中讨论的方式，ggated 是使用 exports 文件进行配置的。此文件指定了允许访问导出资源的系统以及它们所提供的访问级别。例如，要为客户端 192.168.1.5 提供对第一个 SCSI 磁盘上的第四个分区的读写访问权限，请创建/etc/gg.exports 并添加以下行：

```
192.168.1.5 RW /dev/da0s4d
```

在导出设备之前，请确保它当前未挂载。然后，启动 ggated：

```
# ggated
```

可以选择多种选项来指定替代的监听port或更改 exports 文件的默认位置。有关详细信息，请参阅 ggated(8)。

要在客户机上访问导出的设备，首先使用 ggatec 指定服务器的 IP 地址和导出设备的设备名。如果成功，此命令将显示一个 ggate 设备名以进行挂载。在一个空闲的挂载点上挂载指定的设备名。此示例连接到 192.168.1.1 上的/dev/da0s4d 分区，然后在/mnt 上挂载/dev/ggate0：

```
# ggatec create -o rw 192.168.1.1 /dev/da0s4d
ggate0
# mount /dev/ggate0 /mnt
```

服务器上的设备现在可以通过客户端上的/mnt 访问。有关 ggatec 的更多详细信息和一些用法示例，请参阅 ggatec(8)。

|  | 如果设备当前已在服务器或网络上的任何其他客户端上挂载，挂载将失败。如果需要同时访问网络资源，请改用 NFS。|
| -- | ---------------------------------------------------------------------------------------------------------- |

当设备不再需要时，请使用 umount 将其卸载，以便资源可供其他客户端使用。
