# 21.7.为磁盘设备添加卷标

在系统初始化期间，FreeBSD 内核在发现设备时创建设备节点。这种探测设备的方法引发了一些问题。例如，如果通过 USB 添加了新的磁盘设备会怎样？很可能会将闪存设备分配给设备名称 da0，原始的 da0 则会转移到 da1。这将导致挂载文件系统时出现问题，如果它们在/etc/fstab 中列出，这也可能阻止系统启动。

一种解决办法是按顺序链接 SCSI 设备，以便 SCSI 卡添加新设备时将发出未使用的设备号。但是对于可能替换主要 SCSI 磁盘的 USB 设备呢？这是因为通常在 SCSI 卡之前探测 USB 设备。一个解决办法是只在系统引导后插入这些设备。另一种方法是仅使用单个 ATA 驱动器，并且永远不在/etc/fstab 中列出 SCSI 设备。

更好的解决方案是使用 glabel 来标记磁盘设备，并在/etc/fstab 中使用这些标签。由于 glabel 将标签存储在给定提供程序的最后一个扇区中，该标签将在重启后保持持久。通过使用此标签作为设备，无论通过什么设备节点访问，文件系统始终可以被挂载。

|  | glabel 可以创建临时标签和永久标签。只有永久标签在重启时保持一致。请参阅 glabel(8)了解标签之间的差异的更多信息。|
| -- | --------------------------------------------------------------------------------------------------------------------- |

### 21.7.1. 标签类型和示例

永久标签可以是通用标签或文件系统标签。可以使用 tunefs(8)或 newfs(8)创建永久文件系统标签。这些类型的标签将在/dev 的子目录中创建，并将根据文件系统类型命名。例如，UFS2 文件系统标签将在/dev/ufs 中创建。通用永久标签可以使用 glabel label 创建。这些标签不是特定于文件系统的，将在/dev/label 中创建。

临时标签将在下次重启时销毁。这些标签将在/dev/label 中创建，适合用于实验。可以使用 glabel create 创建临时标签。

要为 UFS2 文件系统创建一个永久标签而不破坏任何数据，请执行以下命令：

```
# tunefs -L home /dev/da3
```

/etc/fstab 中现在应该存在一个标签，可以添加到/dev/ufs 中：

```
/dev/ufs/home		/home            ufs     rw              2      2
```

|  | 在尝试运行 tunefs 时，文件系统不能被挂载。|
| -- | -------------------------------------------- |

现在可以挂载文件系统：

```
# mount /home
```

从这一点开始，只要 geom_label.ko 内核模块在引导时加载到/boot/loader.conf 或 GEOM_LABEL 内核选项存在，设备节点可以更改而不会对系统造成任何不良影响。

文件系统也可以通过使用 newfs 标志与 newfs 创建具有默认标签。有关更多信息，请参阅 newfs(8)。

可使用以下命令来销毁该标签：

```
# glabel destroy home
```

以下示例展示了如何为引导磁盘的分区设置标签。

示例 1. 在引导磁盘上标记分区

通过永久标记引导磁盘上的分区，即使将磁盘移至另一控制器或转移到不同系统，系统也应能正常启动。在本例中，假定使用单个 ATA 磁盘，系统当前将其识别为 ad0。还假定使用标准的 FreeBSD 分区方案，包括 /、/var、/usr 和 /tmp，以及交换分区。

重启系统，在 loader(8) 提示符处按 4 进入单用户模式。然后输入以下命令：

```
# glabel label rootfs /dev/ad0s1a
GEOM_LABEL: Label for provider /dev/ad0s1a is label/rootfs
# glabel label var /dev/ad0s1d
GEOM_LABEL: Label for provider /dev/ad0s1d is label/var
# glabel label usr /dev/ad0s1f
GEOM_LABEL: Label for provider /dev/ad0s1f is label/usr
# glabel label tmp /dev/ad0s1e
GEOM_LABEL: Label for provider /dev/ad0s1e is label/tmp
# glabel label swap /dev/ad0s1b
GEOM_LABEL: Label for provider /dev/ad0s1b is label/swap
# exit
```

系统将继续以多用户模式启动。启动完成后，编辑 /etc/fstab，并将传统设备名称替换为其相应的标签。最终的 /etc/fstab 将如下所示：

```
# Device                Mountpoint      FStype  Options         Dump    Pass#
/dev/label/swap         none            swap    sw              0       0
/dev/label/rootfs       /               ufs     rw              1       1
/dev/label/tmp          /tmp            ufs     rw              2       2
/dev/label/usr          /usr            ufs     rw              2       2
/dev/label/var          /var            ufs     rw              2       2
```

系统现在可以重启。如果一切顺利，它将正常启动，并显示 mount :

```
# mount
/dev/label/rootfs on / (ufs, local)
devfs on /dev (devfs, local)
/dev/label/tmp on /tmp (ufs, local, soft-updates)
/dev/label/usr on /usr (ufs, local, soft-updates)
/dev/label/var on /var (ufs, local, soft-updates)
```

glabel(8)类支持一种基于唯一文件系统 ID 的 UFS 文件系统标签类型，ufsid。这些标签可以在 /dev/ufsid 中找到，并在系统启动时自动生成。可以使用 ufsid 标签来挂载分区使用 /etc/fstab。使用 glabel status 来获取文件系统及其对应的 ufsid 标签列表:

```
% glabel status
                  Name  Status  Components
ufsid/486b6fc38d330916     N/A  ad4s1d
ufsid/486b6fc16926168e     N/A  ad4s1f
```

在上述示例中，ad4s1d 代表 /var，而 ad4s1f 代表 /usr。使用显示的 ufsid 值，现在可以通过在 /etc/fstab 中输入以下条目来挂载这些分区:

```
/dev/ufsid/486b6fc38d330916        /var        ufs        rw        2      2
/dev/ufsid/486b6fc16926168e        /usr        ufs        rw        2      2
```

任何带有 ufsid 标签的分区都可以通过这种方式挂载，无需手动创建永久标签，同时仍然可以享受独立设备名称挂载的好处。
