# 21.8.通过 GEOM 实现 UFS 日志

UFS 文件系统上期刊的支持在 FreeBSD 上可用。通过 GEOM 子系统提供实现，并使用 gjournal 进行配置。与其他文件系统期刊实现不同，gjournal 方法是基于块的，而不是作为文件系统的一部分实现。它是一种 GEOM 扩展。

记录文件系统事务的日志，例如组成完整磁盘写操作的更改，在元数据和文件写入提交到磁盘之前。可以回放此事务日志以重新执行文件系统事务，以防止文件系统不一致。

该方法提供了另一种机制来防止数据丢失和文件系统的不一致性。与跟踪和强制执行元数据更新的软更新不同，快照创建文件系统的映像，日志存储在专门用于此任务的磁盘空间中。为了提高性能，日志可能存储在另一个磁盘上。在这种配置中，应该在设备之后将日志提供程序或存储设备列在列表中，以便启用日志记录。

通用内核为 gjournal 提供支持。要在启动时自动加载 geom_journal.ko 内核模块，请将以下行添加到/boot/loader.conf 中：

```
geom_journal_load="YES"
```

如果使用定制内核，请确保在内核配置文件中包含以下行：

```
options	GEOM_JOURNAL
```

模块加载后，可以使用以下步骤在新文件系统上创建日志。在本例中，da4 是一个新的 SCSI 磁盘：

```
# gjournal load
# gjournal label /dev/da4
```

这将加载模块并在 /dev/da4 上创建一个 /dev/da4.journal 设备节点。

现在可以在日志设备上创建 UFS 文件系统，然后挂载到现有的挂载点上：

```
# newfs -O 2 -J /dev/da4.journal
# mount /dev/da4.journal /mnt
```

|  | 对于多个分区，将为每个单独的分区创建一个日志。例如，如果 ad4s1 和 ad4s2 都是分区，则 gjournal 将创建 ad4s1.journal 和 ad4s2.journal。|
| -- | --------------------------------------------------------------------------------------------------------------------------------------- |

也可以通过使用 tunefs 在当前文件系统上启用日志。但是，在尝试更改现有文件系统之前，始终要先备份。在大多数情况下，如果无法创建日志，则 gjournal 将失败，但这并不能防止因错误使用 tunefs 而导致的数据丢失。有关这些命令的更多信息，请参考 gjournal(8) 和 tunefs(8)。

可以对 FreeBSD 系统的启动磁盘进行日志记录。有关详细说明，请参阅文章《在台式电脑上实现 UFS 日志记录》。
